from _devbuild.gen.id_kind_asdl import Id_t

from asdl import const  # For const.NO_INTEGER
from asdl import runtime
from asdl.runtime import (
  PrettyLeaf, PrettyArray, PrettyNode,
  Color_TypeName, Color_StringConst, Color_OtherConst, Color_UserType,
)

from typing import Optional, List, Tuple, Dict, Any

class arg_vector(runtime.CompoundObj):
  __slots__ = ('strs', 'spids')

  def __init__(self, strs=None, spids=None):
    # type: (Optional[List[str]], Optional[List[int]]) -> None
    self.strs = strs or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arg_vector')
    L = out_node.fields

    if self.strs:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.strs:
        x0.children.append(PrettyLeaf(i0, Color_StringConst))
      L.append(('strs', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arg_vector')
    L = out_node.fields
    if self.strs:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.strs:
        x0.children.append(PrettyLeaf(i0, Color_StringConst))
      L.append(('strs', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class part_value_e(object):
  String = 1
  Array = 2

class part_value_t(runtime.CompoundObj):
  pass

class part_value__String(part_value_t):
  tag = 1
  __slots__ = ('s', 'do_split_glob', 'spids')

  def __init__(self, s=None, do_split_glob=None, spids=None):
    # type: (Optional[str], Optional[bool], Optional[List[int]]) -> None
    self.s = s
    self.do_split_glob = do_split_glob
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('part_value.String')
    L = out_node.fields

    x0 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x0))

    x1 = PrettyLeaf('T' if self.do_split_glob else 'F', Color_OtherConst)
    L.append(('do_split_glob', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('part_value.String')
    L = out_node.fields
    x0 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x0))

    x1 = PrettyLeaf('T' if self.do_split_glob else 'F', Color_OtherConst)
    L.append(('do_split_glob', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class part_value__Array(part_value_t):
  tag = 2
  __slots__ = ('strs', 'spids')

  def __init__(self, strs=None, spids=None):
    # type: (Optional[List[str]], Optional[List[int]]) -> None
    self.strs = strs or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('part_value.Array')
    L = out_node.fields

    if self.strs:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.strs:
        x0.children.append(PrettyLeaf(i0, Color_StringConst))
      L.append(('strs', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('part_value.Array')
    L = out_node.fields
    if self.strs:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.strs:
        x0.children.append(PrettyLeaf(i0, Color_StringConst))
      L.append(('strs', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class part_value(object):
  String = part_value__String
  Array = part_value__Array

class value_e(object):
  Undef = 1
  Str = 2
  StrArray = 3
  AssocArray = 4

class value_t(runtime.CompoundObj):
  pass

class value__Undef(value_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.Undef')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.Undef')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class value__Str(value_t):
  tag = 2
  __slots__ = ('s', 'spids')

  def __init__(self, s=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.s = s
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.Str')
    L = out_node.fields

    x0 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.Str')
    L = out_node.fields
    x0 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class value__StrArray(value_t):
  tag = 3
  __slots__ = ('strs', 'spids')

  def __init__(self, strs=None, spids=None):
    # type: (Optional[List[str]], Optional[List[int]]) -> None
    self.strs = strs or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.StrArray')
    L = out_node.fields

    if self.strs:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.strs:
        x0.children.append(PrettyLeaf(i0, Color_StringConst))
      L.append(('strs', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.StrArray')
    L = out_node.fields
    if self.strs:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.strs:
        x0.children.append(PrettyLeaf(i0, Color_StringConst))
      L.append(('strs', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class value__AssocArray(value_t):
  tag = 4
  __slots__ = ('d', 'spids')

  def __init__(self, d=None, spids=None):
    # type: (Optional[Dict[str, Any]], Optional[List[int]]) -> None
    self.d = d
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.AssocArray')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.d), Color_OtherConst)
    L.append(('d', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('value.AssocArray')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.d), Color_OtherConst)
    L.append(('d', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class value(object):
  Undef = value__Undef
  Str = value__Str
  StrArray = value__StrArray
  AssocArray = value__AssocArray

class cell(runtime.CompoundObj):
  __slots__ = ('val', 'exported', 'readonly', 'is_assoc_array')

  def __init__(self, val=None, exported=None, readonly=None,
               is_assoc_array=None):
    # type: (Optional[value_t], Optional[bool], Optional[bool], Optional[bool]) -> None
    self.val = val
    self.exported = exported
    self.readonly = readonly
    self.is_assoc_array = is_assoc_array

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('cell')
    L = out_node.fields

    assert self.val is not None
    x0 = self.val.PrettyTree()
    L.append(('val', x0))

    x1 = PrettyLeaf('T' if self.exported else 'F', Color_OtherConst)
    L.append(('exported', x1))

    x2 = PrettyLeaf('T' if self.readonly else 'F', Color_OtherConst)
    L.append(('readonly', x2))

    x3 = PrettyLeaf('T' if self.is_assoc_array else 'F', Color_OtherConst)
    L.append(('is_assoc_array', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('cell')
    L = out_node.fields
    assert self.val is not None
    x0 = self.val.AbbreviatedTree()
    L.append(('val', x0))

    x1 = PrettyLeaf('T' if self.exported else 'F', Color_OtherConst)
    L.append(('exported', x1))

    x2 = PrettyLeaf('T' if self.readonly else 'F', Color_OtherConst)
    L.append(('readonly', x2))

    x3 = PrettyLeaf('T' if self.is_assoc_array else 'F', Color_OtherConst)
    L.append(('is_assoc_array', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class var_flags_t(runtime.SimpleObj):
  pass

class var_flags_e(object):
  Exported = var_flags_t(1, 'Exported')
  ReadOnly = var_flags_t(2, 'ReadOnly')
  AssocArray = var_flags_t(3, 'AssocArray')
  Global = var_flags_t(4, 'Global')

class scope_t(runtime.SimpleObj):
  pass

class scope_e(object):
  TempEnv = scope_t(1, 'TempEnv')
  LocalOnly = scope_t(2, 'LocalOnly')
  GlobalOnly = scope_t(3, 'GlobalOnly')
  Dynamic = scope_t(4, 'Dynamic')

class lvalue_e(object):
  LhsName = 1
  LhsIndexedName = 2

class lvalue_t(runtime.CompoundObj):
  pass

class lvalue__LhsName(lvalue_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lvalue.LhsName')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lvalue.LhsName')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class lvalue__LhsIndexedName(lvalue_t):
  tag = 2
  __slots__ = ('name', 'index', 'spids')

  def __init__(self, name=None, index=None, spids=None):
    # type: (Optional[str], Optional[int], Optional[List[int]]) -> None
    self.name = name
    self.index = index
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lvalue.LhsIndexedName')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    x1 = PrettyLeaf(str(self.index), Color_OtherConst)
    L.append(('index', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lvalue.LhsIndexedName')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    x1 = PrettyLeaf(str(self.index), Color_OtherConst)
    L.append(('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class lvalue(object):
  LhsName = lvalue__LhsName
  LhsIndexedName = lvalue__LhsIndexedName

class redirect_e(object):
  PathRedirect = 1
  DescRedirect = 2
  HereRedirect = 3

class redirect_t(runtime.CompoundObj):
  pass

class redirect__PathRedirect(redirect_t):
  tag = 1
  __slots__ = ('op_id', 'fd', 'filename', 'op_spid', 'spids')

  def __init__(self, op_id=None, fd=None, filename=None, op_spid=None,
               spids=None):
    # type: (Optional[Id_t], Optional[int], Optional[str], Optional[int], Optional[List[int]]) -> None
    self.op_id = op_id
    self.fd = fd
    self.filename = filename
    self.op_spid = op_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redirect.PathRedirect')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    x2 = PrettyLeaf(self.filename, Color_StringConst)
    L.append(('filename', x2))

    x3 = PrettyLeaf(str(self.op_spid), Color_OtherConst)
    L.append(('op_spid', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redirect.PathRedirect')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    x2 = PrettyLeaf(self.filename, Color_StringConst)
    L.append(('filename', x2))

    x3 = PrettyLeaf(str(self.op_spid), Color_OtherConst)
    L.append(('op_spid', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class redirect__DescRedirect(redirect_t):
  tag = 2
  __slots__ = ('op_id', 'fd', 'target_fd', 'op_spid', 'spids')

  def __init__(self, op_id=None, fd=None, target_fd=None, op_spid=None,
               spids=None):
    # type: (Optional[Id_t], Optional[int], Optional[int], Optional[int], Optional[List[int]]) -> None
    self.op_id = op_id
    self.fd = fd
    self.target_fd = target_fd
    self.op_spid = op_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redirect.DescRedirect')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    x2 = PrettyLeaf(str(self.target_fd), Color_OtherConst)
    L.append(('target_fd', x2))

    x3 = PrettyLeaf(str(self.op_spid), Color_OtherConst)
    L.append(('op_spid', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redirect.DescRedirect')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    x2 = PrettyLeaf(str(self.target_fd), Color_OtherConst)
    L.append(('target_fd', x2))

    x3 = PrettyLeaf(str(self.op_spid), Color_OtherConst)
    L.append(('op_spid', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class redirect__HereRedirect(redirect_t):
  tag = 3
  __slots__ = ('fd', 'body', 'op_spid', 'spids')

  def __init__(self, fd=None, body=None, op_spid=None, spids=None):
    # type: (Optional[int], Optional[str], Optional[int], Optional[List[int]]) -> None
    self.fd = fd
    self.body = body
    self.op_spid = op_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redirect.HereRedirect')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x0))

    x1 = PrettyLeaf(self.body, Color_StringConst)
    L.append(('body', x1))

    x2 = PrettyLeaf(str(self.op_spid), Color_OtherConst)
    L.append(('op_spid', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redirect.HereRedirect')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x0))

    x1 = PrettyLeaf(self.body, Color_StringConst)
    L.append(('body', x1))

    x2 = PrettyLeaf(str(self.op_spid), Color_OtherConst)
    L.append(('op_spid', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class redirect(object):
  PathRedirect = redirect__PathRedirect
  DescRedirect = redirect__DescRedirect
  HereRedirect = redirect__HereRedirect

class job_status_e(object):
  ProcessStatus = 1
  PipelineStatus = 2

class job_status_t(runtime.CompoundObj):
  pass

class job_status__ProcessStatus(job_status_t):
  tag = 1
  __slots__ = ('status', 'spids')

  def __init__(self, status=None, spids=None):
    # type: (Optional[int], Optional[List[int]]) -> None
    self.status = status
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('job_status.ProcessStatus')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.status), Color_OtherConst)
    L.append(('status', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('job_status.ProcessStatus')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.status), Color_OtherConst)
    L.append(('status', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class job_status__PipelineStatus(job_status_t):
  tag = 2
  __slots__ = ('statuses', 'spids')

  def __init__(self, statuses=None, spids=None):
    # type: (Optional[List[int]], Optional[List[int]]) -> None
    self.statuses = statuses or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('job_status.PipelineStatus')
    L = out_node.fields

    if self.statuses:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.statuses:
        x0.children.append(PrettyLeaf(str(i0), Color_OtherConst))
      L.append(('statuses', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('job_status.PipelineStatus')
    L = out_node.fields
    if self.statuses:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.statuses:
        x0.children.append(PrettyLeaf(str(i0), Color_OtherConst))
      L.append(('statuses', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class job_status(object):
  ProcessStatus = job_status__ProcessStatus
  PipelineStatus = job_status__PipelineStatus

class span_t(runtime.SimpleObj):
  pass

class span_e(object):
  Black = span_t(1, 'Black')
  Delim = span_t(2, 'Delim')
  Backslash = span_t(3, 'Backslash')

class emit_t(runtime.SimpleObj):
  pass

class emit_e(object):
  Part = emit_t(1, 'Part')
  Delim = emit_t(2, 'Delim')
  Empty = emit_t(3, 'Empty')
  Escape = emit_t(4, 'Escape')
  Nothing = emit_t(5, 'Nothing')

class state_t(runtime.SimpleObj):
  pass

class state_e(object):
  Invalid = state_t(1, 'Invalid')
  Start = state_t(2, 'Start')
  DE_White1 = state_t(3, 'DE_White1')
  DE_Gray = state_t(4, 'DE_Gray')
  DE_White2 = state_t(5, 'DE_White2')
  Black = state_t(6, 'Black')
  Backslash = state_t(7, 'Backslash')

class char_kind_t(runtime.SimpleObj):
  pass

class char_kind_e(object):
  DE_White = char_kind_t(1, 'DE_White')
  DE_Gray = char_kind_t(2, 'DE_Gray')
  Black = char_kind_t(3, 'Black')
  Backslash = char_kind_t(4, 'Backslash')

class builtin_t(runtime.SimpleObj):
  pass

class builtin_e(object):
  NONE = builtin_t(1, 'NONE')
  READ = builtin_t(2, 'READ')
  ECHO = builtin_t(3, 'ECHO')
  PRINTF = builtin_t(4, 'PRINTF')
  SHIFT = builtin_t(5, 'SHIFT')
  CD = builtin_t(6, 'CD')
  PWD = builtin_t(7, 'PWD')
  PUSHD = builtin_t(8, 'PUSHD')
  POPD = builtin_t(9, 'POPD')
  DIRS = builtin_t(10, 'DIRS')
  EXPORT = builtin_t(11, 'EXPORT')
  UNSET = builtin_t(12, 'UNSET')
  SET = builtin_t(13, 'SET')
  SHOPT = builtin_t(14, 'SHOPT')
  TRAP = builtin_t(15, 'TRAP')
  UMASK = builtin_t(16, 'UMASK')
  SOURCE = builtin_t(17, 'SOURCE')
  DOT = builtin_t(18, 'DOT')
  EVAL = builtin_t(19, 'EVAL')
  EXEC = builtin_t(20, 'EXEC')
  WAIT = builtin_t(21, 'WAIT')
  JOBS = builtin_t(22, 'JOBS')
  COMPLETE = builtin_t(23, 'COMPLETE')
  COMPGEN = builtin_t(24, 'COMPGEN')
  COMPOPT = builtin_t(25, 'COMPOPT')
  COMPADJUST = builtin_t(26, 'COMPADJUST')
  TRUE = builtin_t(27, 'TRUE')
  FALSE = builtin_t(28, 'FALSE')
  COLON = builtin_t(29, 'COLON')
  TEST = builtin_t(30, 'TEST')
  BRACKET = builtin_t(31, 'BRACKET')
  GETOPTS = builtin_t(32, 'GETOPTS')
  COMMAND = builtin_t(33, 'COMMAND')
  TYPE = builtin_t(34, 'TYPE')
  HELP = builtin_t(35, 'HELP')
  HISTORY = builtin_t(36, 'HISTORY')
  DECLARE = builtin_t(37, 'DECLARE')
  TYPESET = builtin_t(38, 'TYPESET')
  ALIAS = builtin_t(39, 'ALIAS')
  UNALIAS = builtin_t(40, 'UNALIAS')
  REPR = builtin_t(41, 'REPR')
  BUILTIN = builtin_t(42, 'BUILTIN')

class effect_t(runtime.SimpleObj):
  pass

class effect_e(object):
  SpliceParts = effect_t(1, 'SpliceParts')
  Error = effect_t(2, 'Error')
  SpliceAndAssign = effect_t(3, 'SpliceAndAssign')
  NoOp = effect_t(4, 'NoOp')

class process_state_t(runtime.SimpleObj):
  pass

class process_state_e(object):
  Init = process_state_t(1, 'Init')
  Done = process_state_t(2, 'Done')

class word_style_t(runtime.SimpleObj):
  pass

class word_style_e(object):
  Expr = word_style_t(1, 'Expr')
  Unquoted = word_style_t(2, 'Unquoted')
  DQ = word_style_t(3, 'DQ')
  SQ = word_style_t(4, 'SQ')

