from _devbuild.gen.id_kind_asdl import Id_t

from asdl import const  # For const.NO_INTEGER
from asdl import runtime
from asdl.runtime import (
  PrettyLeaf, PrettyArray, PrettyNode,
  Color_TypeName, Color_StringConst, Color_OtherConst, Color_UserType,
)

from typing import Optional, List, Tuple, Dict, Any

class parse_result_e(object):
  EmptyLine = 1
  Eof = 2
  Node = 3

class parse_result_t(runtime.CompoundObj):
  pass

class parse_result__EmptyLine(parse_result_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('parse_result.EmptyLine')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('parse_result.EmptyLine')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class parse_result__Eof(parse_result_t):
  tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('parse_result.Eof')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('parse_result.Eof')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class parse_result__Node(parse_result_t):
  tag = 3
  __slots__ = ('cmd', 'spids')

  def __init__(self, cmd=None, spids=None):
    # type: (Optional[command_t], Optional[List[int]]) -> None
    self.cmd = cmd
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('parse_result.Node')
    L = out_node.fields

    assert self.cmd is not None
    x0 = self.cmd.PrettyTree()
    L.append(('cmd', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('parse_result.Node')
    L = out_node.fields
    assert self.cmd is not None
    x0 = self.cmd.AbbreviatedTree()
    L.append(('cmd', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class parse_result(object):
  EmptyLine = parse_result__EmptyLine
  Eof = parse_result__Eof
  Node = parse_result__Node

class source_e(object):
  Interactive = 1
  Unused = 2
  CFlag = 3
  Stdin = 4
  MainFile = 5
  SourcedFile = 6
  ArgvWord = 7
  ArgvCommand = 8
  EvalArg = 9
  Trap = 10
  Variable = 11
  Alias = 12
  Backticks = 13
  LValue = 14

class source_t(runtime.CompoundObj):
  pass

class source__Interactive(source_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Interactive')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Interactive')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__Unused(source_t):
  tag = 2
  __slots__ = ('comment', 'spids')

  def __init__(self, comment=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.comment = comment
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Unused')
    L = out_node.fields

    x0 = PrettyLeaf(self.comment, Color_StringConst)
    L.append(('comment', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Unused')
    L = out_node.fields
    x0 = PrettyLeaf(self.comment, Color_StringConst)
    L.append(('comment', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__CFlag(source_t):
  tag = 3
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.CFlag')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.CFlag')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__Stdin(source_t):
  tag = 4
  __slots__ = ('comment', 'spids')

  def __init__(self, comment=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.comment = comment
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Stdin')
    L = out_node.fields

    x0 = PrettyLeaf(self.comment, Color_StringConst)
    L.append(('comment', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Stdin')
    L = out_node.fields
    x0 = PrettyLeaf(self.comment, Color_StringConst)
    L.append(('comment', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__MainFile(source_t):
  tag = 5
  __slots__ = ('path', 'spids')

  def __init__(self, path=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.path = path
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.MainFile')
    L = out_node.fields

    x0 = PrettyLeaf(self.path, Color_StringConst)
    L.append(('path', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.MainFile')
    L = out_node.fields
    x0 = PrettyLeaf(self.path, Color_StringConst)
    L.append(('path', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__SourcedFile(source_t):
  tag = 6
  __slots__ = ('path', 'spid', 'spids')

  def __init__(self, path=None, spid=None, spids=None):
    # type: (Optional[str], Optional[int], Optional[List[int]]) -> None
    self.path = path
    self.spid = spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.SourcedFile')
    L = out_node.fields

    x0 = PrettyLeaf(self.path, Color_StringConst)
    L.append(('path', x0))

    x1 = PrettyLeaf(str(self.spid), Color_OtherConst)
    L.append(('spid', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.SourcedFile')
    L = out_node.fields
    x0 = PrettyLeaf(self.path, Color_StringConst)
    L.append(('path', x0))

    x1 = PrettyLeaf(str(self.spid), Color_OtherConst)
    L.append(('spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__ArgvWord(source_t):
  tag = 7
  __slots__ = ('word_spid', 'spids')

  def __init__(self, word_spid=None, spids=None):
    # type: (Optional[int], Optional[List[int]]) -> None
    self.word_spid = word_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.ArgvWord')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.word_spid), Color_OtherConst)
    L.append(('word_spid', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.ArgvWord')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.word_spid), Color_OtherConst)
    L.append(('word_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__ArgvCommand(source_t):
  tag = 8
  __slots__ = ('first_spid', 'spids')

  def __init__(self, first_spid=None, spids=None):
    # type: (Optional[int], Optional[List[int]]) -> None
    self.first_spid = first_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.ArgvCommand')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.first_spid), Color_OtherConst)
    L.append(('first_spid', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.ArgvCommand')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.first_spid), Color_OtherConst)
    L.append(('first_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__EvalArg(source_t):
  tag = 9
  __slots__ = ('eval_spid', 'spids')

  def __init__(self, eval_spid=None, spids=None):
    # type: (Optional[int], Optional[List[int]]) -> None
    self.eval_spid = eval_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.EvalArg')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.eval_spid), Color_OtherConst)
    L.append(('eval_spid', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.EvalArg')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.eval_spid), Color_OtherConst)
    L.append(('eval_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__Trap(source_t):
  tag = 10
  __slots__ = ('word_spid', 'spids')

  def __init__(self, word_spid=None, spids=None):
    # type: (Optional[int], Optional[List[int]]) -> None
    self.word_spid = word_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Trap')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.word_spid), Color_OtherConst)
    L.append(('word_spid', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Trap')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.word_spid), Color_OtherConst)
    L.append(('word_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__Variable(source_t):
  tag = 11
  __slots__ = ('assigned', 'spids')

  def __init__(self, assigned=None, spids=None):
    # type: (Optional[extent], Optional[List[int]]) -> None
    self.assigned = assigned
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Variable')
    L = out_node.fields

    assert self.assigned is not None
    x0 = self.assigned.PrettyTree()
    L.append(('assigned', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Variable')
    L = out_node.fields
    assert self.assigned is not None
    x0 = self.assigned.AbbreviatedTree()
    L.append(('assigned', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__Alias(source_t):
  tag = 12
  __slots__ = ('argv0', 'argv0_spid', 'spids')

  def __init__(self, argv0=None, argv0_spid=None, spids=None):
    # type: (Optional[str], Optional[int], Optional[List[int]]) -> None
    self.argv0 = argv0
    self.argv0_spid = argv0_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Alias')
    L = out_node.fields

    x0 = PrettyLeaf(self.argv0, Color_StringConst)
    L.append(('argv0', x0))

    x1 = PrettyLeaf(str(self.argv0_spid), Color_OtherConst)
    L.append(('argv0_spid', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Alias')
    L = out_node.fields
    x0 = PrettyLeaf(self.argv0, Color_StringConst)
    L.append(('argv0', x0))

    x1 = PrettyLeaf(str(self.argv0_spid), Color_OtherConst)
    L.append(('argv0_spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__Backticks(source_t):
  tag = 13
  __slots__ = ('left_spid', 'right_spid', 'spids')

  def __init__(self, left_spid=None, right_spid=None, spids=None):
    # type: (Optional[int], Optional[int], Optional[List[int]]) -> None
    self.left_spid = left_spid
    self.right_spid = right_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Backticks')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.left_spid), Color_OtherConst)
    L.append(('left_spid', x0))

    x1 = PrettyLeaf(str(self.right_spid), Color_OtherConst)
    L.append(('right_spid', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.Backticks')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.left_spid), Color_OtherConst)
    L.append(('left_spid', x0))

    x1 = PrettyLeaf(str(self.right_spid), Color_OtherConst)
    L.append(('right_spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source__LValue(source_t):
  tag = 14
  __slots__ = ('left_spid', 'right_spid', 'spids')

  def __init__(self, left_spid=None, right_spid=None, spids=None):
    # type: (Optional[int], Optional[int], Optional[List[int]]) -> None
    self.left_spid = left_spid
    self.right_spid = right_spid
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.LValue')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.left_spid), Color_OtherConst)
    L.append(('left_spid', x0))

    x1 = PrettyLeaf(str(self.right_spid), Color_OtherConst)
    L.append(('right_spid', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('source.LValue')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.left_spid), Color_OtherConst)
    L.append(('left_spid', x0))

    x1 = PrettyLeaf(str(self.right_spid), Color_OtherConst)
    L.append(('right_spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class source(object):
  Interactive = source__Interactive
  Unused = source__Unused
  CFlag = source__CFlag
  Stdin = source__Stdin
  MainFile = source__MainFile
  SourcedFile = source__SourcedFile
  ArgvWord = source__ArgvWord
  ArgvCommand = source__ArgvCommand
  EvalArg = source__EvalArg
  Trap = source__Trap
  Variable = source__Variable
  Alias = source__Alias
  Backticks = source__Backticks
  LValue = source__LValue

class position(runtime.CompoundObj):
  __slots__ = ('line_id', 'col')

  def __init__(self, line_id=None, col=None):
    # type: (Optional[int], Optional[int]) -> None
    self.line_id = line_id
    self.col = col

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('position')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.line_id), Color_OtherConst)
    L.append(('line_id', x0))

    x1 = PrettyLeaf(str(self.col), Color_OtherConst)
    L.append(('col', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('position')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.line_id), Color_OtherConst)
    L.append(('line_id', x0))

    x1 = PrettyLeaf(str(self.col), Color_OtherConst)
    L.append(('col', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class line_span(runtime.CompoundObj):
  __slots__ = ('line_id', 'col', 'length')

  def __init__(self, line_id=None, col=None, length=None):
    # type: (Optional[int], Optional[int], Optional[int]) -> None
    self.line_id = line_id
    self.col = col
    self.length = length

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('line_span')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.line_id), Color_OtherConst)
    L.append(('line_id', x0))

    x1 = PrettyLeaf(str(self.col), Color_OtherConst)
    L.append(('col', x1))

    x2 = PrettyLeaf(str(self.length), Color_OtherConst)
    L.append(('length', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('line_span')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.line_id), Color_OtherConst)
    L.append(('line_id', x0))

    x1 = PrettyLeaf(str(self.col), Color_OtherConst)
    L.append(('col', x1))

    x2 = PrettyLeaf(str(self.length), Color_OtherConst)
    L.append(('length', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class extent(runtime.CompoundObj):
  __slots__ = ('s_line_id', 's_col', 'e_line_id', 'e_col')

  def __init__(self, s_line_id=None, s_col=None, e_line_id=None, e_col=None):
    # type: (Optional[int], Optional[int], Optional[int], Optional[int]) -> None
    self.s_line_id = s_line_id
    self.s_col = s_col
    self.e_line_id = e_line_id
    self.e_col = e_col

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('extent')
    L = out_node.fields

    x0 = PrettyLeaf(str(self.s_line_id), Color_OtherConst)
    L.append(('s_line_id', x0))

    x1 = PrettyLeaf(str(self.s_col), Color_OtherConst)
    L.append(('s_col', x1))

    x2 = PrettyLeaf(str(self.e_line_id), Color_OtherConst)
    L.append(('e_line_id', x2))

    x3 = PrettyLeaf(str(self.e_col), Color_OtherConst)
    L.append(('e_col', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('extent')
    L = out_node.fields
    x0 = PrettyLeaf(str(self.s_line_id), Color_OtherConst)
    L.append(('s_line_id', x0))

    x1 = PrettyLeaf(str(self.s_col), Color_OtherConst)
    L.append(('s_col', x1))

    x2 = PrettyLeaf(str(self.e_line_id), Color_OtherConst)
    L.append(('e_line_id', x2))

    x3 = PrettyLeaf(str(self.e_col), Color_OtherConst)
    L.append(('e_col', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class token(runtime.CompoundObj):
  __slots__ = ('id', 'val', 'span_id')

  def __init__(self, id=None, val=None, span_id=None):
    # type: (Optional[Id_t], Optional[str], Optional[int]) -> None
    self.id = id
    self.val = val
    self.span_id = span_id

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('token')
    L = out_node.fields

    assert self.id is not None
    x0 = PrettyLeaf(self.id.name, Color_UserType)
    L.append(('id', x0))

    x1 = PrettyLeaf(self.val, Color_StringConst)
    L.append(('val', x1))

    x2 = PrettyLeaf(str(self.span_id), Color_OtherConst)
    L.append(('span_id', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('token')
    L = out_node.fields
    assert self.id is not None
    x0 = PrettyLeaf(self.id.name, Color_UserType)
    L.append(('id', x0))

    x1 = PrettyLeaf(self.val, Color_StringConst)
    L.append(('val', x1))

    x2 = PrettyLeaf(str(self.span_id), Color_OtherConst)
    L.append(('span_id', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _token(self)
    return p if p else self._AbbreviatedTree()

class bracket_op_e(object):
  WholeArray = 1
  ArrayIndex = 2

class bracket_op_t(runtime.CompoundObj):
  pass

class bracket_op__WholeArray(bracket_op_t):
  tag = 1
  __slots__ = ('op_id', 'spids')

  def __init__(self, op_id=None, spids=None):
    # type: (Optional[Id_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bracket_op.WholeArray')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bracket_op.WholeArray')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bracket_op__ArrayIndex(bracket_op_t):
  tag = 2
  __slots__ = ('expr', 'spids')

  def __init__(self, expr=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[List[int]]) -> None
    self.expr = expr
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bracket_op.ArrayIndex')
    L = out_node.fields

    assert self.expr is not None
    x0 = self.expr.PrettyTree()
    L.append(('expr', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bracket_op.ArrayIndex')
    L = out_node.fields
    assert self.expr is not None
    x0 = self.expr.AbbreviatedTree()
    L.append(('expr', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bracket_op(object):
  WholeArray = bracket_op__WholeArray
  ArrayIndex = bracket_op__ArrayIndex

class suffix_op_e(object):
  StringNullary = 1
  StringUnary = 2
  PatSub = 3
  Slice = 4

class suffix_op_t(runtime.CompoundObj):
  pass

class suffix_op__StringNullary(suffix_op_t):
  tag = 1
  __slots__ = ('op_id', 'spids')

  def __init__(self, op_id=None, spids=None):
    # type: (Optional[Id_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.StringNullary')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.StringNullary')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class suffix_op__StringUnary(suffix_op_t):
  tag = 2
  __slots__ = ('op_id', 'arg_word', 'spids')

  def __init__(self, op_id=None, arg_word=None, spids=None):
    # type: (Optional[Id_t], Optional[word_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.arg_word = arg_word
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.StringUnary')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.arg_word is not None
    x1 = self.arg_word.PrettyTree()
    L.append(('arg_word', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.StringUnary')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.arg_word is not None
    x1 = self.arg_word.AbbreviatedTree()
    L.append(('arg_word', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class suffix_op__PatSub(suffix_op_t):
  tag = 3
  __slots__ = ('pat', 'replace', 'replace_mode', 'spids')

  def __init__(self, pat=None, replace=None, replace_mode=None, spids=None):
    # type: (Optional[word_t], Optional[word_t], Optional[Id_t], Optional[List[int]]) -> None
    self.pat = pat
    self.replace = replace or None
    self.replace_mode = replace_mode
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.PatSub')
    L = out_node.fields

    assert self.pat is not None
    x0 = self.pat.PrettyTree()
    L.append(('pat', x0))

    if self.replace is not None:  # MaybeType
      x1 = self.replace.PrettyTree()
      L.append(('replace', x1))

    assert self.replace_mode is not None
    x2 = PrettyLeaf(self.replace_mode.name, Color_UserType)
    L.append(('replace_mode', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.PatSub')
    L = out_node.fields
    assert self.pat is not None
    x0 = self.pat.AbbreviatedTree()
    L.append(('pat', x0))

    if self.replace is not None:  # MaybeType
      x1 = self.replace.AbbreviatedTree()
      L.append(('replace', x1))

    assert self.replace_mode is not None
    x2 = PrettyLeaf(self.replace_mode.name, Color_UserType)
    L.append(('replace_mode', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class suffix_op__Slice(suffix_op_t):
  tag = 4
  __slots__ = ('begin', 'length', 'spids')

  def __init__(self, begin=None, length=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.begin = begin or None
    self.length = length or None
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.Slice')
    L = out_node.fields

    if self.begin is not None:  # MaybeType
      x0 = self.begin.PrettyTree()
      L.append(('begin', x0))

    if self.length is not None:  # MaybeType
      x1 = self.length.PrettyTree()
      L.append(('length', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('suffix_op.Slice')
    L = out_node.fields
    if self.begin is not None:  # MaybeType
      x0 = self.begin.AbbreviatedTree()
      L.append(('begin', x0))

    if self.length is not None:  # MaybeType
      x1 = self.length.AbbreviatedTree()
      L.append(('length', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class suffix_op(object):
  StringNullary = suffix_op__StringNullary
  StringUnary = suffix_op__StringUnary
  PatSub = suffix_op__PatSub
  Slice = suffix_op__Slice

class array_item_e(object):
  ArrayWord = 1
  ArrayPair = 2

class array_item_t(runtime.CompoundObj):
  pass

class array_item__ArrayWord(array_item_t):
  tag = 1
  __slots__ = ('w', 'spids')

  def __init__(self, w=None, spids=None):
    # type: (Optional[word_t], Optional[List[int]]) -> None
    self.w = w
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('array_item.ArrayWord')
    L = out_node.fields

    assert self.w is not None
    x0 = self.w.PrettyTree()
    L.append(('w', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('array_item.ArrayWord')
    L = out_node.fields
    assert self.w is not None
    x0 = self.w.AbbreviatedTree()
    L.append(('w', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class array_item__ArrayPair(array_item_t):
  tag = 2
  __slots__ = ('key', 'value', 'spids')

  def __init__(self, key=None, value=None, spids=None):
    # type: (Optional[word_t], Optional[word_t], Optional[List[int]]) -> None
    self.key = key
    self.value = value
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('array_item.ArrayPair')
    L = out_node.fields

    assert self.key is not None
    x0 = self.key.PrettyTree()
    L.append(('key', x0))

    assert self.value is not None
    x1 = self.value.PrettyTree()
    L.append(('value', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('array_item.ArrayPair')
    L = out_node.fields
    assert self.key is not None
    x0 = self.key.AbbreviatedTree()
    L.append(('key', x0))

    assert self.value is not None
    x1 = self.value.AbbreviatedTree()
    L.append(('value', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class array_item(object):
  ArrayWord = array_item__ArrayWord
  ArrayPair = array_item__ArrayPair

class word_part_e(object):
  ArrayLiteralPart = 1
  LiteralPart = 2
  EscapedLiteralPart = 3
  SingleQuotedPart = 4
  DoubleQuotedPart = 5
  SimpleVarSub = 6
  BracedVarSub = 7
  TildeSubPart = 8
  CommandSubPart = 9
  ArithSubPart = 10
  BracedTuple = 11
  BracedRange = 12
  ExtGlobPart = 13

class word_part_t(runtime.CompoundObj):
  pass

class word_part__ArrayLiteralPart(word_part_t):
  tag = 1
  __slots__ = ('words', 'spids')

  def __init__(self, words=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[int]]) -> None
    self.words = words or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.ArrayLiteralPart')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(('words', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.ArrayLiteralPart')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('words', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__LiteralPart(word_part_t):
  tag = 2
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.LiteralPart')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.LiteralPart')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _word_part__LiteralPart(self)
    return p if p else self._AbbreviatedTree()

class word_part__EscapedLiteralPart(word_part_t):
  tag = 3
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.EscapedLiteralPart')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.EscapedLiteralPart')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__SingleQuotedPart(word_part_t):
  tag = 4
  __slots__ = ('left', 'tokens', 'spids')

  def __init__(self, left=None, tokens=None, spids=None):
    # type: (Optional[token], Optional[List[token]], Optional[List[int]]) -> None
    self.left = left
    self.tokens = tokens or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.SingleQuotedPart')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    if self.tokens:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.tokens:
        x1.children.append(i1.PrettyTree())
      L.append(('tokens', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.SingleQuotedPart')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    if self.tokens:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.tokens:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('tokens', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _word_part__SingleQuotedPart(self)
    return p if p else self._AbbreviatedTree()

class word_part__DoubleQuotedPart(word_part_t):
  tag = 5
  __slots__ = ('parts', 'spids')

  def __init__(self, parts=None, spids=None):
    # type: (Optional[List[word_part_t]], Optional[List[int]]) -> None
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.DoubleQuotedPart')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(('parts', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.DoubleQuotedPart')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _word_part__DoubleQuotedPart(self)
    return p if p else self._AbbreviatedTree()

class word_part__SimpleVarSub(word_part_t):
  tag = 6
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.SimpleVarSub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.SimpleVarSub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _word_part__SimpleVarSub(self)
    return p if p else self._AbbreviatedTree()

class word_part__BracedVarSub(word_part_t):
  tag = 7
  __slots__ = ('token', 'prefix_op', 'bracket_op', 'suffix_op', 'spids')

  def __init__(self, token=None, prefix_op=None, bracket_op=None,
               suffix_op=None, spids=None):
    # type: (Optional[token], Optional[Id_t], Optional[bracket_op_t], Optional[suffix_op_t], Optional[List[int]]) -> None
    self.token = token
    self.prefix_op = prefix_op or None
    self.bracket_op = bracket_op or None
    self.suffix_op = suffix_op or None
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.BracedVarSub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.prefix_op is not None:  # MaybeType
      x1 = PrettyLeaf(self.prefix_op.name, Color_UserType)
      L.append(('prefix_op', x1))

    if self.bracket_op is not None:  # MaybeType
      x2 = self.bracket_op.PrettyTree()
      L.append(('bracket_op', x2))

    if self.suffix_op is not None:  # MaybeType
      x3 = self.suffix_op.PrettyTree()
      L.append(('suffix_op', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.BracedVarSub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    if self.prefix_op is not None:  # MaybeType
      x1 = PrettyLeaf(self.prefix_op.name, Color_UserType)
      L.append(('prefix_op', x1))

    if self.bracket_op is not None:  # MaybeType
      x2 = self.bracket_op.AbbreviatedTree()
      L.append(('bracket_op', x2))

    if self.suffix_op is not None:  # MaybeType
      x3 = self.suffix_op.AbbreviatedTree()
      L.append(('suffix_op', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _word_part__BracedVarSub(self)
    return p if p else self._AbbreviatedTree()

class word_part__TildeSubPart(word_part_t):
  tag = 8
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.TildeSubPart')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.TildeSubPart')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__CommandSubPart(word_part_t):
  tag = 9
  __slots__ = ('command_list', 'left_token', 'spids')

  def __init__(self, command_list=None, left_token=None, spids=None):
    # type: (Optional[command_t], Optional[token], Optional[List[int]]) -> None
    self.command_list = command_list
    self.left_token = left_token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.CommandSubPart')
    L = out_node.fields

    assert self.command_list is not None
    x0 = self.command_list.PrettyTree()
    L.append(('command_list', x0))

    assert self.left_token is not None
    x1 = self.left_token.PrettyTree()
    L.append(('left_token', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.CommandSubPart')
    L = out_node.fields
    assert self.command_list is not None
    x0 = self.command_list.AbbreviatedTree()
    L.append(('command_list', x0))

    assert self.left_token is not None
    x1 = self.left_token.AbbreviatedTree()
    L.append(('left_token', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__ArithSubPart(word_part_t):
  tag = 10
  __slots__ = ('anode', 'spids')

  def __init__(self, anode=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[List[int]]) -> None
    self.anode = anode
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.ArithSubPart')
    L = out_node.fields

    assert self.anode is not None
    x0 = self.anode.PrettyTree()
    L.append(('anode', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.ArithSubPart')
    L = out_node.fields
    assert self.anode is not None
    x0 = self.anode.AbbreviatedTree()
    L.append(('anode', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__BracedTuple(word_part_t):
  tag = 11
  __slots__ = ('words', 'spids')

  def __init__(self, words=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[int]]) -> None
    self.words = words or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.BracedTuple')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(('words', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.BracedTuple')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('words', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__BracedRange(word_part_t):
  tag = 12
  __slots__ = ('kind', 'start', 'end', 'step', 'spids')

  def __init__(self, kind=None, start=None, end=None, step=None, spids=None):
    # type: (Optional[Id_t], Optional[str], Optional[str], Optional[int], Optional[List[int]]) -> None
    self.kind = kind
    self.start = start
    self.end = end
    self.step = step or const.NO_INTEGER
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.BracedRange')
    L = out_node.fields

    assert self.kind is not None
    x0 = PrettyLeaf(self.kind.name, Color_UserType)
    L.append(('kind', x0))

    x1 = PrettyLeaf(self.start, Color_StringConst)
    L.append(('start', x1))

    x2 = PrettyLeaf(self.end, Color_StringConst)
    L.append(('end', x2))

    if self.step is not None:  # MaybeType
      x3 = PrettyLeaf(str(self.step), Color_OtherConst)
      L.append(('step', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.BracedRange')
    L = out_node.fields
    assert self.kind is not None
    x0 = PrettyLeaf(self.kind.name, Color_UserType)
    L.append(('kind', x0))

    x1 = PrettyLeaf(self.start, Color_StringConst)
    L.append(('start', x1))

    x2 = PrettyLeaf(self.end, Color_StringConst)
    L.append(('end', x2))

    if self.step is not None:  # MaybeType
      x3 = PrettyLeaf(str(self.step), Color_OtherConst)
      L.append(('step', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part__ExtGlobPart(word_part_t):
  tag = 13
  __slots__ = ('op', 'arms', 'spids')

  def __init__(self, op=None, arms=None, spids=None):
    # type: (Optional[token], Optional[List[word_t]], Optional[List[int]]) -> None
    self.op = op
    self.arms = arms or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.ExtGlobPart')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(('op', x0))

    if self.arms:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.arms:
        x1.children.append(i1.PrettyTree())
      L.append(('arms', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word_part.ExtGlobPart')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(('op', x0))

    if self.arms:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.arms:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('arms', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word_part(object):
  ArrayLiteralPart = word_part__ArrayLiteralPart
  LiteralPart = word_part__LiteralPart
  EscapedLiteralPart = word_part__EscapedLiteralPart
  SingleQuotedPart = word_part__SingleQuotedPart
  DoubleQuotedPart = word_part__DoubleQuotedPart
  SimpleVarSub = word_part__SimpleVarSub
  BracedVarSub = word_part__BracedVarSub
  TildeSubPart = word_part__TildeSubPart
  CommandSubPart = word_part__CommandSubPart
  ArithSubPart = word_part__ArithSubPart
  BracedTuple = word_part__BracedTuple
  BracedRange = word_part__BracedRange
  ExtGlobPart = word_part__ExtGlobPart

class word_e(object):
  EmptyWord = 1
  TokenWord = 2
  CompoundWord = 3
  BracedWordTree = 4
  StringWord = 5

class word_t(runtime.CompoundObj):
  pass

class word__EmptyWord(word_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.EmptyWord')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.EmptyWord')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word__TokenWord(word_t):
  tag = 2
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.TokenWord')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.TokenWord')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word__CompoundWord(word_t):
  tag = 3
  __slots__ = ('parts', 'spids')

  def __init__(self, parts=None, spids=None):
    # type: (Optional[List[word_part_t]], Optional[List[int]]) -> None
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.CompoundWord')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(('parts', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.CompoundWord')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _word__CompoundWord(self)
    return p if p else self._AbbreviatedTree()

class word__BracedWordTree(word_t):
  tag = 4
  __slots__ = ('parts', 'spids')

  def __init__(self, parts=None, spids=None):
    # type: (Optional[List[word_part_t]], Optional[List[int]]) -> None
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.BracedWordTree')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(('parts', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.BracedWordTree')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word__StringWord(word_t):
  tag = 5
  __slots__ = ('id', 's', 'spids')

  def __init__(self, id=None, s=None, spids=None):
    # type: (Optional[Id_t], Optional[str], Optional[List[int]]) -> None
    self.id = id
    self.s = s
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.StringWord')
    L = out_node.fields

    assert self.id is not None
    x0 = PrettyLeaf(self.id.name, Color_UserType)
    L.append(('id', x0))

    x1 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('word.StringWord')
    L = out_node.fields
    assert self.id is not None
    x0 = PrettyLeaf(self.id.name, Color_UserType)
    L.append(('id', x0))

    x1 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class word(object):
  EmptyWord = word__EmptyWord
  TokenWord = word__TokenWord
  CompoundWord = word__CompoundWord
  BracedWordTree = word__BracedWordTree
  StringWord = word__StringWord

class lhs_expr_e(object):
  LhsName = 1
  LhsIndexedName = 2
  CompatIndexedName = 3

class lhs_expr_t(runtime.CompoundObj):
  pass

class lhs_expr__LhsName(lhs_expr_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lhs_expr.LhsName')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lhs_expr.LhsName')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class lhs_expr__LhsIndexedName(lhs_expr_t):
  tag = 2
  __slots__ = ('name', 'index', 'spids')

  def __init__(self, name=None, index=None, spids=None):
    # type: (Optional[str], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.name = name
    self.index = index
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lhs_expr.LhsIndexedName')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    assert self.index is not None
    x1 = self.index.PrettyTree()
    L.append(('index', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lhs_expr.LhsIndexedName')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    assert self.index is not None
    x1 = self.index.AbbreviatedTree()
    L.append(('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class lhs_expr__CompatIndexedName(lhs_expr_t):
  tag = 3
  __slots__ = ('name', 'index', 'spids')

  def __init__(self, name=None, index=None, spids=None):
    # type: (Optional[str], Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.index = index
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lhs_expr.CompatIndexedName')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    x1 = PrettyLeaf(self.index, Color_StringConst)
    L.append(('index', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('lhs_expr.CompatIndexedName')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    x1 = PrettyLeaf(self.index, Color_StringConst)
    L.append(('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class lhs_expr(object):
  LhsName = lhs_expr__LhsName
  LhsIndexedName = lhs_expr__LhsIndexedName
  CompatIndexedName = lhs_expr__CompatIndexedName

class arith_expr_e(object):
  ArithVarRef = 1
  ArithWord = 2
  UnaryAssign = 3
  BinaryAssign = 4
  ArithUnary = 5
  ArithBinary = 6
  TernaryOp = 7
  FuncCall = 8

class arith_expr_t(runtime.CompoundObj):
  pass

class arith_expr__ArithVarRef(arith_expr_t):
  tag = 1
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithVarRef')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithVarRef')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__ArithWord(arith_expr_t):
  tag = 2
  __slots__ = ('w', 'spids')

  def __init__(self, w=None, spids=None):
    # type: (Optional[word_t], Optional[List[int]]) -> None
    self.w = w
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithWord')
    L = out_node.fields

    assert self.w is not None
    x0 = self.w.PrettyTree()
    L.append(('w', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithWord')
    L = out_node.fields
    assert self.w is not None
    x0 = self.w.AbbreviatedTree()
    L.append(('w', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__UnaryAssign(arith_expr_t):
  tag = 3
  __slots__ = ('op_id', 'child', 'spids')

  def __init__(self, op_id=None, child=None, spids=None):
    # type: (Optional[Id_t], Optional[lhs_expr_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.UnaryAssign')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(('child', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.UnaryAssign')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__BinaryAssign(arith_expr_t):
  tag = 4
  __slots__ = ('op_id', 'left', 'right', 'spids')

  def __init__(self, op_id=None, left=None, right=None, spids=None):
    # type: (Optional[Id_t], Optional[lhs_expr_t], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.left = left
    self.right = right
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.BinaryAssign')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(('right', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.BinaryAssign')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__ArithUnary(arith_expr_t):
  tag = 5
  __slots__ = ('op_id', 'child', 'spids')

  def __init__(self, op_id=None, child=None, spids=None):
    # type: (Optional[Id_t], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithUnary')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(('child', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithUnary')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__ArithBinary(arith_expr_t):
  tag = 6
  __slots__ = ('op_id', 'left', 'right', 'spids')

  def __init__(self, op_id=None, left=None, right=None, spids=None):
    # type: (Optional[Id_t], Optional[arith_expr_t], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.left = left
    self.right = right
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithBinary')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(('right', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.ArithBinary')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__TernaryOp(arith_expr_t):
  tag = 7
  __slots__ = ('cond', 'true_expr', 'false_expr', 'spids')

  def __init__(self, cond=None, true_expr=None, false_expr=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[arith_expr_t], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.cond = cond
    self.true_expr = true_expr
    self.false_expr = false_expr
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.TernaryOp')
    L = out_node.fields

    assert self.cond is not None
    x0 = self.cond.PrettyTree()
    L.append(('cond', x0))

    assert self.true_expr is not None
    x1 = self.true_expr.PrettyTree()
    L.append(('true_expr', x1))

    assert self.false_expr is not None
    x2 = self.false_expr.PrettyTree()
    L.append(('false_expr', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.TernaryOp')
    L = out_node.fields
    assert self.cond is not None
    x0 = self.cond.AbbreviatedTree()
    L.append(('cond', x0))

    assert self.true_expr is not None
    x1 = self.true_expr.AbbreviatedTree()
    L.append(('true_expr', x1))

    assert self.false_expr is not None
    x2 = self.false_expr.AbbreviatedTree()
    L.append(('false_expr', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr__FuncCall(arith_expr_t):
  tag = 8
  __slots__ = ('func', 'args', 'spids')

  def __init__(self, func=None, args=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[List[arith_expr_t]], Optional[List[int]]) -> None
    self.func = func
    self.args = args or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.FuncCall')
    L = out_node.fields

    assert self.func is not None
    x0 = self.func.PrettyTree()
    L.append(('func', x0))

    if self.args:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.args:
        x1.children.append(i1.PrettyTree())
      L.append(('args', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('arith_expr.FuncCall')
    L = out_node.fields
    assert self.func is not None
    x0 = self.func.AbbreviatedTree()
    L.append(('func', x0))

    if self.args:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.args:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('args', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class arith_expr(object):
  ArithVarRef = arith_expr__ArithVarRef
  ArithWord = arith_expr__ArithWord
  UnaryAssign = arith_expr__UnaryAssign
  BinaryAssign = arith_expr__BinaryAssign
  ArithUnary = arith_expr__ArithUnary
  ArithBinary = arith_expr__ArithBinary
  TernaryOp = arith_expr__TernaryOp
  FuncCall = arith_expr__FuncCall

class bool_expr_e(object):
  WordTest = 1
  BoolBinary = 2
  BoolUnary = 3
  LogicalNot = 4
  LogicalAnd = 5
  LogicalOr = 6

class bool_expr_t(runtime.CompoundObj):
  pass

class bool_expr__WordTest(bool_expr_t):
  tag = 1
  __slots__ = ('w', 'spids')

  def __init__(self, w=None, spids=None):
    # type: (Optional[word_t], Optional[List[int]]) -> None
    self.w = w
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.WordTest')
    L = out_node.fields

    assert self.w is not None
    x0 = self.w.PrettyTree()
    L.append(('w', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.WordTest')
    L = out_node.fields
    assert self.w is not None
    x0 = self.w.AbbreviatedTree()
    L.append(('w', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bool_expr__BoolBinary(bool_expr_t):
  tag = 2
  __slots__ = ('op_id', 'left', 'right', 'spids')

  def __init__(self, op_id=None, left=None, right=None, spids=None):
    # type: (Optional[Id_t], Optional[word_t], Optional[word_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.left = left
    self.right = right
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.BoolBinary')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(('right', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.BoolBinary')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bool_expr__BoolUnary(bool_expr_t):
  tag = 3
  __slots__ = ('op_id', 'child', 'spids')

  def __init__(self, op_id=None, child=None, spids=None):
    # type: (Optional[Id_t], Optional[word_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.BoolUnary')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(('child', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.BoolUnary')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bool_expr__LogicalNot(bool_expr_t):
  tag = 4
  __slots__ = ('child', 'spids')

  def __init__(self, child=None, spids=None):
    # type: (Optional[bool_expr_t], Optional[List[int]]) -> None
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.LogicalNot')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(('child', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.LogicalNot')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(('child', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bool_expr__LogicalAnd(bool_expr_t):
  tag = 5
  __slots__ = ('left', 'right', 'spids')

  def __init__(self, left=None, right=None, spids=None):
    # type: (Optional[bool_expr_t], Optional[bool_expr_t], Optional[List[int]]) -> None
    self.left = left
    self.right = right
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.LogicalAnd')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    assert self.right is not None
    x1 = self.right.PrettyTree()
    L.append(('right', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.LogicalAnd')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    assert self.right is not None
    x1 = self.right.AbbreviatedTree()
    L.append(('right', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bool_expr__LogicalOr(bool_expr_t):
  tag = 6
  __slots__ = ('left', 'right', 'spids')

  def __init__(self, left=None, right=None, spids=None):
    # type: (Optional[bool_expr_t], Optional[bool_expr_t], Optional[List[int]]) -> None
    self.left = left
    self.right = right
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.LogicalOr')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    assert self.right is not None
    x1 = self.right.PrettyTree()
    L.append(('right', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('bool_expr.LogicalOr')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    assert self.right is not None
    x1 = self.right.AbbreviatedTree()
    L.append(('right', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class bool_expr(object):
  WordTest = bool_expr__WordTest
  BoolBinary = bool_expr__BoolBinary
  BoolUnary = bool_expr__BoolUnary
  LogicalNot = bool_expr__LogicalNot
  LogicalAnd = bool_expr__LogicalAnd
  LogicalOr = bool_expr__LogicalOr

class redir_e(object):
  Redir = 1
  HereDoc = 2

class redir_t(runtime.CompoundObj):
  pass

class redir__Redir(redir_t):
  tag = 1
  __slots__ = ('op', 'fd', 'arg_word', 'spids')

  def __init__(self, op=None, fd=None, arg_word=None, spids=None):
    # type: (Optional[token], Optional[int], Optional[word_t], Optional[List[int]]) -> None
    self.op = op
    self.fd = fd
    self.arg_word = arg_word
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redir.Redir')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(('op', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    assert self.arg_word is not None
    x2 = self.arg_word.PrettyTree()
    L.append(('arg_word', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redir.Redir')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(('op', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    assert self.arg_word is not None
    x2 = self.arg_word.AbbreviatedTree()
    L.append(('arg_word', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class redir__HereDoc(redir_t):
  tag = 2
  __slots__ = ('op', 'fd', 'here_begin', 'here_end_span_id', 'stdin_parts',
               'spids')

  def __init__(self, op=None, fd=None, here_begin=None, here_end_span_id=None,
               stdin_parts=None, spids=None):
    # type: (Optional[token], Optional[int], Optional[word_t], Optional[int], Optional[List[word_part_t]], Optional[List[int]]) -> None
    self.op = op
    self.fd = fd
    self.here_begin = here_begin
    self.here_end_span_id = here_end_span_id
    self.stdin_parts = stdin_parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redir.HereDoc')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(('op', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    assert self.here_begin is not None
    x2 = self.here_begin.PrettyTree()
    L.append(('here_begin', x2))

    x3 = PrettyLeaf(str(self.here_end_span_id), Color_OtherConst)
    L.append(('here_end_span_id', x3))

    if self.stdin_parts:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.stdin_parts:
        x4.children.append(i4.PrettyTree())
      L.append(('stdin_parts', x4))

    if self.spids:  # ArrayType
      x5 = PrettyArray()
      for i5 in self.spids:
        x5.children.append(PrettyLeaf(str(i5), Color_OtherConst))
      L.append(('spids', x5))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('redir.HereDoc')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(('op', x0))

    x1 = PrettyLeaf(str(self.fd), Color_OtherConst)
    L.append(('fd', x1))

    assert self.here_begin is not None
    x2 = self.here_begin.AbbreviatedTree()
    L.append(('here_begin', x2))

    x3 = PrettyLeaf(str(self.here_end_span_id), Color_OtherConst)
    L.append(('here_end_span_id', x3))

    if self.stdin_parts:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.stdin_parts:
        x4.children.append(i4.AbbreviatedTree())
      L.append(('stdin_parts', x4))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class redir(object):
  Redir = redir__Redir
  HereDoc = redir__HereDoc

class assign_op_t(runtime.SimpleObj):
  pass

class assign_op_e(object):
  Equal = assign_op_t(1, 'Equal')
  PlusEqual = assign_op_t(2, 'PlusEqual')

class assign_pair(runtime.CompoundObj):
  __slots__ = ('lhs', 'op', 'rhs', 'spids')

  def __init__(self, lhs=None, op=None, rhs=None, spids=None):
    # type: (Optional[lhs_expr_t], Optional[assign_op_t], Optional[word_t], Optional[List[int]]) -> None
    self.lhs = lhs
    self.op = op
    self.rhs = rhs or None
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('assign_pair')
    L = out_node.fields

    assert self.lhs is not None
    x0 = self.lhs.PrettyTree()
    L.append(('lhs', x0))

    assert self.op is not None
    x1 = PrettyLeaf(self.op.name, Color_TypeName)
    L.append(('op', x1))

    if self.rhs is not None:  # MaybeType
      x2 = self.rhs.PrettyTree()
      L.append(('rhs', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('assign_pair')
    L = out_node.fields
    assert self.lhs is not None
    x0 = self.lhs.AbbreviatedTree()
    L.append(('lhs', x0))

    assert self.op is not None
    x1 = PrettyLeaf(self.op.name, Color_TypeName)
    L.append(('op', x1))

    if self.rhs is not None:  # MaybeType
      x2 = self.rhs.AbbreviatedTree()
      L.append(('rhs', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class env_pair(runtime.CompoundObj):
  __slots__ = ('name', 'val', 'spids')

  def __init__(self, name=None, val=None, spids=None):
    # type: (Optional[str], Optional[word_t], Optional[List[int]]) -> None
    self.name = name
    self.val = val
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('env_pair')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    assert self.val is not None
    x1 = self.val.PrettyTree()
    L.append(('val', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('env_pair')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    assert self.val is not None
    x1 = self.val.AbbreviatedTree()
    L.append(('val', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class case_arm(runtime.CompoundObj):
  __slots__ = ('pat_list', 'action', 'spids')

  def __init__(self, pat_list=None, action=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[command_t]], Optional[List[int]]) -> None
    self.pat_list = pat_list or []
    self.action = action or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('case_arm')
    L = out_node.fields

    if self.pat_list:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.pat_list:
        x0.children.append(i0.PrettyTree())
      L.append(('pat_list', x0))

    if self.action:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.action:
        x1.children.append(i1.PrettyTree())
      L.append(('action', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('case_arm')
    L = out_node.fields
    if self.pat_list:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.pat_list:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('pat_list', x0))

    if self.action:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.action:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('action', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class if_arm(runtime.CompoundObj):
  __slots__ = ('cond', 'action', 'spids')

  def __init__(self, cond=None, action=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[command_t]], Optional[List[int]]) -> None
    self.cond = cond or []
    self.action = action or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('if_arm')
    L = out_node.fields

    if self.cond:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.cond:
        x0.children.append(i0.PrettyTree())
      L.append(('cond', x0))

    if self.action:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.action:
        x1.children.append(i1.PrettyTree())
      L.append(('action', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('if_arm')
    L = out_node.fields
    if self.cond:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.cond:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('cond', x0))

    if self.action:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.action:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('action', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class iterable_e(object):
  IterArgv = 1
  IterArray = 2

class iterable_t(runtime.CompoundObj):
  pass

class iterable__IterArgv(iterable_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('iterable.IterArgv')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('iterable.IterArgv')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class iterable__IterArray(iterable_t):
  tag = 2
  __slots__ = ('words', 'spids')

  def __init__(self, words=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[int]]) -> None
    self.words = words or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('iterable.IterArray')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(('words', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('iterable.IterArray')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('words', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class iterable(object):
  IterArgv = iterable__IterArgv
  IterArray = iterable__IterArray

class command_e(object):
  NoOp = 1
  SimpleCommand = 2
  ExpandedAlias = 3
  Sentence = 4
  Assignment = 5
  OilAssign = 6
  ControlFlow = 7
  Pipeline = 8
  AndOr = 9
  DoGroup = 10
  BraceGroup = 11
  Subshell = 12
  DParen = 13
  DBracket = 14
  ForEach = 15
  ForExpr = 16
  WhileUntil = 17
  If = 18
  Case = 19
  FuncDef = 20
  TimeBlock = 21
  CommandList = 22

class command_t(runtime.CompoundObj):
  pass

class command__NoOp(command_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.NoOp')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.NoOp')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__SimpleCommand(command_t):
  tag = 2
  __slots__ = ('words', 'redirects', 'more_env', 'spids')

  def __init__(self, words=None, redirects=None, more_env=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[redir_t]], Optional[List[env_pair]], Optional[List[int]]) -> None
    self.words = words or []
    self.redirects = redirects or []
    self.more_env = more_env or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.SimpleCommand')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(('words', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.more_env:
        x2.children.append(i2.PrettyTree())
      L.append(('more_env', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.SimpleCommand')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('words', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.more_env:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('more_env', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    p = _command__SimpleCommand(self)
    return p if p else self._AbbreviatedTree()

class command__ExpandedAlias(command_t):
  tag = 3
  __slots__ = ('child', 'redirects', 'more_env', 'spids')

  def __init__(self, child=None, redirects=None, more_env=None, spids=None):
    # type: (Optional[command_t], Optional[List[redir_t]], Optional[List[env_pair]], Optional[List[int]]) -> None
    self.child = child
    self.redirects = redirects or []
    self.more_env = more_env or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ExpandedAlias')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(('child', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.more_env:
        x2.children.append(i2.PrettyTree())
      L.append(('more_env', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ExpandedAlias')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(('child', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.more_env:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('more_env', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__Sentence(command_t):
  tag = 4
  __slots__ = ('child', 'terminator', 'spids')

  def __init__(self, child=None, terminator=None, spids=None):
    # type: (Optional[command_t], Optional[token], Optional[List[int]]) -> None
    self.child = child
    self.terminator = terminator
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Sentence')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(('child', x0))

    assert self.terminator is not None
    x1 = self.terminator.PrettyTree()
    L.append(('terminator', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Sentence')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(('child', x0))

    assert self.terminator is not None
    x1 = self.terminator.AbbreviatedTree()
    L.append(('terminator', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__Assignment(command_t):
  tag = 5
  __slots__ = ('keyword', 'flags', 'pairs', 'spids')

  def __init__(self, keyword=None, flags=None, pairs=None, spids=None):
    # type: (Optional[Id_t], Optional[List[str]], Optional[List[assign_pair]], Optional[List[int]]) -> None
    self.keyword = keyword
    self.flags = flags or []
    self.pairs = pairs or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Assignment')
    L = out_node.fields

    assert self.keyword is not None
    x0 = PrettyLeaf(self.keyword.name, Color_UserType)
    L.append(('keyword', x0))

    if self.flags:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.flags:
        x1.children.append(PrettyLeaf(i1, Color_StringConst))
      L.append(('flags', x1))

    if self.pairs:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.pairs:
        x2.children.append(i2.PrettyTree())
      L.append(('pairs', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Assignment')
    L = out_node.fields
    assert self.keyword is not None
    x0 = PrettyLeaf(self.keyword.name, Color_UserType)
    L.append(('keyword', x0))

    if self.flags:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.flags:
        x1.children.append(PrettyLeaf(i1, Color_StringConst))
      L.append(('flags', x1))

    if self.pairs:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.pairs:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('pairs', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__OilAssign(command_t):
  tag = 6
  __slots__ = ('keyword', 'lvalue', 'op', 'rhs', 'spids')

  def __init__(self, keyword=None, lvalue=None, op=None, rhs=None, spids=None):
    # type: (Optional[token], Optional[expr_t], Optional[token], Optional[expr_t], Optional[List[int]]) -> None
    self.keyword = keyword or None
    self.lvalue = lvalue
    self.op = op
    self.rhs = rhs
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.OilAssign')
    L = out_node.fields

    if self.keyword is not None:  # MaybeType
      x0 = self.keyword.PrettyTree()
      L.append(('keyword', x0))

    assert self.lvalue is not None
    x1 = self.lvalue.PrettyTree()
    L.append(('lvalue', x1))

    assert self.op is not None
    x2 = self.op.PrettyTree()
    L.append(('op', x2))

    assert self.rhs is not None
    x3 = self.rhs.PrettyTree()
    L.append(('rhs', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.OilAssign')
    L = out_node.fields
    if self.keyword is not None:  # MaybeType
      x0 = self.keyword.AbbreviatedTree()
      L.append(('keyword', x0))

    assert self.lvalue is not None
    x1 = self.lvalue.AbbreviatedTree()
    L.append(('lvalue', x1))

    assert self.op is not None
    x2 = self.op.AbbreviatedTree()
    L.append(('op', x2))

    assert self.rhs is not None
    x3 = self.rhs.AbbreviatedTree()
    L.append(('rhs', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__ControlFlow(command_t):
  tag = 7
  __slots__ = ('token', 'arg_word', 'spids')

  def __init__(self, token=None, arg_word=None, spids=None):
    # type: (Optional[token], Optional[word_t], Optional[List[int]]) -> None
    self.token = token
    self.arg_word = arg_word or None
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ControlFlow')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.arg_word is not None:  # MaybeType
      x1 = self.arg_word.PrettyTree()
      L.append(('arg_word', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ControlFlow')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    if self.arg_word is not None:  # MaybeType
      x1 = self.arg_word.AbbreviatedTree()
      L.append(('arg_word', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__Pipeline(command_t):
  tag = 8
  __slots__ = ('children', 'negated', 'stderr_indices', 'spids')

  def __init__(self, children=None, negated=None, stderr_indices=None,
               spids=None):
    # type: (Optional[List[command_t]], Optional[bool], Optional[List[int]], Optional[List[int]]) -> None
    self.children = children or []
    self.negated = negated
    self.stderr_indices = stderr_indices or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Pipeline')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(('children', x0))

    x1 = PrettyLeaf('T' if self.negated else 'F', Color_OtherConst)
    L.append(('negated', x1))

    if self.stderr_indices:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.stderr_indices:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('stderr_indices', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Pipeline')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('children', x0))

    x1 = PrettyLeaf('T' if self.negated else 'F', Color_OtherConst)
    L.append(('negated', x1))

    if self.stderr_indices:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.stderr_indices:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('stderr_indices', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__AndOr(command_t):
  tag = 9
  __slots__ = ('ops', 'children', 'spids')

  def __init__(self, ops=None, children=None, spids=None):
    # type: (Optional[List[Id_t]], Optional[List[command_t]], Optional[List[int]]) -> None
    self.ops = ops or []
    self.children = children or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.AndOr')
    L = out_node.fields

    if self.ops:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.ops:
        x0.children.append(PrettyLeaf(i0.name, Color_UserType))
      L.append(('ops', x0))

    if self.children:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.children:
        x1.children.append(i1.PrettyTree())
      L.append(('children', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.AndOr')
    L = out_node.fields
    if self.ops:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.ops:
        x0.children.append(PrettyLeaf(i0.name, Color_UserType))
      L.append(('ops', x0))

    if self.children:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.children:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('children', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__DoGroup(command_t):
  tag = 10
  __slots__ = ('children', 'redirects', 'spids')

  def __init__(self, children=None, redirects=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.children = children or []
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.DoGroup')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(('children', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.DoGroup')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('children', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__BraceGroup(command_t):
  tag = 11
  __slots__ = ('children', 'redirects', 'spids')

  def __init__(self, children=None, redirects=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.children = children or []
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.BraceGroup')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(('children', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.BraceGroup')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('children', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__Subshell(command_t):
  tag = 12
  __slots__ = ('command_list', 'redirects', 'spids')

  def __init__(self, command_list=None, redirects=None, spids=None):
    # type: (Optional[command_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.command_list = command_list
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Subshell')
    L = out_node.fields

    assert self.command_list is not None
    x0 = self.command_list.PrettyTree()
    L.append(('command_list', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Subshell')
    L = out_node.fields
    assert self.command_list is not None
    x0 = self.command_list.AbbreviatedTree()
    L.append(('command_list', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__DParen(command_t):
  tag = 13
  __slots__ = ('child', 'redirects', 'spids')

  def __init__(self, child=None, redirects=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.child = child
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.DParen')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(('child', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.DParen')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(('child', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__DBracket(command_t):
  tag = 14
  __slots__ = ('expr', 'redirects', 'spids')

  def __init__(self, expr=None, redirects=None, spids=None):
    # type: (Optional[bool_expr_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.expr = expr
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.DBracket')
    L = out_node.fields

    assert self.expr is not None
    x0 = self.expr.PrettyTree()
    L.append(('expr', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.DBracket')
    L = out_node.fields
    assert self.expr is not None
    x0 = self.expr.AbbreviatedTree()
    L.append(('expr', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__ForEach(command_t):
  tag = 15
  __slots__ = ('iter_name', 'iter_words', 'do_arg_iter', 'body', 'redirects',
               'spids')

  def __init__(self, iter_name=None, iter_words=None, do_arg_iter=None,
               body=None, redirects=None, spids=None):
    # type: (Optional[str], Optional[List[word_t]], Optional[bool], Optional[command_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.iter_name = iter_name
    self.iter_words = iter_words or []
    self.do_arg_iter = do_arg_iter
    self.body = body
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ForEach')
    L = out_node.fields

    x0 = PrettyLeaf(self.iter_name, Color_StringConst)
    L.append(('iter_name', x0))

    if self.iter_words:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.iter_words:
        x1.children.append(i1.PrettyTree())
      L.append(('iter_words', x1))

    x2 = PrettyLeaf('T' if self.do_arg_iter else 'F', Color_OtherConst)
    L.append(('do_arg_iter', x2))

    assert self.body is not None
    x3 = self.body.PrettyTree()
    L.append(('body', x3))

    if self.redirects:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.redirects:
        x4.children.append(i4.PrettyTree())
      L.append(('redirects', x4))

    if self.spids:  # ArrayType
      x5 = PrettyArray()
      for i5 in self.spids:
        x5.children.append(PrettyLeaf(str(i5), Color_OtherConst))
      L.append(('spids', x5))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ForEach')
    L = out_node.fields
    x0 = PrettyLeaf(self.iter_name, Color_StringConst)
    L.append(('iter_name', x0))

    if self.iter_words:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.iter_words:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('iter_words', x1))

    x2 = PrettyLeaf('T' if self.do_arg_iter else 'F', Color_OtherConst)
    L.append(('do_arg_iter', x2))

    assert self.body is not None
    x3 = self.body.AbbreviatedTree()
    L.append(('body', x3))

    if self.redirects:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.redirects:
        x4.children.append(i4.AbbreviatedTree())
      L.append(('redirects', x4))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__ForExpr(command_t):
  tag = 16
  __slots__ = ('init', 'cond', 'update', 'body', 'redirects', 'spids')

  def __init__(self, init=None, cond=None, update=None, body=None,
               redirects=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[arith_expr_t], Optional[arith_expr_t], Optional[command_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.init = init or None
    self.cond = cond or None
    self.update = update or None
    self.body = body or None
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ForExpr')
    L = out_node.fields

    if self.init is not None:  # MaybeType
      x0 = self.init.PrettyTree()
      L.append(('init', x0))

    if self.cond is not None:  # MaybeType
      x1 = self.cond.PrettyTree()
      L.append(('cond', x1))

    if self.update is not None:  # MaybeType
      x2 = self.update.PrettyTree()
      L.append(('update', x2))

    if self.body is not None:  # MaybeType
      x3 = self.body.PrettyTree()
      L.append(('body', x3))

    if self.redirects:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.redirects:
        x4.children.append(i4.PrettyTree())
      L.append(('redirects', x4))

    if self.spids:  # ArrayType
      x5 = PrettyArray()
      for i5 in self.spids:
        x5.children.append(PrettyLeaf(str(i5), Color_OtherConst))
      L.append(('spids', x5))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.ForExpr')
    L = out_node.fields
    if self.init is not None:  # MaybeType
      x0 = self.init.AbbreviatedTree()
      L.append(('init', x0))

    if self.cond is not None:  # MaybeType
      x1 = self.cond.AbbreviatedTree()
      L.append(('cond', x1))

    if self.update is not None:  # MaybeType
      x2 = self.update.AbbreviatedTree()
      L.append(('update', x2))

    if self.body is not None:  # MaybeType
      x3 = self.body.AbbreviatedTree()
      L.append(('body', x3))

    if self.redirects:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.redirects:
        x4.children.append(i4.AbbreviatedTree())
      L.append(('redirects', x4))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__WhileUntil(command_t):
  tag = 17
  __slots__ = ('keyword', 'cond', 'body', 'redirects', 'spids')

  def __init__(self, keyword=None, cond=None, body=None, redirects=None,
               spids=None):
    # type: (Optional[token], Optional[List[command_t]], Optional[command_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.keyword = keyword
    self.cond = cond or []
    self.body = body
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.WhileUntil')
    L = out_node.fields

    assert self.keyword is not None
    x0 = self.keyword.PrettyTree()
    L.append(('keyword', x0))

    if self.cond:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.cond:
        x1.children.append(i1.PrettyTree())
      L.append(('cond', x1))

    assert self.body is not None
    x2 = self.body.PrettyTree()
    L.append(('body', x2))

    if self.redirects:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.redirects:
        x3.children.append(i3.PrettyTree())
      L.append(('redirects', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.WhileUntil')
    L = out_node.fields
    assert self.keyword is not None
    x0 = self.keyword.AbbreviatedTree()
    L.append(('keyword', x0))

    if self.cond:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.cond:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('cond', x1))

    assert self.body is not None
    x2 = self.body.AbbreviatedTree()
    L.append(('body', x2))

    if self.redirects:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.redirects:
        x3.children.append(i3.AbbreviatedTree())
      L.append(('redirects', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__If(command_t):
  tag = 18
  __slots__ = ('arms', 'else_action', 'redirects', 'spids')

  def __init__(self, arms=None, else_action=None, redirects=None, spids=None):
    # type: (Optional[List[if_arm]], Optional[List[command_t]], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.arms = arms or []
    self.else_action = else_action or []
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.If')
    L = out_node.fields

    if self.arms:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.arms:
        x0.children.append(i0.PrettyTree())
      L.append(('arms', x0))

    if self.else_action:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.else_action:
        x1.children.append(i1.PrettyTree())
      L.append(('else_action', x1))

    if self.redirects:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.redirects:
        x2.children.append(i2.PrettyTree())
      L.append(('redirects', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.If')
    L = out_node.fields
    if self.arms:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.arms:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('arms', x0))

    if self.else_action:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.else_action:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('else_action', x1))

    if self.redirects:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.redirects:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('redirects', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__Case(command_t):
  tag = 19
  __slots__ = ('to_match', 'arms', 'redirects', 'spids')

  def __init__(self, to_match=None, arms=None, redirects=None, spids=None):
    # type: (Optional[word_t], Optional[List[case_arm]], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.to_match = to_match
    self.arms = arms or []
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Case')
    L = out_node.fields

    assert self.to_match is not None
    x0 = self.to_match.PrettyTree()
    L.append(('to_match', x0))

    if self.arms:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.arms:
        x1.children.append(i1.PrettyTree())
      L.append(('arms', x1))

    if self.redirects:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.redirects:
        x2.children.append(i2.PrettyTree())
      L.append(('redirects', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.Case')
    L = out_node.fields
    assert self.to_match is not None
    x0 = self.to_match.AbbreviatedTree()
    L.append(('to_match', x0))

    if self.arms:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.arms:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('arms', x1))

    if self.redirects:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.redirects:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('redirects', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__FuncDef(command_t):
  tag = 20
  __slots__ = ('name', 'body', 'redirects', 'spids')

  def __init__(self, name=None, body=None, redirects=None, spids=None):
    # type: (Optional[str], Optional[command_t], Optional[List[redir_t]], Optional[List[int]]) -> None
    self.name = name
    self.body = body
    self.redirects = redirects or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.FuncDef')
    L = out_node.fields

    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    assert self.body is not None
    x1 = self.body.PrettyTree()
    L.append(('body', x1))

    if self.redirects:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.redirects:
        x2.children.append(i2.PrettyTree())
      L.append(('redirects', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.FuncDef')
    L = out_node.fields
    x0 = PrettyLeaf(self.name, Color_StringConst)
    L.append(('name', x0))

    assert self.body is not None
    x1 = self.body.AbbreviatedTree()
    L.append(('body', x1))

    if self.redirects:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.redirects:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('redirects', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__TimeBlock(command_t):
  tag = 21
  __slots__ = ('pipeline', 'spids')

  def __init__(self, pipeline=None, spids=None):
    # type: (Optional[command_t], Optional[List[int]]) -> None
    self.pipeline = pipeline
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.TimeBlock')
    L = out_node.fields

    assert self.pipeline is not None
    x0 = self.pipeline.PrettyTree()
    L.append(('pipeline', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.TimeBlock')
    L = out_node.fields
    assert self.pipeline is not None
    x0 = self.pipeline.AbbreviatedTree()
    L.append(('pipeline', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command__CommandList(command_t):
  tag = 22
  __slots__ = ('children', 'spids')

  def __init__(self, children=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[int]]) -> None
    self.children = children or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.CommandList')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(('children', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('command.CommandList')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('children', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class command(object):
  NoOp = command__NoOp
  SimpleCommand = command__SimpleCommand
  ExpandedAlias = command__ExpandedAlias
  Sentence = command__Sentence
  Assignment = command__Assignment
  OilAssign = command__OilAssign
  ControlFlow = command__ControlFlow
  Pipeline = command__Pipeline
  AndOr = command__AndOr
  DoGroup = command__DoGroup
  BraceGroup = command__BraceGroup
  Subshell = command__Subshell
  DParen = command__DParen
  DBracket = command__DBracket
  ForEach = command__ForEach
  ForExpr = command__ForExpr
  WhileUntil = command__WhileUntil
  If = command__If
  Case = command__Case
  FuncDef = command__FuncDef
  TimeBlock = command__TimeBlock
  CommandList = command__CommandList

class glob_part_e(object):
  GlobLit = 1
  GlobOp = 2
  CharClass = 3

class glob_part_t(runtime.CompoundObj):
  pass

class glob_part__GlobLit(glob_part_t):
  tag = 1
  __slots__ = ('id', 's', 'spids')

  def __init__(self, id=None, s=None, spids=None):
    # type: (Optional[Id_t], Optional[str], Optional[List[int]]) -> None
    self.id = id
    self.s = s
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('glob_part.GlobLit')
    L = out_node.fields

    assert self.id is not None
    x0 = PrettyLeaf(self.id.name, Color_UserType)
    L.append(('id', x0))

    x1 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('glob_part.GlobLit')
    L = out_node.fields
    assert self.id is not None
    x0 = PrettyLeaf(self.id.name, Color_UserType)
    L.append(('id', x0))

    x1 = PrettyLeaf(self.s, Color_StringConst)
    L.append(('s', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class glob_part__GlobOp(glob_part_t):
  tag = 2
  __slots__ = ('op_id', 'spids')

  def __init__(self, op_id=None, spids=None):
    # type: (Optional[Id_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('glob_part.GlobOp')
    L = out_node.fields

    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('glob_part.GlobOp')
    L = out_node.fields
    assert self.op_id is not None
    x0 = PrettyLeaf(self.op_id.name, Color_UserType)
    L.append(('op_id', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class glob_part__CharClass(glob_part_t):
  tag = 3
  __slots__ = ('negated', 'strs', 'spids')

  def __init__(self, negated=None, strs=None, spids=None):
    # type: (Optional[bool], Optional[List[str]], Optional[List[int]]) -> None
    self.negated = negated
    self.strs = strs or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('glob_part.CharClass')
    L = out_node.fields

    x0 = PrettyLeaf('T' if self.negated else 'F', Color_OtherConst)
    L.append(('negated', x0))

    if self.strs:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.strs:
        x1.children.append(PrettyLeaf(i1, Color_StringConst))
      L.append(('strs', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('glob_part.CharClass')
    L = out_node.fields
    x0 = PrettyLeaf('T' if self.negated else 'F', Color_OtherConst)
    L.append(('negated', x0))

    if self.strs:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.strs:
        x1.children.append(PrettyLeaf(i1, Color_StringConst))
      L.append(('strs', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class glob_part(object):
  GlobLit = glob_part__GlobLit
  GlobOp = glob_part__GlobOp
  CharClass = glob_part__CharClass

class printf_part_e(object):
  Literal = 1
  Percent = 2

class printf_part_t(runtime.CompoundObj):
  pass

class printf_part__Literal(printf_part_t):
  tag = 1
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('printf_part.Literal')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('printf_part.Literal')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class printf_part__Percent(printf_part_t):
  tag = 2
  __slots__ = ('flag', 'width', 'precision', 'type', 'spids')

  def __init__(self, flag=None, width=None, precision=None, type=None,
               spids=None):
    # type: (Optional[token], Optional[token], Optional[token], Optional[token], Optional[List[int]]) -> None
    self.flag = flag or None
    self.width = width or None
    self.precision = precision or None
    self.type = type
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('printf_part.Percent')
    L = out_node.fields

    if self.flag is not None:  # MaybeType
      x0 = self.flag.PrettyTree()
      L.append(('flag', x0))

    if self.width is not None:  # MaybeType
      x1 = self.width.PrettyTree()
      L.append(('width', x1))

    if self.precision is not None:  # MaybeType
      x2 = self.precision.PrettyTree()
      L.append(('precision', x2))

    assert self.type is not None
    x3 = self.type.PrettyTree()
    L.append(('type', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('printf_part.Percent')
    L = out_node.fields
    if self.flag is not None:  # MaybeType
      x0 = self.flag.AbbreviatedTree()
      L.append(('flag', x0))

    if self.width is not None:  # MaybeType
      x1 = self.width.AbbreviatedTree()
      L.append(('width', x1))

    if self.precision is not None:  # MaybeType
      x2 = self.precision.AbbreviatedTree()
      L.append(('precision', x2))

    assert self.type is not None
    x3 = self.type.AbbreviatedTree()
    L.append(('type', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class printf_part(object):
  Literal = printf_part__Literal
  Percent = printf_part__Percent

class regex_e(object):
  Var = 1
  SingleQuoted = 2
  DoubleQuoted = 3
  Repeat = 4
  RepeatRange = 5
  Concat = 6

class regex_t(runtime.CompoundObj):
  pass

class regex__Var(regex_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.Var')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(('name', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.Var')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class regex__SingleQuoted(regex_t):
  tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.SingleQuoted')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.SingleQuoted')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class regex__DoubleQuoted(regex_t):
  tag = 3
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.DoubleQuoted')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.DoubleQuoted')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class regex__Repeat(regex_t):
  tag = 4
  __slots__ = ('op', 'child', 'spids')

  def __init__(self, op=None, child=None, spids=None):
    # type: (Optional[token], Optional[regex_t], Optional[List[int]]) -> None
    self.op = op
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.Repeat')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(('op', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(('child', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.Repeat')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(('op', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class regex__RepeatRange(regex_t):
  tag = 5
  __slots__ = ('min', 'max', 'child', 'spids')

  def __init__(self, min=None, max=None, child=None, spids=None):
    # type: (Optional[token], Optional[token], Optional[regex_t], Optional[List[int]]) -> None
    self.min = min
    self.max = max
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.RepeatRange')
    L = out_node.fields

    assert self.min is not None
    x0 = self.min.PrettyTree()
    L.append(('min', x0))

    assert self.max is not None
    x1 = self.max.PrettyTree()
    L.append(('max', x1))

    assert self.child is not None
    x2 = self.child.PrettyTree()
    L.append(('child', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.RepeatRange')
    L = out_node.fields
    assert self.min is not None
    x0 = self.min.AbbreviatedTree()
    L.append(('min', x0))

    assert self.max is not None
    x1 = self.max.AbbreviatedTree()
    L.append(('max', x1))

    assert self.child is not None
    x2 = self.child.AbbreviatedTree()
    L.append(('child', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class regex__Concat(regex_t):
  tag = 6
  __slots__ = ('parts', 'spids')

  def __init__(self, parts=None, spids=None):
    # type: (Optional[List[regex_t]], Optional[List[int]]) -> None
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.Concat')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(('parts', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('regex.Concat')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class regex(object):
  Var = regex__Var
  SingleQuoted = regex__SingleQuoted
  DoubleQuoted = regex__DoubleQuoted
  Repeat = regex__Repeat
  RepeatRange = regex__RepeatRange
  Concat = regex__Concat

class expr_e(object):
  Var = 1
  Const = 2
  ArrayLiteral = 3
  RegexLiteral = 4
  VarSub = 5
  CommandSub = 6
  ExprSub = 7
  SingleQuoted = 8
  DoubleQuoted = 9
  Unary = 10
  Binary = 11
  FuncCall = 12
  Subscript = 13

class expr_t(runtime.CompoundObj):
  pass

class expr__Var(expr_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Var')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(('name', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Var')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__Const(expr_t):
  tag = 2
  __slots__ = ('c', 'spids')

  def __init__(self, c=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.c = c
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Const')
    L = out_node.fields

    assert self.c is not None
    x0 = self.c.PrettyTree()
    L.append(('c', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Const')
    L = out_node.fields
    assert self.c is not None
    x0 = self.c.AbbreviatedTree()
    L.append(('c', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__ArrayLiteral(expr_t):
  tag = 3
  __slots__ = ('left', 'items', 'spids')

  def __init__(self, left=None, items=None, spids=None):
    # type: (Optional[token], Optional[List[word_t]], Optional[List[int]]) -> None
    self.left = left
    self.items = items or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.ArrayLiteral')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    if self.items:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.items:
        x1.children.append(i1.PrettyTree())
      L.append(('items', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.ArrayLiteral')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    if self.items:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.items:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('items', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__RegexLiteral(expr_t):
  tag = 4
  __slots__ = ('left', 'regex', 'spids')

  def __init__(self, left=None, regex=None, spids=None):
    # type: (Optional[token], Optional[regex_t], Optional[List[int]]) -> None
    self.left = left
    self.regex = regex
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.RegexLiteral')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    assert self.regex is not None
    x1 = self.regex.PrettyTree()
    L.append(('regex', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.RegexLiteral')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    assert self.regex is not None
    x1 = self.regex.AbbreviatedTree()
    L.append(('regex', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__VarSub(expr_t):
  tag = 5
  __slots__ = ('left', 'e', 'spids')

  def __init__(self, left=None, e=None, spids=None):
    # type: (Optional[token], Optional[expr_t], Optional[List[int]]) -> None
    self.left = left
    self.e = e
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.VarSub')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    assert self.e is not None
    x1 = self.e.PrettyTree()
    L.append(('e', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.VarSub')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    assert self.e is not None
    x1 = self.e.AbbreviatedTree()
    L.append(('e', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__CommandSub(expr_t):
  tag = 6
  __slots__ = ('left', 'cmd', 'spids')

  def __init__(self, left=None, cmd=None, spids=None):
    # type: (Optional[token], Optional[command_t], Optional[List[int]]) -> None
    self.left = left
    self.cmd = cmd
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.CommandSub')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    assert self.cmd is not None
    x1 = self.cmd.PrettyTree()
    L.append(('cmd', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.CommandSub')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    assert self.cmd is not None
    x1 = self.cmd.AbbreviatedTree()
    L.append(('cmd', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__ExprSub(expr_t):
  tag = 7
  __slots__ = ('left', 'e', 'spids')

  def __init__(self, left=None, e=None, spids=None):
    # type: (Optional[token], Optional[expr_t], Optional[List[int]]) -> None
    self.left = left
    self.e = e
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.ExprSub')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    assert self.e is not None
    x1 = self.e.PrettyTree()
    L.append(('e', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.ExprSub')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    assert self.e is not None
    x1 = self.e.AbbreviatedTree()
    L.append(('e', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__SingleQuoted(expr_t):
  tag = 8
  __slots__ = ('left', 'tokens', 'spids')

  def __init__(self, left=None, tokens=None, spids=None):
    # type: (Optional[token], Optional[List[token]], Optional[List[int]]) -> None
    self.left = left
    self.tokens = tokens or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.SingleQuoted')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    if self.tokens:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.tokens:
        x1.children.append(i1.PrettyTree())
      L.append(('tokens', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.SingleQuoted')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    if self.tokens:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.tokens:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('tokens', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__DoubleQuoted(expr_t):
  tag = 9
  __slots__ = ('left', 'parts', 'spids')

  def __init__(self, left=None, parts=None, spids=None):
    # type: (Optional[token], Optional[List[oil_word_part_t]], Optional[List[int]]) -> None
    self.left = left
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.DoubleQuoted')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    if self.parts:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.parts:
        x1.children.append(i1.PrettyTree())
      L.append(('parts', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.DoubleQuoted')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    if self.parts:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.parts:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('parts', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__Unary(expr_t):
  tag = 10
  __slots__ = ('op', 'child', 'spids')

  def __init__(self, op=None, child=None, spids=None):
    # type: (Optional[token], Optional[expr_t], Optional[List[int]]) -> None
    self.op = op
    self.child = child
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Unary')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(('op', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(('child', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Unary')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(('op', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__Binary(expr_t):
  tag = 11
  __slots__ = ('op', 'left', 'right', 'spids')

  def __init__(self, op=None, left=None, right=None, spids=None):
    # type: (Optional[token], Optional[expr_t], Optional[expr_t], Optional[List[int]]) -> None
    self.op = op
    self.left = left
    self.right = right
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Binary')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(('op', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(('right', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Binary')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(('op', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__FuncCall(expr_t):
  tag = 12
  __slots__ = ('func', 'args', 'spids')

  def __init__(self, func=None, args=None, spids=None):
    # type: (Optional[expr_t], Optional[List[expr_t]], Optional[List[int]]) -> None
    self.func = func
    self.args = args or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.FuncCall')
    L = out_node.fields

    assert self.func is not None
    x0 = self.func.PrettyTree()
    L.append(('func', x0))

    if self.args:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.args:
        x1.children.append(i1.PrettyTree())
      L.append(('args', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.FuncCall')
    L = out_node.fields
    assert self.func is not None
    x0 = self.func.AbbreviatedTree()
    L.append(('func', x0))

    if self.args:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.args:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('args', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr__Subscript(expr_t):
  tag = 13
  __slots__ = ('collection', 'indices', 'spids')

  def __init__(self, collection=None, indices=None, spids=None):
    # type: (Optional[expr_t], Optional[List[expr_t]], Optional[List[int]]) -> None
    self.collection = collection
    self.indices = indices or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Subscript')
    L = out_node.fields

    assert self.collection is not None
    x0 = self.collection.PrettyTree()
    L.append(('collection', x0))

    if self.indices:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.indices:
        x1.children.append(i1.PrettyTree())
      L.append(('indices', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('expr.Subscript')
    L = out_node.fields
    assert self.collection is not None
    x0 = self.collection.AbbreviatedTree()
    L.append(('collection', x0))

    if self.indices:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.indices:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('indices', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class expr(object):
  Var = expr__Var
  Const = expr__Const
  ArrayLiteral = expr__ArrayLiteral
  RegexLiteral = expr__RegexLiteral
  VarSub = expr__VarSub
  CommandSub = expr__CommandSub
  ExprSub = expr__ExprSub
  SingleQuoted = expr__SingleQuoted
  DoubleQuoted = expr__DoubleQuoted
  Unary = expr__Unary
  Binary = expr__Binary
  FuncCall = expr__FuncCall
  Subscript = expr__Subscript

class oil_word_part_e(object):
  Literal = 1
  SingleQuoted = 2
  DoubleQuoted = 3
  TildeSub = 4
  VarSub = 5
  ExprSub = 6
  CommandSub = 7

class oil_word_part_t(runtime.CompoundObj):
  pass

class oil_word_part__Literal(oil_word_part_t):
  tag = 1
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.Literal')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.Literal')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part__SingleQuoted(oil_word_part_t):
  tag = 2
  __slots__ = ('left', 'tokens', 'spids')

  def __init__(self, left=None, tokens=None, spids=None):
    # type: (Optional[token], Optional[List[token]], Optional[List[int]]) -> None
    self.left = left
    self.tokens = tokens or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.SingleQuoted')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    if self.tokens:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.tokens:
        x1.children.append(i1.PrettyTree())
      L.append(('tokens', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.SingleQuoted')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    if self.tokens:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.tokens:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('tokens', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part__DoubleQuoted(oil_word_part_t):
  tag = 3
  __slots__ = ('left', 'parts', 'spids')

  def __init__(self, left=None, parts=None, spids=None):
    # type: (Optional[token], Optional[List[oil_word_part_t]], Optional[List[int]]) -> None
    self.left = left
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.DoubleQuoted')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(('left', x0))

    if self.parts:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.parts:
        x1.children.append(i1.PrettyTree())
      L.append(('parts', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.DoubleQuoted')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(('left', x0))

    if self.parts:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.parts:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('parts', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part__TildeSub(oil_word_part_t):
  tag = 4
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.TildeSub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.TildeSub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part__VarSub(oil_word_part_t):
  tag = 5
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.VarSub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.VarSub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part__ExprSub(oil_word_part_t):
  tag = 6
  __slots__ = ('token', 'prefix_op', 'bracket_op', 'suffix_op', 'spids')

  def __init__(self, token=None, prefix_op=None, bracket_op=None,
               suffix_op=None, spids=None):
    # type: (Optional[token], Optional[Id_t], Optional[bracket_op_t], Optional[suffix_op_t], Optional[List[int]]) -> None
    self.token = token
    self.prefix_op = prefix_op or None
    self.bracket_op = bracket_op or None
    self.suffix_op = suffix_op or None
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.ExprSub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(('token', x0))

    if self.prefix_op is not None:  # MaybeType
      x1 = PrettyLeaf(self.prefix_op.name, Color_UserType)
      L.append(('prefix_op', x1))

    if self.bracket_op is not None:  # MaybeType
      x2 = self.bracket_op.PrettyTree()
      L.append(('bracket_op', x2))

    if self.suffix_op is not None:  # MaybeType
      x3 = self.suffix_op.PrettyTree()
      L.append(('suffix_op', x3))

    if self.spids:  # ArrayType
      x4 = PrettyArray()
      for i4 in self.spids:
        x4.children.append(PrettyLeaf(str(i4), Color_OtherConst))
      L.append(('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.ExprSub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(('token', x0))

    if self.prefix_op is not None:  # MaybeType
      x1 = PrettyLeaf(self.prefix_op.name, Color_UserType)
      L.append(('prefix_op', x1))

    if self.bracket_op is not None:  # MaybeType
      x2 = self.bracket_op.AbbreviatedTree()
      L.append(('bracket_op', x2))

    if self.suffix_op is not None:  # MaybeType
      x3 = self.suffix_op.AbbreviatedTree()
      L.append(('suffix_op', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part__CommandSub(oil_word_part_t):
  tag = 7
  __slots__ = ('command_list', 'left_token', 'spids')

  def __init__(self, command_list=None, left_token=None, spids=None):
    # type: (Optional[oil_cmd_t], Optional[token], Optional[List[int]]) -> None
    self.command_list = command_list
    self.left_token = left_token
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.CommandSub')
    L = out_node.fields

    assert self.command_list is not None
    x0 = self.command_list.PrettyTree()
    L.append(('command_list', x0))

    assert self.left_token is not None
    x1 = self.left_token.PrettyTree()
    L.append(('left_token', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word_part.CommandSub')
    L = out_node.fields
    assert self.command_list is not None
    x0 = self.command_list.AbbreviatedTree()
    L.append(('command_list', x0))

    assert self.left_token is not None
    x1 = self.left_token.AbbreviatedTree()
    L.append(('left_token', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word_part(object):
  Literal = oil_word_part__Literal
  SingleQuoted = oil_word_part__SingleQuoted
  DoubleQuoted = oil_word_part__DoubleQuoted
  TildeSub = oil_word_part__TildeSub
  VarSub = oil_word_part__VarSub
  ExprSub = oil_word_part__ExprSub
  CommandSub = oil_word_part__CommandSub

class oil_word_e(object):
  Compound = 1
  Glob = 2
  Braced = 3

class oil_word_t(runtime.CompoundObj):
  pass

class oil_word__Compound(oil_word_t):
  tag = 1
  __slots__ = ('parts', 'spids')

  def __init__(self, parts=None, spids=None):
    # type: (Optional[List[oil_word_part_t]], Optional[List[int]]) -> None
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word.Compound')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(('parts', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word.Compound')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word__Glob(oil_word_t):
  tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word.Glob')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word.Glob')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word__Braced(oil_word_t):
  tag = 3
  __slots__ = ('parts', 'spids')

  def __init__(self, parts=None, spids=None):
    # type: (Optional[List[oil_word_part_t]], Optional[List[int]]) -> None
    self.parts = parts or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word.Braced')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(('parts', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_word.Braced')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_word(object):
  Compound = oil_word__Compound
  Glob = oil_word__Glob
  Braced = oil_word__Braced

class oil_cmd_e(object):
  Simple = 1
  Sentence = 2
  Pipeline = 3
  AndOr = 4
  CommandList = 5

class oil_cmd_t(runtime.CompoundObj):
  pass

class oil_cmd__Simple(oil_cmd_t):
  tag = 1
  __slots__ = ('words', 'redirects', 'more_env', 'spids')

  def __init__(self, words=None, redirects=None, more_env=None, spids=None):
    # type: (Optional[List[oil_word_t]], Optional[List[redir_t]], Optional[List[env_pair]], Optional[List[int]]) -> None
    self.words = words or []
    self.redirects = redirects or []
    self.more_env = more_env or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.Simple')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(('words', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.more_env:
        x2.children.append(i2.PrettyTree())
      L.append(('more_env', x2))

    if self.spids:  # ArrayType
      x3 = PrettyArray()
      for i3 in self.spids:
        x3.children.append(PrettyLeaf(str(i3), Color_OtherConst))
      L.append(('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.Simple')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('words', x0))

    if self.redirects:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.more_env:
        x2.children.append(i2.AbbreviatedTree())
      L.append(('more_env', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_cmd__Sentence(oil_cmd_t):
  tag = 2
  __slots__ = ('child', 'terminator', 'spids')

  def __init__(self, child=None, terminator=None, spids=None):
    # type: (Optional[oil_cmd_t], Optional[token], Optional[List[int]]) -> None
    self.child = child
    self.terminator = terminator
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.Sentence')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(('child', x0))

    assert self.terminator is not None
    x1 = self.terminator.PrettyTree()
    L.append(('terminator', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.Sentence')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(('child', x0))

    assert self.terminator is not None
    x1 = self.terminator.AbbreviatedTree()
    L.append(('terminator', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_cmd__Pipeline(oil_cmd_t):
  tag = 3
  __slots__ = ('children', 'negated', 'spids')

  def __init__(self, children=None, negated=None, spids=None):
    # type: (Optional[List[oil_cmd_t]], Optional[bool], Optional[List[int]]) -> None
    self.children = children or []
    self.negated = negated
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.Pipeline')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(('children', x0))

    x1 = PrettyLeaf('T' if self.negated else 'F', Color_OtherConst)
    L.append(('negated', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.Pipeline')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('children', x0))

    x1 = PrettyLeaf('T' if self.negated else 'F', Color_OtherConst)
    L.append(('negated', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_cmd__AndOr(oil_cmd_t):
  tag = 4
  __slots__ = ('ops', 'children', 'spids')

  def __init__(self, ops=None, children=None, spids=None):
    # type: (Optional[List[Id_t]], Optional[List[oil_cmd_t]], Optional[List[int]]) -> None
    self.ops = ops or []
    self.children = children or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.AndOr')
    L = out_node.fields

    if self.ops:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.ops:
        x0.children.append(PrettyLeaf(i0.name, Color_UserType))
      L.append(('ops', x0))

    if self.children:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.children:
        x1.children.append(i1.PrettyTree())
      L.append(('children', x1))

    if self.spids:  # ArrayType
      x2 = PrettyArray()
      for i2 in self.spids:
        x2.children.append(PrettyLeaf(str(i2), Color_OtherConst))
      L.append(('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.AndOr')
    L = out_node.fields
    if self.ops:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.ops:
        x0.children.append(PrettyLeaf(i0.name, Color_UserType))
      L.append(('ops', x0))

    if self.children:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.children:
        x1.children.append(i1.AbbreviatedTree())
      L.append(('children', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_cmd__CommandList(oil_cmd_t):
  tag = 5
  __slots__ = ('children', 'spids')

  def __init__(self, children=None, spids=None):
    # type: (Optional[List[oil_cmd_t]], Optional[List[int]]) -> None
    self.children = children or []
    self.spids = spids or []

  def PrettyTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.CommandList')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(('children', x0))

    if self.spids:  # ArrayType
      x1 = PrettyArray()
      for i1 in self.spids:
        x1.children.append(PrettyLeaf(str(i1), Color_OtherConst))
      L.append(('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> PrettyNode
    out_node = PrettyNode('oil_cmd.CommandList')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = PrettyArray()
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(('children', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> PrettyNode
    return self._AbbreviatedTree()

class oil_cmd(object):
  Simple = oil_cmd__Simple
  Sentence = oil_cmd__Sentence
  Pipeline = oil_cmd__Pipeline
  AndOr = oil_cmd__AndOr
  CommandList = oil_cmd__CommandList

#
# CONCATENATED FILE
#

"""
syntax_abbrev.py - Abbreviations for pretty-printing syntax.asdl.
"""

from _devbuild.gen.id_kind_asdl import Id
from asdl import runtime


def _AbbreviateToken(token, out):
  # type: (token, List[runtime._PrettyBase]) -> None
  if token.id != Id.Lit_Chars:
    n1 = runtime.PrettyLeaf(token.id.name, runtime.Color_OtherConst)
    out.append(n1)

  n2 = runtime.PrettyLeaf(token.val, runtime.Color_StringConst)
  out.append(n2)


def _token(obj):
  # type: (token) -> PrettyNode
  p_node = runtime.PrettyNode()
  p_node.abbrev = True
  p_node.node_type = ''  # don't show

  p_node.left = '<'
  p_node.right = '>'
  _AbbreviateToken(obj, p_node.unnamed_fields)
  return p_node


def _word_part__LiteralPart(obj):
  # type: (word_part__LiteralPart) -> PrettyNode
  p_node = runtime.PrettyNode()
  p_node.abbrev = True
  p_node.node_type = ''  # don't show

  _AbbreviateToken(obj.token, p_node.unnamed_fields)
  return p_node


def _word_part__SimpleVarSub(obj):
  # type: (word_part__SimpleVarSub) -> PrettyNode
  p_node = runtime.PrettyNode()
  p_node.abbrev = True
  p_node.node_type = '$'
  _AbbreviateToken(obj.token, p_node.unnamed_fields)
  return p_node


def _word_part__BracedVarSub(obj):
  # type: (word_part__BracedVarSub) -> PrettyNode
  p_node = runtime.PrettyNode()
  if obj.prefix_op or obj.bracket_op or obj.suffix_op:
    return None  # we have other fields to display; don't abbreviate

  p_node.abbrev = True
  p_node.node_type = '${'
  _AbbreviateToken(obj.token, p_node.unnamed_fields)
  return p_node


def _word_part__DoubleQuotedPart(obj):
  # type: (word_part__DoubleQuotedPart) -> PrettyNode
  p_node = runtime.PrettyNode()
  p_node.abbrev = True
  p_node.node_type = 'DQ'

  for part in obj.parts:
    p_node.unnamed_fields.append(part.AbbreviatedTree())
  return p_node


def _word_part__SingleQuotedPart(obj):
  # type: (word_part__SingleQuotedPart) -> PrettyNode

  # Only abbreviate 'foo', not $'foo\n'
  if obj.left.id != Id.Left_SingleQuote:
    return None  # Fall back on obj._AbbreviatedTree()

  p_node = runtime.PrettyNode()
  p_node.abbrev = True
  p_node.node_type = 'SQ'

  for token in obj.tokens:
    p_node.unnamed_fields.append(token.AbbreviatedTree())
  return p_node


def _word__CompoundWord(obj):
  # type: (word__CompoundWord) -> PrettyNode
  p_node = runtime.PrettyNode()
  p_node.abbrev = True
  p_node.node_type = ''  # don't show
  p_node.left = '{'
  p_node.right = '}'

  for part in obj.parts:
    p_node.unnamed_fields.append(part.AbbreviatedTree())
  return p_node


def _command__SimpleCommand(obj):
  # type: (command__SimpleCommand) -> PrettyNode
  p_node = runtime.PrettyNode()
  if obj.redirects or obj.more_env:
    return None  # we have other fields to display; don't abbreviate

  p_node.abbrev = True
  p_node.node_type = 'C'

  for w in obj.words:
    p_node.unnamed_fields.append(w.AbbreviatedTree())
  return p_node
