from asdl import pybase
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING

class color_t(pybase.SimpleObj):
  pass

class color_e(object):
  TypeName = color_t(1)
  StringConst = color_t(2)
  OtherConst = color_t(3)
  UserType = color_t(4)
  External = color_t(5)

_color_str = {
  1: 'color.TypeName',
  2: 'color.StringConst',
  3: 'color.OtherConst',
  4: 'color.UserType',
  5: 'color.External',
}

def color_str(val):
  # type: (color_t) -> str
  return _color_str[val]

class hnode_e(object):
  Record = 1
  Array = 2
  Leaf = 3
  External = 4

_hnode_str = {
  1: 'hnode.Record',
  2: 'hnode.Array',
  3: 'hnode.Leaf',
  4: 'hnode.External',
}

def hnode_str(tag):
  # type: (int) -> str
  return _hnode_str[tag]

class hnode_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class hnode__Record(hnode_t):
  tag = 1
  __slots__ = ('node_type', 'fields', 'abbrev', 'left', 'right',
               'unnamed_fields')

  def __init__(self, node_type, fields, abbrev, left, right, unnamed_fields):
    # type: (Optional[str], List[field], bool, str, str, List[hnode_t]) -> None
    self.node_type = node_type if node_type is not None else ''
    self.fields = fields if fields is not None else []
    self.abbrev = abbrev
    self.left = left
    self.right = right
    self.unnamed_fields = unnamed_fields if unnamed_fields is not None else []

class hnode__Array(hnode_t):
  tag = 2
  __slots__ = ('children',)

  def __init__(self, children):
    # type: (List[hnode_t]) -> None
    self.children = children if children is not None else []

class hnode__Leaf(hnode_t):
  tag = 3
  __slots__ = ('s', 'color')

  def __init__(self, s, color):
    # type: (str, color_t) -> None
    self.s = s
    self.color = color if color is not None else color_e.TypeName

class hnode__External(hnode_t):
  tag = 4
  __slots__ = ('obj',)

  def __init__(self, obj):
    # type: (Any) -> None
    self.obj = obj

class hnode(object):
  Record = hnode__Record
  Array = hnode__Array
  Leaf = hnode__Leaf
  External = hnode__External

class field(pybase.CompoundObj):
  tag = 1000
  __slots__ = ('name', 'val')

  def __init__(self, name, val):
    # type: (str, hnode_t) -> None
    self.name = name
    self.val = val

