from asdl import pybase

option_t = int  # type alias for integer

class option_i(object):
  errexit = 1
  nounset = 2
  hashall = 3
  pipefail = 4
  noexec = 5
  xtrace = 6
  verbose = 7
  noglob = 8
  noclobber = 9
  posix = 10
  vi = 11
  emacs = 12
  interactive = 13
  failglob = 14
  extglob = 15
  eval_unsafe_arith = 16
  parse_dynamic_arith = 17
  compat_array = 18
  verbose_errexit = 19
  nullglob = 20
  inherit_errexit = 21
  strict_argv = 22
  strict_arith = 23
  strict_array = 24
  strict_control_flow = 25
  strict_echo = 26
  strict_errexit = 27
  strict_eval_builtin = 28
  strict_nameref = 29
  strict_word_eval = 30
  strict_tilde = 31
  strict_backslash = 32
  strict_glob = 33
  simple_word_eval = 34
  dashglob = 35
  more_errexit = 36
  simple_test_builtin = 37
  parse_at = 38
  parse_brace = 39
  parse_index_expr = 40
  parse_paren = 41
  parse_rawc = 42
  parse_ignored = 43
  parse_set = 44
  parse_equals = 45
  parse_tea = 46
  expand_aliases = 47
  lastpipe = 48
  progcomp = 49
  histappend = 50
  hostcomplete = 51
  cmdhist = 52
  assoc_expand_once = 53
  autocd = 54
  cdable_vars = 55
  cdspell = 56
  checkhash = 57
  checkjobs = 58
  checkwinsize = 59
  complete_fullquote = 60
  direxpand = 61
  dirspell = 62
  dotglob = 63
  execfail = 64
  extdebug = 65
  extquote = 66
  force_fignore = 67
  globasciiranges = 68
  globstar = 69
  gnu_errfmt = 70
  histreedit = 71
  histverify = 72
  huponexit = 73
  interactive_comments = 74
  lithist = 75
  localvar_inherit = 76
  localvar_unset = 77
  login_shell = 78
  mailwarn = 79
  no_empty_cmd_completion = 80
  nocaseglob = 81
  nocasematch = 82
  progcomp_alias = 83
  promptvars = 84
  restricted_shell = 85
  shift_verbose = 86
  sourcepath = 87
  xpg_echo = 88
  ARRAY_SIZE = 89

_option_str = {
  1: 'option.errexit',
  2: 'option.nounset',
  3: 'option.hashall',
  4: 'option.pipefail',
  5: 'option.noexec',
  6: 'option.xtrace',
  7: 'option.verbose',
  8: 'option.noglob',
  9: 'option.noclobber',
  10: 'option.posix',
  11: 'option.vi',
  12: 'option.emacs',
  13: 'option.interactive',
  14: 'option.failglob',
  15: 'option.extglob',
  16: 'option.eval_unsafe_arith',
  17: 'option.parse_dynamic_arith',
  18: 'option.compat_array',
  19: 'option.verbose_errexit',
  20: 'option.nullglob',
  21: 'option.inherit_errexit',
  22: 'option.strict_argv',
  23: 'option.strict_arith',
  24: 'option.strict_array',
  25: 'option.strict_control_flow',
  26: 'option.strict_echo',
  27: 'option.strict_errexit',
  28: 'option.strict_eval_builtin',
  29: 'option.strict_nameref',
  30: 'option.strict_word_eval',
  31: 'option.strict_tilde',
  32: 'option.strict_backslash',
  33: 'option.strict_glob',
  34: 'option.simple_word_eval',
  35: 'option.dashglob',
  36: 'option.more_errexit',
  37: 'option.simple_test_builtin',
  38: 'option.parse_at',
  39: 'option.parse_brace',
  40: 'option.parse_index_expr',
  41: 'option.parse_paren',
  42: 'option.parse_rawc',
  43: 'option.parse_ignored',
  44: 'option.parse_set',
  45: 'option.parse_equals',
  46: 'option.parse_tea',
  47: 'option.expand_aliases',
  48: 'option.lastpipe',
  49: 'option.progcomp',
  50: 'option.histappend',
  51: 'option.hostcomplete',
  52: 'option.cmdhist',
  53: 'option.assoc_expand_once',
  54: 'option.autocd',
  55: 'option.cdable_vars',
  56: 'option.cdspell',
  57: 'option.checkhash',
  58: 'option.checkjobs',
  59: 'option.checkwinsize',
  60: 'option.complete_fullquote',
  61: 'option.direxpand',
  62: 'option.dirspell',
  63: 'option.dotglob',
  64: 'option.execfail',
  65: 'option.extdebug',
  66: 'option.extquote',
  67: 'option.force_fignore',
  68: 'option.globasciiranges',
  69: 'option.globstar',
  70: 'option.gnu_errfmt',
  71: 'option.histreedit',
  72: 'option.histverify',
  73: 'option.huponexit',
  74: 'option.interactive_comments',
  75: 'option.lithist',
  76: 'option.localvar_inherit',
  77: 'option.localvar_unset',
  78: 'option.login_shell',
  79: 'option.mailwarn',
  80: 'option.no_empty_cmd_completion',
  81: 'option.nocaseglob',
  82: 'option.nocasematch',
  83: 'option.progcomp_alias',
  84: 'option.promptvars',
  85: 'option.restricted_shell',
  86: 'option.shift_verbose',
  87: 'option.sourcepath',
  88: 'option.xpg_echo',
}

def option_str(val):
  # type: (option_t) -> str
  return _option_str[val]

builtin_t = int  # type alias for integer

class builtin_i(object):
  colon = 1
  dot = 2
  exec_ = 3
  eval = 4
  set = 5
  shift = 6
  times = 7
  trap = 8
  unset = 9
  builtin = 10
  readonly = 11
  local = 12
  declare = 13
  typeset = 14
  export_ = 15
  test = 16
  bracket = 17
  true_ = 18
  false_ = 19
  read = 20
  echo = 21
  printf = 22
  mapfile = 23
  readarray = 24
  cd = 25
  pushd = 26
  popd = 27
  dirs = 28
  pwd = 29
  source = 30
  umask = 31
  wait = 32
  jobs = 33
  fg = 34
  bg = 35
  shopt = 36
  complete = 37
  compgen = 38
  compopt = 39
  compadjust = 40
  getopts = 41
  command = 42
  type = 43
  hash = 44
  help = 45
  history = 46
  alias = 47
  unalias = 48
  bind = 49
  push = 50
  append = 51
  write = 52
  getline = 53
  json = 54
  repr = 55
  use = 56
  opts = 57
  cat = 58
  ARRAY_SIZE = 59

_builtin_str = {
  1: 'builtin.colon',
  2: 'builtin.dot',
  3: 'builtin.exec_',
  4: 'builtin.eval',
  5: 'builtin.set',
  6: 'builtin.shift',
  7: 'builtin.times',
  8: 'builtin.trap',
  9: 'builtin.unset',
  10: 'builtin.builtin',
  11: 'builtin.readonly',
  12: 'builtin.local',
  13: 'builtin.declare',
  14: 'builtin.typeset',
  15: 'builtin.export_',
  16: 'builtin.test',
  17: 'builtin.bracket',
  18: 'builtin.true_',
  19: 'builtin.false_',
  20: 'builtin.read',
  21: 'builtin.echo',
  22: 'builtin.printf',
  23: 'builtin.mapfile',
  24: 'builtin.readarray',
  25: 'builtin.cd',
  26: 'builtin.pushd',
  27: 'builtin.popd',
  28: 'builtin.dirs',
  29: 'builtin.pwd',
  30: 'builtin.source',
  31: 'builtin.umask',
  32: 'builtin.wait',
  33: 'builtin.jobs',
  34: 'builtin.fg',
  35: 'builtin.bg',
  36: 'builtin.shopt',
  37: 'builtin.complete',
  38: 'builtin.compgen',
  39: 'builtin.compopt',
  40: 'builtin.compadjust',
  41: 'builtin.getopts',
  42: 'builtin.command',
  43: 'builtin.type',
  44: 'builtin.hash',
  45: 'builtin.help',
  46: 'builtin.history',
  47: 'builtin.alias',
  48: 'builtin.unalias',
  49: 'builtin.bind',
  50: 'builtin.push',
  51: 'builtin.append',
  52: 'builtin.write',
  53: 'builtin.getline',
  54: 'builtin.json',
  55: 'builtin.repr',
  56: 'builtin.use',
  57: 'builtin.opts',
  58: 'builtin.cat',
}

def builtin_str(val):
  # type: (builtin_t) -> str
  return _builtin_str[val]

