from asdl import pybase
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING

if TYPE_CHECKING:
  from _devbuild.gen.syntax_asdl import command_t, re_t, redir_loc_t, BraceGroup

from _devbuild.gen.id_kind_asdl import Id_t
from _devbuild.gen.id_kind_asdl import Id_str


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, field

class cmd_value_e(object):
  Argv = 1
  Assign = 2

_cmd_value_str = {
  1: 'cmd_value.Argv',
  2: 'cmd_value.Assign',
}

def cmd_value_str(tag):
  # type: (int) -> str
  return _cmd_value_str[tag]

class cmd_value_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class cmd_value__Argv(cmd_value_t):
  tag = 1
  __slots__ = ('argv', 'arg_spids', 'block')

  def __init__(self, argv=None, arg_spids=None, block=None):
    # type: (Optional[List[str]], Optional[List[int]], Optional[BraceGroup]) -> None
    self.argv = argv if argv is not None else []
    self.arg_spids = arg_spids if arg_spids is not None else []
    self.block = block if block is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('cmd_value.Argv')
    L = out_node.fields

    if self.argv:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.argv:
        x0.children.append(NewLeaf(i0, color_e.StringConst))
      L.append(field('argv', x0))

    if self.arg_spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.arg_spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('arg_spids', x1))

    if self.block is not None:  # MaybeType
      x2 = self.block.PrettyTree()
      L.append(field('block', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('cmd_value.Argv')
    L = out_node.fields
    if self.argv:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.argv:
        x0.children.append(NewLeaf(i0, color_e.StringConst))
      L.append(field('argv', x0))

    if self.arg_spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.arg_spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('arg_spids', x1))

    if self.block is not None:  # MaybeType
      x2 = self.block.AbbreviatedTree()
      L.append(field('block', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class cmd_value__Assign(cmd_value_t):
  tag = 2
  __slots__ = ('builtin_id', 'argv', 'arg_spids', 'pairs')

  def __init__(self, builtin_id=None, argv=None, arg_spids=None, pairs=None):
    # type: (Optional[int], Optional[List[str]], Optional[List[int]], Optional[List[assign_arg]]) -> None
    self.builtin_id = builtin_id
    self.argv = argv if argv is not None else []
    self.arg_spids = arg_spids if arg_spids is not None else []
    self.pairs = pairs if pairs is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('cmd_value.Assign')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.builtin_id), color_e.OtherConst)
    L.append(field('builtin_id', x0))

    if self.argv:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.argv:
        x1.children.append(NewLeaf(i1, color_e.StringConst))
      L.append(field('argv', x1))

    if self.arg_spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.arg_spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('arg_spids', x2))

    if self.pairs:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.pairs:
        x3.children.append(i3.PrettyTree())
      L.append(field('pairs', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('cmd_value.Assign')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.builtin_id), color_e.OtherConst)
    L.append(field('builtin_id', x0))

    if self.argv:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.argv:
        x1.children.append(NewLeaf(i1, color_e.StringConst))
      L.append(field('argv', x1))

    if self.arg_spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.arg_spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('arg_spids', x2))

    if self.pairs:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.pairs:
        x3.children.append(i3.AbbreviatedTree())
      L.append(field('pairs', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class cmd_value(object):
  Argv = cmd_value__Argv
  Assign = cmd_value__Assign

class quote_t(pybase.SimpleObj):
  pass

class quote_e(object):
  Default = quote_t(1)
  FnMatch = quote_t(2)
  ERE = quote_t(3)

_quote_str = {
  1: 'quote.Default',
  2: 'quote.FnMatch',
  3: 'quote.ERE',
}

def quote_str(val):
  # type: (quote_t) -> str
  return _quote_str[val]

class part_value_e(object):
  String = 1
  Array = 2

_part_value_str = {
  1: 'part_value.String',
  2: 'part_value.Array',
}

def part_value_str(tag):
  # type: (int) -> str
  return _part_value_str[tag]

class part_value_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class part_value__String(part_value_t):
  tag = 1
  __slots__ = ('s', 'quoted', 'do_split')

  def __init__(self, s=None, quoted=None, do_split=None):
    # type: (Optional[str], Optional[bool], Optional[bool]) -> None
    self.s = s
    self.quoted = quoted
    self.do_split = do_split

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('part_value.String')
    L = out_node.fields

    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    x1 = hnode.Leaf('T' if self.quoted else 'F', color_e.OtherConst)
    L.append(field('quoted', x1))

    x2 = hnode.Leaf('T' if self.do_split else 'F', color_e.OtherConst)
    L.append(field('do_split', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('part_value.String')
    L = out_node.fields
    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    x1 = hnode.Leaf('T' if self.quoted else 'F', color_e.OtherConst)
    L.append(field('quoted', x1))

    x2 = hnode.Leaf('T' if self.do_split else 'F', color_e.OtherConst)
    L.append(field('do_split', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class part_value__Array(part_value_t):
  tag = 2
  __slots__ = ('strs',)

  def __init__(self, strs=None):
    # type: (Optional[List[str]]) -> None
    self.strs = strs if strs is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('part_value.Array')
    L = out_node.fields

    if self.strs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.strs:
        x0.children.append(NewLeaf(i0, color_e.StringConst))
      L.append(field('strs', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('part_value.Array')
    L = out_node.fields
    if self.strs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.strs:
        x0.children.append(NewLeaf(i0, color_e.StringConst))
      L.append(field('strs', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class part_value(object):
  String = part_value__String
  Array = part_value__Array

class value_e(object):
  Undef = 1
  Str = 2
  Int = 3
  MaybeStrArray = 4
  AssocArray = 5
  Bool = 6
  Float = 7
  Eggex = 8
  Obj = 9

_value_str = {
  1: 'value.Undef',
  2: 'value.Str',
  3: 'value.Int',
  4: 'value.MaybeStrArray',
  5: 'value.AssocArray',
  6: 'value.Bool',
  7: 'value.Float',
  8: 'value.Eggex',
  9: 'value.Obj',
}

def value_str(tag):
  # type: (int) -> str
  return _value_str[tag]

class value_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class value__Undef(value_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Undef')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Undef')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__Str(value_t):
  tag = 2
  __slots__ = ('s',)

  def __init__(self, s=None):
    # type: (Optional[str]) -> None
    self.s = s

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Str')
    L = out_node.fields

    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Str')
    L = out_node.fields
    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__Int(value_t):
  tag = 3
  __slots__ = ('i',)

  def __init__(self, i=None):
    # type: (Optional[int]) -> None
    self.i = i

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Int')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(field('i', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Int')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(field('i', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__MaybeStrArray(value_t):
  tag = 4
  __slots__ = ('strs',)

  def __init__(self, strs=None):
    # type: (Optional[List[str]]) -> None
    self.strs = strs if strs is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.MaybeStrArray')
    L = out_node.fields

    if self.strs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.strs:
        x0.children.append(NewLeaf(i0, color_e.StringConst))
      L.append(field('strs', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.MaybeStrArray')
    L = out_node.fields
    if self.strs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.strs:
        x0.children.append(NewLeaf(i0, color_e.StringConst))
      L.append(field('strs', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__AssocArray(value_t):
  tag = 5
  __slots__ = ('d',)

  def __init__(self, d=None):
    # type: (Optional[Dict[str, str]]) -> None
    self.d = d if d is not None else {}

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.AssocArray')
    L = out_node.fields

    if self.d:  # ArrayType
      m = hnode.Leaf("map", color_e.OtherConst)
      x0 = hnode.Array([m])
      for k0, v0 in self.d.iteritems():
        x0.children.append(NewLeaf(k0, color_e.StringConst))
        x0.children.append(NewLeaf(v0, color_e.StringConst))
      L.append(field('d', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.AssocArray')
    L = out_node.fields
    if self.d:  # ArrayType
      m = hnode.Leaf("map", color_e.OtherConst)
      x0 = hnode.Array([m])
      for k0, v0 in self.d.iteritems():
        x0.children.append(NewLeaf(k0, color_e.StringConst))
        x0.children.append(NewLeaf(v0, color_e.StringConst))
      L.append(field('d', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__Bool(value_t):
  tag = 6
  __slots__ = ('b',)

  def __init__(self, b=None):
    # type: (Optional[bool]) -> None
    self.b = b

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Bool')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.b else 'F', color_e.OtherConst)
    L.append(field('b', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Bool')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.b else 'F', color_e.OtherConst)
    L.append(field('b', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__Float(value_t):
  tag = 7
  __slots__ = ('f',)

  def __init__(self, f=None):
    # type: (Optional[float]) -> None
    self.f = f

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Float')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.f), color_e.OtherConst)
    L.append(field('f', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Float')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.f), color_e.OtherConst)
    L.append(field('f', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__Eggex(value_t):
  tag = 8
  __slots__ = ('expr', 'as_ere')

  def __init__(self, expr=None, as_ere=None):
    # type: (Optional[re_t], Optional[str]) -> None
    self.expr = expr
    self.as_ere = as_ere

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Eggex')
    L = out_node.fields

    assert self.expr is not None
    x0 = self.expr.PrettyTree()
    L.append(field('expr', x0))

    x1 = NewLeaf(self.as_ere, color_e.StringConst)
    L.append(field('as_ere', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Eggex')
    L = out_node.fields
    assert self.expr is not None
    x0 = self.expr.AbbreviatedTree()
    L.append(field('expr', x0))

    x1 = NewLeaf(self.as_ere, color_e.StringConst)
    L.append(field('as_ere', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value__Obj(value_t):
  tag = 9
  __slots__ = ('obj',)

  def __init__(self, obj=None):
    # type: (Optional[Any]) -> None
    self.obj = obj

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Obj')
    L = out_node.fields

    x0 = hnode.External(self.obj)
    L.append(field('obj', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('value.Obj')
    L = out_node.fields
    x0 = hnode.External(self.obj)
    L.append(field('obj', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class value(object):
  Undef = value__Undef
  Str = value__Str
  Int = value__Int
  MaybeStrArray = value__MaybeStrArray
  AssocArray = value__AssocArray
  Bool = value__Bool
  Float = value__Float
  Eggex = value__Eggex
  Obj = value__Obj

class a_index_e(object):
  Str = 1
  Int = 2

_a_index_str = {
  1: 'a_index.Str',
  2: 'a_index.Int',
}

def a_index_str(tag):
  # type: (int) -> str
  return _a_index_str[tag]

class a_index_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class a_index__Str(a_index_t):
  tag = 1
  __slots__ = ('s',)

  def __init__(self, s=None):
    # type: (Optional[str]) -> None
    self.s = s

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('a_index.Str')
    L = out_node.fields

    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('a_index.Str')
    L = out_node.fields
    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class a_index__Int(a_index_t):
  tag = 2
  __slots__ = ('i',)

  def __init__(self, i=None):
    # type: (Optional[int]) -> None
    self.i = i

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('a_index.Int')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(field('i', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('a_index.Int')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(field('i', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class a_index(object):
  Str = a_index__Str
  Int = a_index__Int

class scope_t(pybase.SimpleObj):
  pass

class scope_e(object):
  LocalOnly = scope_t(1)
  GlobalOnly = scope_t(2)
  Dynamic = scope_t(3)
  LocalOrGlobal = scope_t(4)

_scope_str = {
  1: 'scope.LocalOnly',
  2: 'scope.GlobalOnly',
  3: 'scope.Dynamic',
  4: 'scope.LocalOrGlobal',
}

def scope_str(val):
  # type: (scope_t) -> str
  return _scope_str[val]

class lvalue_e(object):
  Named = 1
  Indexed = 2
  Keyed = 3
  ObjIndex = 4
  ObjAttr = 5

_lvalue_str = {
  1: 'lvalue.Named',
  2: 'lvalue.Indexed',
  3: 'lvalue.Keyed',
  4: 'lvalue.ObjIndex',
  5: 'lvalue.ObjAttr',
}

def lvalue_str(tag):
  # type: (int) -> str
  return _lvalue_str[tag]

class lvalue_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class lvalue__Named(lvalue_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.Named')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.Named')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class lvalue__Indexed(lvalue_t):
  tag = 2
  __slots__ = ('name', 'index', 'spids')

  def __init__(self, name=None, index=None, spids=None):
    # type: (Optional[str], Optional[int], Optional[List[int]]) -> None
    self.name = name
    self.index = index
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.Indexed')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    x1 = hnode.Leaf(str(self.index), color_e.OtherConst)
    L.append(field('index', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.Indexed')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    x1 = hnode.Leaf(str(self.index), color_e.OtherConst)
    L.append(field('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class lvalue__Keyed(lvalue_t):
  tag = 3
  __slots__ = ('name', 'key', 'spids')

  def __init__(self, name=None, key=None, spids=None):
    # type: (Optional[str], Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.key = key
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.Keyed')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    x1 = NewLeaf(self.key, color_e.StringConst)
    L.append(field('key', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.Keyed')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    x1 = NewLeaf(self.key, color_e.StringConst)
    L.append(field('key', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class lvalue__ObjIndex(lvalue_t):
  tag = 4
  __slots__ = ('obj', 'index', 'spids')

  def __init__(self, obj=None, index=None, spids=None):
    # type: (Optional[Any], Optional[Any], Optional[List[int]]) -> None
    self.obj = obj
    self.index = index
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.ObjIndex')
    L = out_node.fields

    x0 = hnode.External(self.obj)
    L.append(field('obj', x0))

    x1 = hnode.External(self.index)
    L.append(field('index', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.ObjIndex')
    L = out_node.fields
    x0 = hnode.External(self.obj)
    L.append(field('obj', x0))

    x1 = hnode.External(self.index)
    L.append(field('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class lvalue__ObjAttr(lvalue_t):
  tag = 5
  __slots__ = ('obj', 'attr', 'spids')

  def __init__(self, obj=None, attr=None, spids=None):
    # type: (Optional[Any], Optional[str], Optional[List[int]]) -> None
    self.obj = obj
    self.attr = attr
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.ObjAttr')
    L = out_node.fields

    x0 = hnode.External(self.obj)
    L.append(field('obj', x0))

    x1 = NewLeaf(self.attr, color_e.StringConst)
    L.append(field('attr', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('lvalue.ObjAttr')
    L = out_node.fields
    x0 = hnode.External(self.obj)
    L.append(field('obj', x0))

    x1 = NewLeaf(self.attr, color_e.StringConst)
    L.append(field('attr', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class lvalue(object):
  Named = lvalue__Named
  Indexed = lvalue__Indexed
  Keyed = lvalue__Keyed
  ObjIndex = lvalue__ObjIndex
  ObjAttr = lvalue__ObjAttr

class redirect_arg_e(object):
  Path = 1
  CopyFd = 2
  MoveFd = 3
  CloseFd = 4
  HereDoc = 5

_redirect_arg_str = {
  1: 'redirect_arg.Path',
  2: 'redirect_arg.CopyFd',
  3: 'redirect_arg.MoveFd',
  4: 'redirect_arg.CloseFd',
  5: 'redirect_arg.HereDoc',
}

def redirect_arg_str(tag):
  # type: (int) -> str
  return _redirect_arg_str[tag]

class redirect_arg_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class redirect_arg__Path(redirect_arg_t):
  tag = 1
  __slots__ = ('filename',)

  def __init__(self, filename=None):
    # type: (Optional[str]) -> None
    self.filename = filename

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.Path')
    L = out_node.fields

    x0 = NewLeaf(self.filename, color_e.StringConst)
    L.append(field('filename', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.Path')
    L = out_node.fields
    x0 = NewLeaf(self.filename, color_e.StringConst)
    L.append(field('filename', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redirect_arg__CopyFd(redirect_arg_t):
  tag = 2
  __slots__ = ('target_fd',)

  def __init__(self, target_fd=None):
    # type: (Optional[int]) -> None
    self.target_fd = target_fd

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.CopyFd')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
    L.append(field('target_fd', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.CopyFd')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
    L.append(field('target_fd', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redirect_arg__MoveFd(redirect_arg_t):
  tag = 3
  __slots__ = ('target_fd',)

  def __init__(self, target_fd=None):
    # type: (Optional[int]) -> None
    self.target_fd = target_fd

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.MoveFd')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
    L.append(field('target_fd', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.MoveFd')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
    L.append(field('target_fd', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redirect_arg__CloseFd(redirect_arg_t):
  tag = 4
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.CloseFd')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.CloseFd')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redirect_arg__HereDoc(redirect_arg_t):
  tag = 5
  __slots__ = ('body',)

  def __init__(self, body=None):
    # type: (Optional[str]) -> None
    self.body = body

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.HereDoc')
    L = out_node.fields

    x0 = NewLeaf(self.body, color_e.StringConst)
    L.append(field('body', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect_arg.HereDoc')
    L = out_node.fields
    x0 = NewLeaf(self.body, color_e.StringConst)
    L.append(field('body', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redirect_arg(object):
  Path = redirect_arg__Path
  CopyFd = redirect_arg__CopyFd
  MoveFd = redirect_arg__MoveFd
  CloseFd = redirect_arg__CloseFd
  HereDoc = redirect_arg__HereDoc

class job_status_e(object):
  Proc = 1
  Pipeline = 2

_job_status_str = {
  1: 'job_status.Proc',
  2: 'job_status.Pipeline',
}

def job_status_str(tag):
  # type: (int) -> str
  return _job_status_str[tag]

class job_status_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class job_status__Proc(job_status_t):
  tag = 1
  __slots__ = ('code',)

  def __init__(self, code=None):
    # type: (Optional[int]) -> None
    self.code = code

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('job_status.Proc')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.code), color_e.OtherConst)
    L.append(field('code', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('job_status.Proc')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.code), color_e.OtherConst)
    L.append(field('code', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class job_status__Pipeline(job_status_t):
  tag = 2
  __slots__ = ('codes',)

  def __init__(self, codes=None):
    # type: (Optional[List[int]]) -> None
    self.codes = codes if codes is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('job_status.Pipeline')
    L = out_node.fields

    if self.codes:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.codes:
        x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
      L.append(field('codes', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('job_status.Pipeline')
    L = out_node.fields
    if self.codes:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.codes:
        x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
      L.append(field('codes', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class job_status(object):
  Proc = job_status__Proc
  Pipeline = job_status__Pipeline

class span_t(pybase.SimpleObj):
  pass

class span_e(object):
  Black = span_t(1)
  Delim = span_t(2)
  Backslash = span_t(3)

_span_str = {
  1: 'span.Black',
  2: 'span.Delim',
  3: 'span.Backslash',
}

def span_str(val):
  # type: (span_t) -> str
  return _span_str[val]

emit_t = int  # type alias for integer

class emit_i(object):
  Part = 1
  Delim = 2
  Empty = 3
  Escape = 4
  Nothing = 5
  ARRAY_SIZE = 6

_emit_str = {
  1: 'emit.Part',
  2: 'emit.Delim',
  3: 'emit.Empty',
  4: 'emit.Escape',
  5: 'emit.Nothing',
}

def emit_str(val):
  # type: (emit_t) -> str
  return _emit_str[val]

state_t = int  # type alias for integer

class state_i(object):
  Invalid = 1
  Start = 2
  DE_White1 = 3
  DE_Gray = 4
  DE_White2 = 5
  Black = 6
  Backslash = 7
  Done = 8
  ARRAY_SIZE = 9

_state_str = {
  1: 'state.Invalid',
  2: 'state.Start',
  3: 'state.DE_White1',
  4: 'state.DE_Gray',
  5: 'state.DE_White2',
  6: 'state.Black',
  7: 'state.Backslash',
  8: 'state.Done',
}

def state_str(val):
  # type: (state_t) -> str
  return _state_str[val]

char_kind_t = int  # type alias for integer

class char_kind_i(object):
  DE_White = 1
  DE_Gray = 2
  Black = 3
  Backslash = 4
  Sentinel = 5
  ARRAY_SIZE = 6

_char_kind_str = {
  1: 'char_kind.DE_White',
  2: 'char_kind.DE_Gray',
  3: 'char_kind.Black',
  4: 'char_kind.Backslash',
  5: 'char_kind.Sentinel',
}

def char_kind_str(val):
  # type: (char_kind_t) -> str
  return _char_kind_str[val]

class job_state_t(pybase.SimpleObj):
  pass

class job_state_e(object):
  Running = job_state_t(1)
  Done = job_state_t(2)
  Stopped = job_state_t(3)

_job_state_str = {
  1: 'job_state.Running',
  2: 'job_state.Done',
  3: 'job_state.Stopped',
}

def job_state_str(val):
  # type: (job_state_t) -> str
  return _job_state_str[val]

class word_style_t(pybase.SimpleObj):
  pass

class word_style_e(object):
  Expr = word_style_t(1)
  Unquoted = word_style_t(2)
  DQ = word_style_t(3)
  SQ = word_style_t(4)

_word_style_str = {
  1: 'word_style.Expr',
  2: 'word_style.Unquoted',
  3: 'word_style.DQ',
  4: 'word_style.SQ',
}

def word_style_str(val):
  # type: (word_style_t) -> str
  return _word_style_str[val]

class flag_type_t(pybase.SimpleObj):
  pass

class flag_type_e(object):
  Bool = flag_type_t(1)
  Int = flag_type_t(2)
  Float = flag_type_t(3)
  Str = flag_type_t(4)

_flag_type_str = {
  1: 'flag_type.Bool',
  2: 'flag_type.Int',
  3: 'flag_type.Float',
  4: 'flag_type.Str',
}

def flag_type_str(val):
  # type: (flag_type_t) -> str
  return _flag_type_str[val]

class assign_arg(pybase.CompoundObj):
  tag = 1000
  __slots__ = ('var_name', 'rval', 'spid')

  def __init__(self, var_name=None, rval=None, spid=None):
    # type: (Optional[str], Optional[value_t], Optional[int]) -> None
    self.var_name = var_name
    self.rval = rval if rval is not None else None
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('assign_arg')
    L = out_node.fields

    x0 = NewLeaf(self.var_name, color_e.StringConst)
    L.append(field('var_name', x0))

    if self.rval is not None:  # MaybeType
      x1 = self.rval.PrettyTree()
      L.append(field('rval', x1))

    x2 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('assign_arg')
    L = out_node.fields
    x0 = NewLeaf(self.var_name, color_e.StringConst)
    L.append(field('var_name', x0))

    if self.rval is not None:  # MaybeType
      x1 = self.rval.AbbreviatedTree()
      L.append(field('rval', x1))

    x2 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class cell(pybase.CompoundObj):
  tag = 1001
  __slots__ = ('exported', 'readonly', 'nameref', 'val')

  def __init__(self, exported=None, readonly=None, nameref=None, val=None):
    # type: (Optional[bool], Optional[bool], Optional[bool], Optional[value_t]) -> None
    self.exported = exported
    self.readonly = readonly
    self.nameref = nameref
    self.val = val

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('cell')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.exported else 'F', color_e.OtherConst)
    L.append(field('exported', x0))

    x1 = hnode.Leaf('T' if self.readonly else 'F', color_e.OtherConst)
    L.append(field('readonly', x1))

    x2 = hnode.Leaf('T' if self.nameref else 'F', color_e.OtherConst)
    L.append(field('nameref', x2))

    assert self.val is not None
    x3 = self.val.PrettyTree()
    L.append(field('val', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('cell')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.exported else 'F', color_e.OtherConst)
    L.append(field('exported', x0))

    x1 = hnode.Leaf('T' if self.readonly else 'F', color_e.OtherConst)
    L.append(field('readonly', x1))

    x2 = hnode.Leaf('T' if self.nameref else 'F', color_e.OtherConst)
    L.append(field('nameref', x2))

    assert self.val is not None
    x3 = self.val.AbbreviatedTree()
    L.append(field('val', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redirect(pybase.CompoundObj):
  tag = 1002
  __slots__ = ('op_id', 'op_spid', 'loc', 'arg')

  def __init__(self, op_id=None, op_spid=None, loc=None, arg=None):
    # type: (Optional[Id_t], Optional[int], Optional[redir_loc_t], Optional[redirect_arg_t]) -> None
    self.op_id = op_id
    self.op_spid = op_spid
    self.loc = loc
    self.arg = arg

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    x1 = hnode.Leaf(str(self.op_spid), color_e.OtherConst)
    L.append(field('op_spid', x1))

    assert self.loc is not None
    x2 = self.loc.PrettyTree()
    L.append(field('loc', x2))

    assert self.arg is not None
    x3 = self.arg.PrettyTree()
    L.append(field('arg', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redirect')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    x1 = hnode.Leaf(str(self.op_spid), color_e.OtherConst)
    L.append(field('op_spid', x1))

    assert self.loc is not None
    x2 = self.loc.AbbreviatedTree()
    L.append(field('loc', x2))

    assert self.arg is not None
    x3 = self.arg.AbbreviatedTree()
    L.append(field('arg', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

