from asdl import pybase
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING

from _devbuild.gen.id_kind_asdl import Id_t
from _devbuild.gen.id_kind_asdl import Id_str


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, field

class parse_result_e(object):
  EmptyLine = 1
  Eof = 2
  Node = 3

_parse_result_str = {
  1: 'parse_result.EmptyLine',
  2: 'parse_result.Eof',
  3: 'parse_result.Node',
}

def parse_result_str(tag):
  # type: (int) -> str
  return _parse_result_str[tag]

class parse_result_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class parse_result__EmptyLine(parse_result_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('parse_result.EmptyLine')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('parse_result.EmptyLine')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class parse_result__Eof(parse_result_t):
  tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('parse_result.Eof')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('parse_result.Eof')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class parse_result__Node(parse_result_t):
  tag = 3
  __slots__ = ('cmd',)

  def __init__(self, cmd=None):
    # type: (Optional[command_t]) -> None
    self.cmd = cmd

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('parse_result.Node')
    L = out_node.fields

    assert self.cmd is not None
    x0 = self.cmd.PrettyTree()
    L.append(field('cmd', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('parse_result.Node')
    L = out_node.fields
    assert self.cmd is not None
    x0 = self.cmd.AbbreviatedTree()
    L.append(field('cmd', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class parse_result(object):
  EmptyLine = parse_result__EmptyLine
  Eof = parse_result__Eof
  Node = parse_result__Node

class source_e(object):
  Interactive = 1
  Unused = 2
  CFlag = 3
  Stdin = 4
  MainFile = 5
  SourcedFile = 6
  ArgvWord = 7
  ArgvCommand = 8
  EvalArg = 9
  Trap = 10
  PromptCommand = 11
  Variable = 12
  Alias = 13
  Backticks = 14
  LValue = 15

_source_str = {
  1: 'source.Interactive',
  2: 'source.Unused',
  3: 'source.CFlag',
  4: 'source.Stdin',
  5: 'source.MainFile',
  6: 'source.SourcedFile',
  7: 'source.ArgvWord',
  8: 'source.ArgvCommand',
  9: 'source.EvalArg',
  10: 'source.Trap',
  11: 'source.PromptCommand',
  12: 'source.Variable',
  13: 'source.Alias',
  14: 'source.Backticks',
  15: 'source.LValue',
}

def source_str(tag):
  # type: (int) -> str
  return _source_str[tag]

class source_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class source__Interactive(source_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Interactive')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Interactive')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__Unused(source_t):
  tag = 2
  __slots__ = ('comment',)

  def __init__(self, comment=None):
    # type: (Optional[str]) -> None
    self.comment = comment

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Unused')
    L = out_node.fields

    x0 = NewLeaf(self.comment, color_e.StringConst)
    L.append(field('comment', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Unused')
    L = out_node.fields
    x0 = NewLeaf(self.comment, color_e.StringConst)
    L.append(field('comment', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__CFlag(source_t):
  tag = 3
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.CFlag')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.CFlag')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__Stdin(source_t):
  tag = 4
  __slots__ = ('comment',)

  def __init__(self, comment=None):
    # type: (Optional[str]) -> None
    self.comment = comment

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Stdin')
    L = out_node.fields

    x0 = NewLeaf(self.comment, color_e.StringConst)
    L.append(field('comment', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Stdin')
    L = out_node.fields
    x0 = NewLeaf(self.comment, color_e.StringConst)
    L.append(field('comment', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__MainFile(source_t):
  tag = 5
  __slots__ = ('path',)

  def __init__(self, path=None):
    # type: (Optional[str]) -> None
    self.path = path

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.MainFile')
    L = out_node.fields

    x0 = NewLeaf(self.path, color_e.StringConst)
    L.append(field('path', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.MainFile')
    L = out_node.fields
    x0 = NewLeaf(self.path, color_e.StringConst)
    L.append(field('path', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__SourcedFile(source_t):
  tag = 6
  __slots__ = ('path', 'spid')

  def __init__(self, path=None, spid=None):
    # type: (Optional[str], Optional[int]) -> None
    self.path = path
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.SourcedFile')
    L = out_node.fields

    x0 = NewLeaf(self.path, color_e.StringConst)
    L.append(field('path', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.SourcedFile')
    L = out_node.fields
    x0 = NewLeaf(self.path, color_e.StringConst)
    L.append(field('path', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__ArgvWord(source_t):
  tag = 7
  __slots__ = ('word_spid',)

  def __init__(self, word_spid=None):
    # type: (Optional[int]) -> None
    self.word_spid = word_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.ArgvWord')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.word_spid), color_e.OtherConst)
    L.append(field('word_spid', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.ArgvWord')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.word_spid), color_e.OtherConst)
    L.append(field('word_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__ArgvCommand(source_t):
  tag = 8
  __slots__ = ('first_spid',)

  def __init__(self, first_spid=None):
    # type: (Optional[int]) -> None
    self.first_spid = first_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.ArgvCommand')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.first_spid), color_e.OtherConst)
    L.append(field('first_spid', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.ArgvCommand')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.first_spid), color_e.OtherConst)
    L.append(field('first_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__EvalArg(source_t):
  tag = 9
  __slots__ = ('eval_spid',)

  def __init__(self, eval_spid=None):
    # type: (Optional[int]) -> None
    self.eval_spid = eval_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.EvalArg')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.eval_spid), color_e.OtherConst)
    L.append(field('eval_spid', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.EvalArg')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.eval_spid), color_e.OtherConst)
    L.append(field('eval_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__Trap(source_t):
  tag = 10
  __slots__ = ('word_spid',)

  def __init__(self, word_spid=None):
    # type: (Optional[int]) -> None
    self.word_spid = word_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Trap')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.word_spid), color_e.OtherConst)
    L.append(field('word_spid', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Trap')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.word_spid), color_e.OtherConst)
    L.append(field('word_spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__PromptCommand(source_t):
  tag = 11
  __slots__ = ('spid',)

  def __init__(self, spid=None):
    # type: (Optional[int]) -> None
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.PromptCommand')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.PromptCommand')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__Variable(source_t):
  tag = 12
  __slots__ = ('spid',)

  def __init__(self, spid=None):
    # type: (Optional[int]) -> None
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Variable')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Variable')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__Alias(source_t):
  tag = 13
  __slots__ = ('argv0', 'argv0_spid')

  def __init__(self, argv0=None, argv0_spid=None):
    # type: (Optional[str], Optional[int]) -> None
    self.argv0 = argv0
    self.argv0_spid = argv0_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Alias')
    L = out_node.fields

    x0 = NewLeaf(self.argv0, color_e.StringConst)
    L.append(field('argv0', x0))

    x1 = hnode.Leaf(str(self.argv0_spid), color_e.OtherConst)
    L.append(field('argv0_spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Alias')
    L = out_node.fields
    x0 = NewLeaf(self.argv0, color_e.StringConst)
    L.append(field('argv0', x0))

    x1 = hnode.Leaf(str(self.argv0_spid), color_e.OtherConst)
    L.append(field('argv0_spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__Backticks(source_t):
  tag = 14
  __slots__ = ('left_spid', 'right_spid')

  def __init__(self, left_spid=None, right_spid=None):
    # type: (Optional[int], Optional[int]) -> None
    self.left_spid = left_spid
    self.right_spid = right_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Backticks')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.left_spid), color_e.OtherConst)
    L.append(field('left_spid', x0))

    x1 = hnode.Leaf(str(self.right_spid), color_e.OtherConst)
    L.append(field('right_spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.Backticks')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.left_spid), color_e.OtherConst)
    L.append(field('left_spid', x0))

    x1 = hnode.Leaf(str(self.right_spid), color_e.OtherConst)
    L.append(field('right_spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source__LValue(source_t):
  tag = 15
  __slots__ = ('left_spid', 'right_spid')

  def __init__(self, left_spid=None, right_spid=None):
    # type: (Optional[int], Optional[int]) -> None
    self.left_spid = left_spid
    self.right_spid = right_spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.LValue')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.left_spid), color_e.OtherConst)
    L.append(field('left_spid', x0))

    x1 = hnode.Leaf(str(self.right_spid), color_e.OtherConst)
    L.append(field('right_spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('source.LValue')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.left_spid), color_e.OtherConst)
    L.append(field('left_spid', x0))

    x1 = hnode.Leaf(str(self.right_spid), color_e.OtherConst)
    L.append(field('right_spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class source(object):
  Interactive = source__Interactive
  Unused = source__Unused
  CFlag = source__CFlag
  Stdin = source__Stdin
  MainFile = source__MainFile
  SourcedFile = source__SourcedFile
  ArgvWord = source__ArgvWord
  ArgvCommand = source__ArgvCommand
  EvalArg = source__EvalArg
  Trap = source__Trap
  PromptCommand = source__PromptCommand
  Variable = source__Variable
  Alias = source__Alias
  Backticks = source__Backticks
  LValue = source__LValue

class bracket_op_e(object):
  WholeArray = 1
  ArrayIndex = 2

_bracket_op_str = {
  1: 'bracket_op.WholeArray',
  2: 'bracket_op.ArrayIndex',
}

def bracket_op_str(tag):
  # type: (int) -> str
  return _bracket_op_str[tag]

class bracket_op_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class bracket_op__WholeArray(bracket_op_t):
  tag = 1
  __slots__ = ('op_id',)

  def __init__(self, op_id=None):
    # type: (Optional[Id_t]) -> None
    self.op_id = op_id

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bracket_op.WholeArray')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bracket_op.WholeArray')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bracket_op__ArrayIndex(bracket_op_t):
  tag = 2
  __slots__ = ('expr',)

  def __init__(self, expr=None):
    # type: (Optional[arith_expr_t]) -> None
    self.expr = expr

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bracket_op.ArrayIndex')
    L = out_node.fields

    assert self.expr is not None
    x0 = self.expr.PrettyTree()
    L.append(field('expr', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bracket_op.ArrayIndex')
    L = out_node.fields
    assert self.expr is not None
    x0 = self.expr.AbbreviatedTree()
    L.append(field('expr', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bracket_op(object):
  WholeArray = bracket_op__WholeArray
  ArrayIndex = bracket_op__ArrayIndex

class suffix_op_e(object):
  Nullary = 1001
  Unary = 2
  PatSub = 3
  Slice = 4

_suffix_op_str = {
  2: 'suffix_op.Unary',
  3: 'suffix_op.PatSub',
  4: 'suffix_op.Slice',
  1001: 'suffix_op.Nullary',
}

def suffix_op_str(tag):
  # type: (int) -> str
  return _suffix_op_str[tag]

class suffix_op_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class suffix_op__Unary(suffix_op_t):
  tag = 2
  __slots__ = ('op_id', 'arg_word', 'spids')

  def __init__(self, op_id=None, arg_word=None, spids=None):
    # type: (Optional[Id_t], Optional[word_t], Optional[List[int]]) -> None
    self.op_id = op_id
    self.arg_word = arg_word
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('suffix_op.Unary')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.arg_word is not None
    x1 = self.arg_word.PrettyTree()
    L.append(field('arg_word', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('suffix_op.Unary')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.arg_word is not None
    x1 = self.arg_word.AbbreviatedTree()
    L.append(field('arg_word', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class suffix_op__PatSub(suffix_op_t):
  tag = 3
  __slots__ = ('pat', 'replace', 'replace_mode', 'spids')

  def __init__(self, pat=None, replace=None, replace_mode=None, spids=None):
    # type: (Optional[word_t], Optional[word_t], Optional[Id_t], Optional[List[int]]) -> None
    self.pat = pat
    self.replace = replace if replace is not None else None
    self.replace_mode = replace_mode
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('suffix_op.PatSub')
    L = out_node.fields

    assert self.pat is not None
    x0 = self.pat.PrettyTree()
    L.append(field('pat', x0))

    if self.replace is not None:  # MaybeType
      x1 = self.replace.PrettyTree()
      L.append(field('replace', x1))

    x2 = hnode.Leaf(Id_str(self.replace_mode), color_e.UserType)
    L.append(field('replace_mode', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('suffix_op.PatSub')
    L = out_node.fields
    assert self.pat is not None
    x0 = self.pat.AbbreviatedTree()
    L.append(field('pat', x0))

    if self.replace is not None:  # MaybeType
      x1 = self.replace.AbbreviatedTree()
      L.append(field('replace', x1))

    x2 = hnode.Leaf(Id_str(self.replace_mode), color_e.UserType)
    L.append(field('replace_mode', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class suffix_op__Slice(suffix_op_t):
  tag = 4
  __slots__ = ('begin', 'length', 'spids')

  def __init__(self, begin=None, length=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.begin = begin if begin is not None else None
    self.length = length if length is not None else None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('suffix_op.Slice')
    L = out_node.fields

    if self.begin is not None:  # MaybeType
      x0 = self.begin.PrettyTree()
      L.append(field('begin', x0))

    if self.length is not None:  # MaybeType
      x1 = self.length.PrettyTree()
      L.append(field('length', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('suffix_op.Slice')
    L = out_node.fields
    if self.begin is not None:  # MaybeType
      x0 = self.begin.AbbreviatedTree()
      L.append(field('begin', x0))

    if self.length is not None:  # MaybeType
      x1 = self.length.AbbreviatedTree()
      L.append(field('length', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class suffix_op(object):
  Unary = suffix_op__Unary
  PatSub = suffix_op__PatSub
  Slice = suffix_op__Slice

class word_part_e(object):
  ShArrayLiteral = 1008
  AssocArrayLiteral = 2
  Literal = 1001
  EscapedLiteral = 4
  SingleQuoted = 1004
  DoubleQuoted = 1003
  SimpleVarSub = 1005
  BracedVarSub = 1006
  CommandSub = 1007
  TildeSub = 10
  ArithSub = 11
  BracedTuple = 12
  BracedRange = 13
  ExtGlob = 14
  Splice = 15
  FuncCall = 16
  ExprSub = 17

_word_part_str = {
  2: 'word_part.AssocArrayLiteral',
  4: 'word_part.EscapedLiteral',
  10: 'word_part.TildeSub',
  11: 'word_part.ArithSub',
  12: 'word_part.BracedTuple',
  13: 'word_part.BracedRange',
  14: 'word_part.ExtGlob',
  15: 'word_part.Splice',
  16: 'word_part.FuncCall',
  17: 'word_part.ExprSub',
  1001: 'word_part.Literal',
  1003: 'word_part.DoubleQuoted',
  1004: 'word_part.SingleQuoted',
  1005: 'word_part.SimpleVarSub',
  1006: 'word_part.BracedVarSub',
  1007: 'word_part.CommandSub',
  1008: 'word_part.ShArrayLiteral',
}

def word_part_str(tag):
  # type: (int) -> str
  return _word_part_str[tag]

class word_part_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class word_part__AssocArrayLiteral(word_part_t):
  tag = 2
  __slots__ = ('left', 'pairs', 'spids')

  def __init__(self, left=None, pairs=None, spids=None):
    # type: (Optional[Token], Optional[List[compound_word]], Optional[List[int]]) -> None
    self.left = left
    self.pairs = pairs if pairs is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.AssocArrayLiteral')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    if self.pairs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.pairs:
        x1.children.append(i1.PrettyTree())
      L.append(field('pairs', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.AssocArrayLiteral')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    if self.pairs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.pairs:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('pairs', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__EscapedLiteral(word_part_t):
  tag = 4
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[Token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.EscapedLiteral')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(field('token', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.EscapedLiteral')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(field('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__TildeSub(word_part_t):
  tag = 10
  __slots__ = ('token', 'spids')

  def __init__(self, token=None, spids=None):
    # type: (Optional[Token], Optional[List[int]]) -> None
    self.token = token
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.TildeSub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(field('token', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.TildeSub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(field('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__ArithSub(word_part_t):
  tag = 11
  __slots__ = ('anode', 'spids')

  def __init__(self, anode=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[List[int]]) -> None
    self.anode = anode
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.ArithSub')
    L = out_node.fields

    assert self.anode is not None
    x0 = self.anode.PrettyTree()
    L.append(field('anode', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.ArithSub')
    L = out_node.fields
    assert self.anode is not None
    x0 = self.anode.AbbreviatedTree()
    L.append(field('anode', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__BracedTuple(word_part_t):
  tag = 12
  __slots__ = ('words', 'spids')

  def __init__(self, words=None, spids=None):
    # type: (Optional[List[compound_word]], Optional[List[int]]) -> None
    self.words = words if words is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.BracedTuple')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(field('words', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.BracedTuple')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('words', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__BracedRange(word_part_t):
  tag = 13
  __slots__ = ('kind', 'start', 'end', 'step', 'spids')

  def __init__(self, kind=None, start=None, end=None, step=None, spids=None):
    # type: (Optional[Id_t], Optional[str], Optional[str], Optional[int], Optional[List[int]]) -> None
    self.kind = kind
    self.start = start
    self.end = end
    self.step = step
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.BracedRange')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.kind), color_e.UserType)
    L.append(field('kind', x0))

    x1 = NewLeaf(self.start, color_e.StringConst)
    L.append(field('start', x1))

    x2 = NewLeaf(self.end, color_e.StringConst)
    L.append(field('end', x2))

    x3 = hnode.Leaf(str(self.step), color_e.OtherConst)
    L.append(field('step', x3))

    if self.spids:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.spids:
        x4.children.append(hnode.Leaf(str(i4), color_e.OtherConst))
      L.append(field('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.BracedRange')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.kind), color_e.UserType)
    L.append(field('kind', x0))

    x1 = NewLeaf(self.start, color_e.StringConst)
    L.append(field('start', x1))

    x2 = NewLeaf(self.end, color_e.StringConst)
    L.append(field('end', x2))

    x3 = hnode.Leaf(str(self.step), color_e.OtherConst)
    L.append(field('step', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__ExtGlob(word_part_t):
  tag = 14
  __slots__ = ('op', 'arms', 'spids')

  def __init__(self, op=None, arms=None, spids=None):
    # type: (Optional[Token], Optional[List[word_t]], Optional[List[int]]) -> None
    self.op = op
    self.arms = arms if arms is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.ExtGlob')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(field('op', x0))

    if self.arms:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.arms:
        x1.children.append(i1.PrettyTree())
      L.append(field('arms', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.ExtGlob')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(field('op', x0))

    if self.arms:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.arms:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('arms', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__Splice(word_part_t):
  tag = 15
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[Token], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.Splice')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.Splice')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__FuncCall(word_part_t):
  tag = 16
  __slots__ = ('name', 'args', 'spids')

  def __init__(self, name=None, args=None, spids=None):
    # type: (Optional[Token], Optional[arg_list], Optional[List[int]]) -> None
    self.name = name
    self.args = args
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.FuncCall')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    assert self.args is not None
    x1 = self.args.PrettyTree()
    L.append(field('args', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.FuncCall')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    assert self.args is not None
    x1 = self.args.AbbreviatedTree()
    L.append(field('args', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part__ExprSub(word_part_t):
  tag = 17
  __slots__ = ('left', 'child', 'spids')

  def __init__(self, left=None, child=None, spids=None):
    # type: (Optional[Token], Optional[expr_t], Optional[List[int]]) -> None
    self.left = left
    self.child = child
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.ExprSub')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(field('child', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word_part.ExprSub')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(field('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word_part(object):
  AssocArrayLiteral = word_part__AssocArrayLiteral
  EscapedLiteral = word_part__EscapedLiteral
  TildeSub = word_part__TildeSub
  ArithSub = word_part__ArithSub
  BracedTuple = word_part__BracedTuple
  BracedRange = word_part__BracedRange
  ExtGlob = word_part__ExtGlob
  Splice = word_part__Splice
  FuncCall = word_part__FuncCall
  ExprSub = word_part__ExprSub

class word_e(object):
  Empty = 1
  Token = 1001
  Compound = 1010
  BracedTree = 4
  String = 5

_word_str = {
  1: 'word.Empty',
  4: 'word.BracedTree',
  5: 'word.String',
  1001: 'word.Token',
  1010: 'word.Compound',
}

def word_str(tag):
  # type: (int) -> str
  return _word_str[tag]

class word_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class word__Empty(word_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word.Empty')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word.Empty')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word__BracedTree(word_t):
  tag = 4
  __slots__ = ('parts',)

  def __init__(self, parts=None):
    # type: (Optional[List[word_part_t]]) -> None
    self.parts = parts if parts is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word.BracedTree')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(field('parts', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word.BracedTree')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word__String(word_t):
  tag = 5
  __slots__ = ('id', 's', 'span_id')

  def __init__(self, id=None, s=None, span_id=None):
    # type: (Optional[Id_t], Optional[str], Optional[int]) -> None
    self.id = id
    self.s = s
    self.span_id = span_id

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word.String')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x1))

    x2 = hnode.Leaf(str(self.span_id), color_e.OtherConst)
    L.append(field('span_id', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('word.String')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x1))

    x2 = hnode.Leaf(str(self.span_id), color_e.OtherConst)
    L.append(field('span_id', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class word(object):
  Empty = word__Empty
  BracedTree = word__BracedTree
  String = word__String

class sh_lhs_expr_e(object):
  Name = 1
  IndexedName = 2
  UnparsedIndex = 3

_sh_lhs_expr_str = {
  1: 'sh_lhs_expr.Name',
  2: 'sh_lhs_expr.IndexedName',
  3: 'sh_lhs_expr.UnparsedIndex',
}

def sh_lhs_expr_str(tag):
  # type: (int) -> str
  return _sh_lhs_expr_str[tag]

class sh_lhs_expr_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class sh_lhs_expr__Name(sh_lhs_expr_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_lhs_expr.Name')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_lhs_expr.Name')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class sh_lhs_expr__IndexedName(sh_lhs_expr_t):
  tag = 2
  __slots__ = ('name', 'index', 'spids')

  def __init__(self, name=None, index=None, spids=None):
    # type: (Optional[str], Optional[arith_expr_t], Optional[List[int]]) -> None
    self.name = name
    self.index = index
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_lhs_expr.IndexedName')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    assert self.index is not None
    x1 = self.index.PrettyTree()
    L.append(field('index', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_lhs_expr.IndexedName')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    assert self.index is not None
    x1 = self.index.AbbreviatedTree()
    L.append(field('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class sh_lhs_expr__UnparsedIndex(sh_lhs_expr_t):
  tag = 3
  __slots__ = ('name', 'index', 'spids')

  def __init__(self, name=None, index=None, spids=None):
    # type: (Optional[str], Optional[str], Optional[List[int]]) -> None
    self.name = name
    self.index = index
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_lhs_expr.UnparsedIndex')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    x1 = NewLeaf(self.index, color_e.StringConst)
    L.append(field('index', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_lhs_expr.UnparsedIndex')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    x1 = NewLeaf(self.index, color_e.StringConst)
    L.append(field('index', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class sh_lhs_expr(object):
  Name = sh_lhs_expr__Name
  IndexedName = sh_lhs_expr__IndexedName
  UnparsedIndex = sh_lhs_expr__UnparsedIndex

class arith_expr_e(object):
  VarRef = 1001
  Word = 1010
  UnaryAssign = 3
  BinaryAssign = 4
  Unary = 5
  Binary = 6
  TernaryOp = 7

_arith_expr_str = {
  3: 'arith_expr.UnaryAssign',
  4: 'arith_expr.BinaryAssign',
  5: 'arith_expr.Unary',
  6: 'arith_expr.Binary',
  7: 'arith_expr.TernaryOp',
  1001: 'arith_expr.VarRef',
  1010: 'arith_expr.Word',
}

def arith_expr_str(tag):
  # type: (int) -> str
  return _arith_expr_str[tag]

class arith_expr_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class arith_expr__UnaryAssign(arith_expr_t):
  tag = 3
  __slots__ = ('op_id', 'child')

  def __init__(self, op_id=None, child=None):
    # type: (Optional[Id_t], Optional[arith_expr_t]) -> None
    self.op_id = op_id
    self.child = child

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.UnaryAssign')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(field('child', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.UnaryAssign')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(field('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class arith_expr__BinaryAssign(arith_expr_t):
  tag = 4
  __slots__ = ('op_id', 'left', 'right')

  def __init__(self, op_id=None, left=None, right=None):
    # type: (Optional[Id_t], Optional[arith_expr_t], Optional[arith_expr_t]) -> None
    self.op_id = op_id
    self.left = left
    self.right = right

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.BinaryAssign')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(field('right', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.BinaryAssign')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(field('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class arith_expr__Unary(arith_expr_t):
  tag = 5
  __slots__ = ('op_id', 'child')

  def __init__(self, op_id=None, child=None):
    # type: (Optional[Id_t], Optional[arith_expr_t]) -> None
    self.op_id = op_id
    self.child = child

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.Unary')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(field('child', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.Unary')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(field('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class arith_expr__Binary(arith_expr_t):
  tag = 6
  __slots__ = ('op_id', 'left', 'right')

  def __init__(self, op_id=None, left=None, right=None):
    # type: (Optional[Id_t], Optional[arith_expr_t], Optional[arith_expr_t]) -> None
    self.op_id = op_id
    self.left = left
    self.right = right

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.Binary')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(field('right', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.Binary')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(field('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class arith_expr__TernaryOp(arith_expr_t):
  tag = 7
  __slots__ = ('cond', 'true_expr', 'false_expr')

  def __init__(self, cond=None, true_expr=None, false_expr=None):
    # type: (Optional[arith_expr_t], Optional[arith_expr_t], Optional[arith_expr_t]) -> None
    self.cond = cond
    self.true_expr = true_expr
    self.false_expr = false_expr

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.TernaryOp')
    L = out_node.fields

    assert self.cond is not None
    x0 = self.cond.PrettyTree()
    L.append(field('cond', x0))

    assert self.true_expr is not None
    x1 = self.true_expr.PrettyTree()
    L.append(field('true_expr', x1))

    assert self.false_expr is not None
    x2 = self.false_expr.PrettyTree()
    L.append(field('false_expr', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arith_expr.TernaryOp')
    L = out_node.fields
    assert self.cond is not None
    x0 = self.cond.AbbreviatedTree()
    L.append(field('cond', x0))

    assert self.true_expr is not None
    x1 = self.true_expr.AbbreviatedTree()
    L.append(field('true_expr', x1))

    assert self.false_expr is not None
    x2 = self.false_expr.AbbreviatedTree()
    L.append(field('false_expr', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class arith_expr(object):
  UnaryAssign = arith_expr__UnaryAssign
  BinaryAssign = arith_expr__BinaryAssign
  Unary = arith_expr__Unary
  Binary = arith_expr__Binary
  TernaryOp = arith_expr__TernaryOp

class bool_expr_e(object):
  WordTest = 1
  Binary = 2
  Unary = 3
  LogicalNot = 4
  LogicalAnd = 5
  LogicalOr = 6

_bool_expr_str = {
  1: 'bool_expr.WordTest',
  2: 'bool_expr.Binary',
  3: 'bool_expr.Unary',
  4: 'bool_expr.LogicalNot',
  5: 'bool_expr.LogicalAnd',
  6: 'bool_expr.LogicalOr',
}

def bool_expr_str(tag):
  # type: (int) -> str
  return _bool_expr_str[tag]

class bool_expr_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class bool_expr__WordTest(bool_expr_t):
  tag = 1
  __slots__ = ('w',)

  def __init__(self, w=None):
    # type: (Optional[word_t]) -> None
    self.w = w

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.WordTest')
    L = out_node.fields

    assert self.w is not None
    x0 = self.w.PrettyTree()
    L.append(field('w', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.WordTest')
    L = out_node.fields
    assert self.w is not None
    x0 = self.w.AbbreviatedTree()
    L.append(field('w', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bool_expr__Binary(bool_expr_t):
  tag = 2
  __slots__ = ('op_id', 'left', 'right')

  def __init__(self, op_id=None, left=None, right=None):
    # type: (Optional[Id_t], Optional[word_t], Optional[word_t]) -> None
    self.op_id = op_id
    self.left = left
    self.right = right

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.Binary')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(field('right', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.Binary')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(field('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bool_expr__Unary(bool_expr_t):
  tag = 3
  __slots__ = ('op_id', 'child')

  def __init__(self, op_id=None, child=None):
    # type: (Optional[Id_t], Optional[word_t]) -> None
    self.op_id = op_id
    self.child = child

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.Unary')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(field('child', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.Unary')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(field('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bool_expr__LogicalNot(bool_expr_t):
  tag = 4
  __slots__ = ('child',)

  def __init__(self, child=None):
    # type: (Optional[bool_expr_t]) -> None
    self.child = child

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.LogicalNot')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.LogicalNot')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bool_expr__LogicalAnd(bool_expr_t):
  tag = 5
  __slots__ = ('left', 'right')

  def __init__(self, left=None, right=None):
    # type: (Optional[bool_expr_t], Optional[bool_expr_t]) -> None
    self.left = left
    self.right = right

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.LogicalAnd')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    assert self.right is not None
    x1 = self.right.PrettyTree()
    L.append(field('right', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.LogicalAnd')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    assert self.right is not None
    x1 = self.right.AbbreviatedTree()
    L.append(field('right', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bool_expr__LogicalOr(bool_expr_t):
  tag = 6
  __slots__ = ('left', 'right')

  def __init__(self, left=None, right=None):
    # type: (Optional[bool_expr_t], Optional[bool_expr_t]) -> None
    self.left = left
    self.right = right

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.LogicalOr')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    assert self.right is not None
    x1 = self.right.PrettyTree()
    L.append(field('right', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('bool_expr.LogicalOr')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    assert self.right is not None
    x1 = self.right.AbbreviatedTree()
    L.append(field('right', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class bool_expr(object):
  WordTest = bool_expr__WordTest
  Binary = bool_expr__Binary
  Unary = bool_expr__Unary
  LogicalNot = bool_expr__LogicalNot
  LogicalAnd = bool_expr__LogicalAnd
  LogicalOr = bool_expr__LogicalOr

class redir_loc_e(object):
  Fd = 1
  VarName = 2

_redir_loc_str = {
  1: 'redir_loc.Fd',
  2: 'redir_loc.VarName',
}

def redir_loc_str(tag):
  # type: (int) -> str
  return _redir_loc_str[tag]

class redir_loc_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class redir_loc__Fd(redir_loc_t):
  tag = 1
  __slots__ = ('fd',)

  def __init__(self, fd=None):
    # type: (Optional[int]) -> None
    self.fd = fd

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir_loc.Fd')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.fd), color_e.OtherConst)
    L.append(field('fd', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir_loc.Fd')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.fd), color_e.OtherConst)
    L.append(field('fd', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redir_loc__VarName(redir_loc_t):
  tag = 2
  __slots__ = ('name',)

  def __init__(self, name=None):
    # type: (Optional[str]) -> None
    self.name = name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir_loc.VarName')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir_loc.VarName')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redir_loc(object):
  Fd = redir_loc__Fd
  VarName = redir_loc__VarName

class redir_param_e(object):
  Word = 1010
  MultiLine = 2

_redir_param_str = {
  2: 'redir_param.MultiLine',
  1010: 'redir_param.Word',
}

def redir_param_str(tag):
  # type: (int) -> str
  return _redir_param_str[tag]

class redir_param_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class redir_param__MultiLine(redir_param_t):
  tag = 2
  __slots__ = ('here_begin', 'here_end_span_id', 'stdin_parts')

  def __init__(self, here_begin=None, here_end_span_id=None, stdin_parts=None):
    # type: (Optional[word_t], Optional[int], Optional[List[word_part_t]]) -> None
    self.here_begin = here_begin
    self.here_end_span_id = here_end_span_id
    self.stdin_parts = stdin_parts if stdin_parts is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir_param.MultiLine')
    L = out_node.fields

    assert self.here_begin is not None
    x0 = self.here_begin.PrettyTree()
    L.append(field('here_begin', x0))

    x1 = hnode.Leaf(str(self.here_end_span_id), color_e.OtherConst)
    L.append(field('here_end_span_id', x1))

    if self.stdin_parts:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.stdin_parts:
        x2.children.append(i2.PrettyTree())
      L.append(field('stdin_parts', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir_param.MultiLine')
    L = out_node.fields
    assert self.here_begin is not None
    x0 = self.here_begin.AbbreviatedTree()
    L.append(field('here_begin', x0))

    x1 = hnode.Leaf(str(self.here_end_span_id), color_e.OtherConst)
    L.append(field('here_end_span_id', x1))

    if self.stdin_parts:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.stdin_parts:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('stdin_parts', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class redir_param(object):
  MultiLine = redir_param__MultiLine

class assign_op_t(pybase.SimpleObj):
  pass

class assign_op_e(object):
  Equal = assign_op_t(1)
  PlusEqual = assign_op_t(2)

_assign_op_str = {
  1: 'assign_op.Equal',
  2: 'assign_op.PlusEqual',
}

def assign_op_str(val):
  # type: (assign_op_t) -> str
  return _assign_op_str[val]

class command_e(object):
  NoOp = 1
  Simple = 2
  ExpandedAlias = 3
  Sentence = 4
  ShAssignment = 5
  ControlFlow = 6
  Pipeline = 7
  AndOr = 8
  DoGroup = 9
  BraceGroup = 1016
  Subshell = 11
  DParen = 12
  DBracket = 13
  ForEach = 14
  ForExpr = 15
  WhileUntil = 16
  If = 17
  Case = 18
  ShFunction = 19
  TimeBlock = 20
  CommandList = 21
  BareDecl = 22
  VarDecl = 23
  PlaceMutation = 24
  Expr = 25
  Return = 26
  OilCondition = 27
  OilForIn = 28
  Proc = 29
  Func = 30
  Data = 31
  Enum = 32
  Class = 33
  Use = 34

_command_str = {
  1: 'command.NoOp',
  2: 'command.Simple',
  3: 'command.ExpandedAlias',
  4: 'command.Sentence',
  5: 'command.ShAssignment',
  6: 'command.ControlFlow',
  7: 'command.Pipeline',
  8: 'command.AndOr',
  9: 'command.DoGroup',
  11: 'command.Subshell',
  12: 'command.DParen',
  13: 'command.DBracket',
  14: 'command.ForEach',
  15: 'command.ForExpr',
  16: 'command.WhileUntil',
  17: 'command.If',
  18: 'command.Case',
  19: 'command.ShFunction',
  20: 'command.TimeBlock',
  21: 'command.CommandList',
  22: 'command.BareDecl',
  23: 'command.VarDecl',
  24: 'command.PlaceMutation',
  25: 'command.Expr',
  26: 'command.Return',
  27: 'command.OilCondition',
  28: 'command.OilForIn',
  29: 'command.Proc',
  30: 'command.Func',
  31: 'command.Data',
  32: 'command.Enum',
  33: 'command.Class',
  34: 'command.Use',
  1016: 'command.BraceGroup',
}

def command_str(tag):
  # type: (int) -> str
  return _command_str[tag]

class command_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class command__NoOp(command_t):
  tag = 1
  __slots__ = ('spids',)

  def __init__(self, spids=None):
    # type: (Optional[List[int]]) -> None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.NoOp')
    L = out_node.fields

    if self.spids:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.spids:
        x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
      L.append(field('spids', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.NoOp')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Simple(command_t):
  tag = 2
  __slots__ = ('words', 'redirects', 'more_env', 'block', 'do_fork', 'spids')

  def __init__(self, words=None, redirects=None, more_env=None, block=None,
               do_fork=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[redir]], Optional[List[env_pair]], Optional[BraceGroup], Optional[bool], Optional[List[int]]) -> None
    self.words = words if words is not None else []
    self.redirects = redirects if redirects is not None else []
    self.more_env = more_env if more_env is not None else []
    self.block = block if block is not None else None
    self.do_fork = do_fork
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Simple')
    L = out_node.fields

    if self.words:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.words:
        x0.children.append(i0.PrettyTree())
      L.append(field('words', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.more_env:
        x2.children.append(i2.PrettyTree())
      L.append(field('more_env', x2))

    if self.block is not None:  # MaybeType
      x3 = self.block.PrettyTree()
      L.append(field('block', x3))

    x4 = hnode.Leaf('T' if self.do_fork else 'F', color_e.OtherConst)
    L.append(field('do_fork', x4))

    if self.spids:  # ArrayType
      x5 = hnode.Array([])
      for i5 in self.spids:
        x5.children.append(hnode.Leaf(str(i5), color_e.OtherConst))
      L.append(field('spids', x5))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Simple')
    L = out_node.fields
    if self.words:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.words:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('words', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.more_env:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('more_env', x2))

    if self.block is not None:  # MaybeType
      x3 = self.block.AbbreviatedTree()
      L.append(field('block', x3))

    x4 = hnode.Leaf('T' if self.do_fork else 'F', color_e.OtherConst)
    L.append(field('do_fork', x4))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _command__Simple(self)
    return p if p else self._AbbreviatedTree()

class command__ExpandedAlias(command_t):
  tag = 3
  __slots__ = ('child', 'redirects', 'more_env', 'spids')

  def __init__(self, child=None, redirects=None, more_env=None, spids=None):
    # type: (Optional[command_t], Optional[List[redir]], Optional[List[env_pair]], Optional[List[int]]) -> None
    self.child = child
    self.redirects = redirects if redirects is not None else []
    self.more_env = more_env if more_env is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ExpandedAlias')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.more_env:
        x2.children.append(i2.PrettyTree())
      L.append(field('more_env', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ExpandedAlias')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    if self.more_env:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.more_env:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('more_env', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Sentence(command_t):
  tag = 4
  __slots__ = ('child', 'terminator', 'spids')

  def __init__(self, child=None, terminator=None, spids=None):
    # type: (Optional[command_t], Optional[Token], Optional[List[int]]) -> None
    self.child = child
    self.terminator = terminator
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Sentence')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    assert self.terminator is not None
    x1 = self.terminator.PrettyTree()
    L.append(field('terminator', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Sentence')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    assert self.terminator is not None
    x1 = self.terminator.AbbreviatedTree()
    L.append(field('terminator', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__ShAssignment(command_t):
  tag = 5
  __slots__ = ('pairs', 'redirects', 'spids')

  def __init__(self, pairs=None, redirects=None, spids=None):
    # type: (Optional[List[assign_pair]], Optional[List[redir]], Optional[List[int]]) -> None
    self.pairs = pairs if pairs is not None else []
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ShAssignment')
    L = out_node.fields

    if self.pairs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.pairs:
        x0.children.append(i0.PrettyTree())
      L.append(field('pairs', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ShAssignment')
    L = out_node.fields
    if self.pairs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.pairs:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('pairs', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__ControlFlow(command_t):
  tag = 6
  __slots__ = ('token', 'arg_word', 'spids')

  def __init__(self, token=None, arg_word=None, spids=None):
    # type: (Optional[Token], Optional[word_t], Optional[List[int]]) -> None
    self.token = token
    self.arg_word = arg_word if arg_word is not None else None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ControlFlow')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(field('token', x0))

    if self.arg_word is not None:  # MaybeType
      x1 = self.arg_word.PrettyTree()
      L.append(field('arg_word', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ControlFlow')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(field('token', x0))

    if self.arg_word is not None:  # MaybeType
      x1 = self.arg_word.AbbreviatedTree()
      L.append(field('arg_word', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Pipeline(command_t):
  tag = 7
  __slots__ = ('children', 'negated', 'stderr_indices', 'spids')

  def __init__(self, children=None, negated=None, stderr_indices=None,
               spids=None):
    # type: (Optional[List[command_t]], Optional[bool], Optional[List[int]], Optional[List[int]]) -> None
    self.children = children if children is not None else []
    self.negated = negated
    self.stderr_indices = stderr_indices if stderr_indices is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Pipeline')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(field('children', x0))

    x1 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x1))

    if self.stderr_indices:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.stderr_indices:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('stderr_indices', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Pipeline')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('children', x0))

    x1 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x1))

    if self.stderr_indices:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.stderr_indices:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('stderr_indices', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__AndOr(command_t):
  tag = 8
  __slots__ = ('ops', 'children', 'spids')

  def __init__(self, ops=None, children=None, spids=None):
    # type: (Optional[List[Id_t]], Optional[List[command_t]], Optional[List[int]]) -> None
    self.ops = ops if ops is not None else []
    self.children = children if children is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.AndOr')
    L = out_node.fields

    if self.ops:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.ops:
        x0.children.append(hnode.Leaf(Id_str(i0), color_e.UserType))
      L.append(field('ops', x0))

    if self.children:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.children:
        x1.children.append(i1.PrettyTree())
      L.append(field('children', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.AndOr')
    L = out_node.fields
    if self.ops:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.ops:
        x0.children.append(hnode.Leaf(Id_str(i0), color_e.UserType))
      L.append(field('ops', x0))

    if self.children:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.children:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('children', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__DoGroup(command_t):
  tag = 9
  __slots__ = ('children', 'spids')

  def __init__(self, children=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[int]]) -> None
    self.children = children if children is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.DoGroup')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(field('children', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.DoGroup')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('children', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Subshell(command_t):
  tag = 11
  __slots__ = ('child', 'redirects', 'spids')

  def __init__(self, child=None, redirects=None, spids=None):
    # type: (Optional[command_t], Optional[List[redir]], Optional[List[int]]) -> None
    self.child = child
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Subshell')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Subshell')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__DParen(command_t):
  tag = 12
  __slots__ = ('child', 'redirects', 'spids')

  def __init__(self, child=None, redirects=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[List[redir]], Optional[List[int]]) -> None
    self.child = child
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.DParen')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.DParen')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__DBracket(command_t):
  tag = 13
  __slots__ = ('expr', 'redirects', 'spids')

  def __init__(self, expr=None, redirects=None, spids=None):
    # type: (Optional[bool_expr_t], Optional[List[redir]], Optional[List[int]]) -> None
    self.expr = expr
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.DBracket')
    L = out_node.fields

    assert self.expr is not None
    x0 = self.expr.PrettyTree()
    L.append(field('expr', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.DBracket')
    L = out_node.fields
    assert self.expr is not None
    x0 = self.expr.AbbreviatedTree()
    L.append(field('expr', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__ForEach(command_t):
  tag = 14
  __slots__ = ('iter_name', 'iter_words', 'do_arg_iter', 'body', 'redirects',
               'spids')

  def __init__(self, iter_name=None, iter_words=None, do_arg_iter=None,
               body=None, redirects=None, spids=None):
    # type: (Optional[str], Optional[List[word_t]], Optional[bool], Optional[command_t], Optional[List[redir]], Optional[List[int]]) -> None
    self.iter_name = iter_name
    self.iter_words = iter_words if iter_words is not None else []
    self.do_arg_iter = do_arg_iter
    self.body = body
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ForEach')
    L = out_node.fields

    x0 = NewLeaf(self.iter_name, color_e.StringConst)
    L.append(field('iter_name', x0))

    if self.iter_words:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.iter_words:
        x1.children.append(i1.PrettyTree())
      L.append(field('iter_words', x1))

    x2 = hnode.Leaf('T' if self.do_arg_iter else 'F', color_e.OtherConst)
    L.append(field('do_arg_iter', x2))

    assert self.body is not None
    x3 = self.body.PrettyTree()
    L.append(field('body', x3))

    if self.redirects:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.redirects:
        x4.children.append(i4.PrettyTree())
      L.append(field('redirects', x4))

    if self.spids:  # ArrayType
      x5 = hnode.Array([])
      for i5 in self.spids:
        x5.children.append(hnode.Leaf(str(i5), color_e.OtherConst))
      L.append(field('spids', x5))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ForEach')
    L = out_node.fields
    x0 = NewLeaf(self.iter_name, color_e.StringConst)
    L.append(field('iter_name', x0))

    if self.iter_words:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.iter_words:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('iter_words', x1))

    x2 = hnode.Leaf('T' if self.do_arg_iter else 'F', color_e.OtherConst)
    L.append(field('do_arg_iter', x2))

    assert self.body is not None
    x3 = self.body.AbbreviatedTree()
    L.append(field('body', x3))

    if self.redirects:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.redirects:
        x4.children.append(i4.AbbreviatedTree())
      L.append(field('redirects', x4))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__ForExpr(command_t):
  tag = 15
  __slots__ = ('init', 'cond', 'update', 'body', 'redirects', 'spids')

  def __init__(self, init=None, cond=None, update=None, body=None,
               redirects=None, spids=None):
    # type: (Optional[arith_expr_t], Optional[arith_expr_t], Optional[arith_expr_t], Optional[command_t], Optional[List[redir]], Optional[List[int]]) -> None
    self.init = init if init is not None else None
    self.cond = cond if cond is not None else None
    self.update = update if update is not None else None
    self.body = body if body is not None else None
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ForExpr')
    L = out_node.fields

    if self.init is not None:  # MaybeType
      x0 = self.init.PrettyTree()
      L.append(field('init', x0))

    if self.cond is not None:  # MaybeType
      x1 = self.cond.PrettyTree()
      L.append(field('cond', x1))

    if self.update is not None:  # MaybeType
      x2 = self.update.PrettyTree()
      L.append(field('update', x2))

    if self.body is not None:  # MaybeType
      x3 = self.body.PrettyTree()
      L.append(field('body', x3))

    if self.redirects:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.redirects:
        x4.children.append(i4.PrettyTree())
      L.append(field('redirects', x4))

    if self.spids:  # ArrayType
      x5 = hnode.Array([])
      for i5 in self.spids:
        x5.children.append(hnode.Leaf(str(i5), color_e.OtherConst))
      L.append(field('spids', x5))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ForExpr')
    L = out_node.fields
    if self.init is not None:  # MaybeType
      x0 = self.init.AbbreviatedTree()
      L.append(field('init', x0))

    if self.cond is not None:  # MaybeType
      x1 = self.cond.AbbreviatedTree()
      L.append(field('cond', x1))

    if self.update is not None:  # MaybeType
      x2 = self.update.AbbreviatedTree()
      L.append(field('update', x2))

    if self.body is not None:  # MaybeType
      x3 = self.body.AbbreviatedTree()
      L.append(field('body', x3))

    if self.redirects:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.redirects:
        x4.children.append(i4.AbbreviatedTree())
      L.append(field('redirects', x4))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__WhileUntil(command_t):
  tag = 16
  __slots__ = ('keyword', 'cond', 'body', 'redirects', 'spids')

  def __init__(self, keyword=None, cond=None, body=None, redirects=None,
               spids=None):
    # type: (Optional[Token], Optional[List[command_t]], Optional[command_t], Optional[List[redir]], Optional[List[int]]) -> None
    self.keyword = keyword
    self.cond = cond if cond is not None else []
    self.body = body
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.WhileUntil')
    L = out_node.fields

    assert self.keyword is not None
    x0 = self.keyword.PrettyTree()
    L.append(field('keyword', x0))

    if self.cond:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.cond:
        x1.children.append(i1.PrettyTree())
      L.append(field('cond', x1))

    assert self.body is not None
    x2 = self.body.PrettyTree()
    L.append(field('body', x2))

    if self.redirects:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.redirects:
        x3.children.append(i3.PrettyTree())
      L.append(field('redirects', x3))

    if self.spids:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.spids:
        x4.children.append(hnode.Leaf(str(i4), color_e.OtherConst))
      L.append(field('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.WhileUntil')
    L = out_node.fields
    assert self.keyword is not None
    x0 = self.keyword.AbbreviatedTree()
    L.append(field('keyword', x0))

    if self.cond:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.cond:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('cond', x1))

    assert self.body is not None
    x2 = self.body.AbbreviatedTree()
    L.append(field('body', x2))

    if self.redirects:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.redirects:
        x3.children.append(i3.AbbreviatedTree())
      L.append(field('redirects', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__If(command_t):
  tag = 17
  __slots__ = ('arms', 'else_action', 'redirects', 'spids')

  def __init__(self, arms=None, else_action=None, redirects=None, spids=None):
    # type: (Optional[List[if_arm]], Optional[List[command_t]], Optional[List[redir]], Optional[List[int]]) -> None
    self.arms = arms if arms is not None else []
    self.else_action = else_action if else_action is not None else []
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.If')
    L = out_node.fields

    if self.arms:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.arms:
        x0.children.append(i0.PrettyTree())
      L.append(field('arms', x0))

    if self.else_action:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.else_action:
        x1.children.append(i1.PrettyTree())
      L.append(field('else_action', x1))

    if self.redirects:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.redirects:
        x2.children.append(i2.PrettyTree())
      L.append(field('redirects', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.If')
    L = out_node.fields
    if self.arms:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.arms:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('arms', x0))

    if self.else_action:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.else_action:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('else_action', x1))

    if self.redirects:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.redirects:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('redirects', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Case(command_t):
  tag = 18
  __slots__ = ('to_match', 'arms', 'redirects', 'spids')

  def __init__(self, to_match=None, arms=None, redirects=None, spids=None):
    # type: (Optional[word_t], Optional[List[case_arm]], Optional[List[redir]], Optional[List[int]]) -> None
    self.to_match = to_match
    self.arms = arms if arms is not None else []
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Case')
    L = out_node.fields

    assert self.to_match is not None
    x0 = self.to_match.PrettyTree()
    L.append(field('to_match', x0))

    if self.arms:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.arms:
        x1.children.append(i1.PrettyTree())
      L.append(field('arms', x1))

    if self.redirects:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.redirects:
        x2.children.append(i2.PrettyTree())
      L.append(field('redirects', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Case')
    L = out_node.fields
    assert self.to_match is not None
    x0 = self.to_match.AbbreviatedTree()
    L.append(field('to_match', x0))

    if self.arms:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.arms:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('arms', x1))

    if self.redirects:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.redirects:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('redirects', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__ShFunction(command_t):
  tag = 19
  __slots__ = ('name', 'body', 'spids')

  def __init__(self, name=None, body=None, spids=None):
    # type: (Optional[str], Optional[command_t], Optional[List[int]]) -> None
    self.name = name
    self.body = body
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ShFunction')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    assert self.body is not None
    x1 = self.body.PrettyTree()
    L.append(field('body', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.ShFunction')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    assert self.body is not None
    x1 = self.body.AbbreviatedTree()
    L.append(field('body', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__TimeBlock(command_t):
  tag = 20
  __slots__ = ('pipeline', 'spids')

  def __init__(self, pipeline=None, spids=None):
    # type: (Optional[command_t], Optional[List[int]]) -> None
    self.pipeline = pipeline
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.TimeBlock')
    L = out_node.fields

    assert self.pipeline is not None
    x0 = self.pipeline.PrettyTree()
    L.append(field('pipeline', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.TimeBlock')
    L = out_node.fields
    assert self.pipeline is not None
    x0 = self.pipeline.AbbreviatedTree()
    L.append(field('pipeline', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__CommandList(command_t):
  tag = 21
  __slots__ = ('children', 'spids')

  def __init__(self, children=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[int]]) -> None
    self.children = children if children is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.CommandList')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(field('children', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.CommandList')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('children', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__BareDecl(command_t):
  tag = 22
  __slots__ = ('lhs', 'rhs', 'spids')

  def __init__(self, lhs=None, rhs=None, spids=None):
    # type: (Optional[Token], Optional[expr_t], Optional[List[int]]) -> None
    self.lhs = lhs
    self.rhs = rhs
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.BareDecl')
    L = out_node.fields

    assert self.lhs is not None
    x0 = self.lhs.PrettyTree()
    L.append(field('lhs', x0))

    assert self.rhs is not None
    x1 = self.rhs.PrettyTree()
    L.append(field('rhs', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.BareDecl')
    L = out_node.fields
    assert self.lhs is not None
    x0 = self.lhs.AbbreviatedTree()
    L.append(field('lhs', x0))

    assert self.rhs is not None
    x1 = self.rhs.AbbreviatedTree()
    L.append(field('rhs', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__VarDecl(command_t):
  tag = 23
  __slots__ = ('keyword', 'lhs', 'rhs', 'spids')

  def __init__(self, keyword=None, lhs=None, rhs=None, spids=None):
    # type: (Optional[Token], Optional[List[name_type]], Optional[expr_t], Optional[List[int]]) -> None
    self.keyword = keyword if keyword is not None else None
    self.lhs = lhs if lhs is not None else []
    self.rhs = rhs
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.VarDecl')
    L = out_node.fields

    if self.keyword is not None:  # MaybeType
      x0 = self.keyword.PrettyTree()
      L.append(field('keyword', x0))

    if self.lhs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.lhs:
        x1.children.append(i1.PrettyTree())
      L.append(field('lhs', x1))

    assert self.rhs is not None
    x2 = self.rhs.PrettyTree()
    L.append(field('rhs', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.VarDecl')
    L = out_node.fields
    if self.keyword is not None:  # MaybeType
      x0 = self.keyword.AbbreviatedTree()
      L.append(field('keyword', x0))

    if self.lhs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.lhs:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('lhs', x1))

    assert self.rhs is not None
    x2 = self.rhs.AbbreviatedTree()
    L.append(field('rhs', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__PlaceMutation(command_t):
  tag = 24
  __slots__ = ('keyword', 'lhs', 'op', 'rhs', 'spids')

  def __init__(self, keyword=None, lhs=None, op=None, rhs=None, spids=None):
    # type: (Optional[Token], Optional[List[place_expr_t]], Optional[Token], Optional[expr_t], Optional[List[int]]) -> None
    self.keyword = keyword if keyword is not None else None
    self.lhs = lhs if lhs is not None else []
    self.op = op
    self.rhs = rhs
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.PlaceMutation')
    L = out_node.fields

    if self.keyword is not None:  # MaybeType
      x0 = self.keyword.PrettyTree()
      L.append(field('keyword', x0))

    if self.lhs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.lhs:
        x1.children.append(i1.PrettyTree())
      L.append(field('lhs', x1))

    assert self.op is not None
    x2 = self.op.PrettyTree()
    L.append(field('op', x2))

    assert self.rhs is not None
    x3 = self.rhs.PrettyTree()
    L.append(field('rhs', x3))

    if self.spids:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.spids:
        x4.children.append(hnode.Leaf(str(i4), color_e.OtherConst))
      L.append(field('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.PlaceMutation')
    L = out_node.fields
    if self.keyword is not None:  # MaybeType
      x0 = self.keyword.AbbreviatedTree()
      L.append(field('keyword', x0))

    if self.lhs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.lhs:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('lhs', x1))

    assert self.op is not None
    x2 = self.op.AbbreviatedTree()
    L.append(field('op', x2))

    assert self.rhs is not None
    x3 = self.rhs.AbbreviatedTree()
    L.append(field('rhs', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Expr(command_t):
  tag = 25
  __slots__ = ('keyword', 'e', 'spids')

  def __init__(self, keyword=None, e=None, spids=None):
    # type: (Optional[speck], Optional[expr_t], Optional[List[int]]) -> None
    self.keyword = keyword
    self.e = e
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Expr')
    L = out_node.fields

    assert self.keyword is not None
    x0 = self.keyword.PrettyTree()
    L.append(field('keyword', x0))

    assert self.e is not None
    x1 = self.e.PrettyTree()
    L.append(field('e', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Expr')
    L = out_node.fields
    assert self.keyword is not None
    x0 = self.keyword.AbbreviatedTree()
    L.append(field('keyword', x0))

    assert self.e is not None
    x1 = self.e.AbbreviatedTree()
    L.append(field('e', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Return(command_t):
  tag = 26
  __slots__ = ('keyword', 'e', 'spids')

  def __init__(self, keyword=None, e=None, spids=None):
    # type: (Optional[Token], Optional[expr_t], Optional[List[int]]) -> None
    self.keyword = keyword
    self.e = e
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Return')
    L = out_node.fields

    assert self.keyword is not None
    x0 = self.keyword.PrettyTree()
    L.append(field('keyword', x0))

    assert self.e is not None
    x1 = self.e.PrettyTree()
    L.append(field('e', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Return')
    L = out_node.fields
    assert self.keyword is not None
    x0 = self.keyword.AbbreviatedTree()
    L.append(field('keyword', x0))

    assert self.e is not None
    x1 = self.e.AbbreviatedTree()
    L.append(field('e', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__OilCondition(command_t):
  tag = 27
  __slots__ = ('e', 'spids')

  def __init__(self, e=None, spids=None):
    # type: (Optional[expr_t], Optional[List[int]]) -> None
    self.e = e
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.OilCondition')
    L = out_node.fields

    assert self.e is not None
    x0 = self.e.PrettyTree()
    L.append(field('e', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.OilCondition')
    L = out_node.fields
    assert self.e is not None
    x0 = self.e.AbbreviatedTree()
    L.append(field('e', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__OilForIn(command_t):
  tag = 28
  __slots__ = ('lhs', 'iterable', 'body', 'spids')

  def __init__(self, lhs=None, iterable=None, body=None, spids=None):
    # type: (Optional[List[name_type]], Optional[expr_t], Optional[command_t], Optional[List[int]]) -> None
    self.lhs = lhs if lhs is not None else []
    self.iterable = iterable
    self.body = body
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.OilForIn')
    L = out_node.fields

    if self.lhs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.lhs:
        x0.children.append(i0.PrettyTree())
      L.append(field('lhs', x0))

    assert self.iterable is not None
    x1 = self.iterable.PrettyTree()
    L.append(field('iterable', x1))

    assert self.body is not None
    x2 = self.body.PrettyTree()
    L.append(field('body', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.OilForIn')
    L = out_node.fields
    if self.lhs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.lhs:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('lhs', x0))

    assert self.iterable is not None
    x1 = self.iterable.AbbreviatedTree()
    L.append(field('iterable', x1))

    assert self.body is not None
    x2 = self.body.AbbreviatedTree()
    L.append(field('body', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Proc(command_t):
  tag = 29
  __slots__ = ('name', 'sig', 'body', 'spids')

  def __init__(self, name=None, sig=None, body=None, spids=None):
    # type: (Optional[Token], Optional[proc_sig_t], Optional[command_t], Optional[List[int]]) -> None
    self.name = name
    self.sig = sig
    self.body = body
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Proc')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    assert self.sig is not None
    x1 = self.sig.PrettyTree()
    L.append(field('sig', x1))

    assert self.body is not None
    x2 = self.body.PrettyTree()
    L.append(field('body', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Proc')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    assert self.sig is not None
    x1 = self.sig.AbbreviatedTree()
    L.append(field('sig', x1))

    assert self.body is not None
    x2 = self.body.AbbreviatedTree()
    L.append(field('body', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Func(command_t):
  tag = 30
  __slots__ = ('name', 'pos_params', 'pos_splat', 'named_params',
               'named_splat', 'return_types', 'body', 'spids')

  def __init__(self, name=None, pos_params=None, pos_splat=None,
               named_params=None, named_splat=None, return_types=None,
               body=None, spids=None):
    # type: (Optional[Token], Optional[List[param]], Optional[Token], Optional[List[param]], Optional[Token], Optional[List[type_expr_t]], Optional[command_t], Optional[List[int]]) -> None
    self.name = name
    self.pos_params = pos_params if pos_params is not None else []
    self.pos_splat = pos_splat if pos_splat is not None else None
    self.named_params = named_params if named_params is not None else []
    self.named_splat = named_splat if named_splat is not None else None
    self.return_types = return_types if return_types is not None else []
    self.body = body
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Func')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.pos_params:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.pos_params:
        x1.children.append(i1.PrettyTree())
      L.append(field('pos_params', x1))

    if self.pos_splat is not None:  # MaybeType
      x2 = self.pos_splat.PrettyTree()
      L.append(field('pos_splat', x2))

    if self.named_params:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.named_params:
        x3.children.append(i3.PrettyTree())
      L.append(field('named_params', x3))

    if self.named_splat is not None:  # MaybeType
      x4 = self.named_splat.PrettyTree()
      L.append(field('named_splat', x4))

    if self.return_types:  # ArrayType
      x5 = hnode.Array([])
      for i5 in self.return_types:
        x5.children.append(i5.PrettyTree())
      L.append(field('return_types', x5))

    assert self.body is not None
    x6 = self.body.PrettyTree()
    L.append(field('body', x6))

    if self.spids:  # ArrayType
      x7 = hnode.Array([])
      for i7 in self.spids:
        x7.children.append(hnode.Leaf(str(i7), color_e.OtherConst))
      L.append(field('spids', x7))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Func')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.pos_params:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.pos_params:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('pos_params', x1))

    if self.pos_splat is not None:  # MaybeType
      x2 = self.pos_splat.AbbreviatedTree()
      L.append(field('pos_splat', x2))

    if self.named_params:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.named_params:
        x3.children.append(i3.AbbreviatedTree())
      L.append(field('named_params', x3))

    if self.named_splat is not None:  # MaybeType
      x4 = self.named_splat.AbbreviatedTree()
      L.append(field('named_splat', x4))

    if self.return_types:  # ArrayType
      x5 = hnode.Array([])
      for i5 in self.return_types:
        x5.children.append(i5.AbbreviatedTree())
      L.append(field('return_types', x5))

    assert self.body is not None
    x6 = self.body.AbbreviatedTree()
    L.append(field('body', x6))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Data(command_t):
  tag = 31
  __slots__ = ('name', 'params', 'spids')

  def __init__(self, name=None, params=None, spids=None):
    # type: (Optional[Token], Optional[List[param]], Optional[List[int]]) -> None
    self.name = name
    self.params = params if params is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Data')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.params:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.params:
        x1.children.append(i1.PrettyTree())
      L.append(field('params', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Data')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.params:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.params:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('params', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Enum(command_t):
  tag = 32
  __slots__ = ('name', 'variants', 'spids')

  def __init__(self, name=None, variants=None, spids=None):
    # type: (Optional[Token], Optional[List[variant]], Optional[List[int]]) -> None
    self.name = name
    self.variants = variants if variants is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Enum')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.variants:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.variants:
        x1.children.append(i1.PrettyTree())
      L.append(field('variants', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Enum')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.variants:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.variants:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('variants', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Class(command_t):
  tag = 33
  __slots__ = ('name', 'extends', 'items', 'spids')

  def __init__(self, name=None, extends=None, items=None, spids=None):
    # type: (Optional[Token], Optional[Token], Optional[List[class_item_t]], Optional[List[int]]) -> None
    self.name = name
    self.extends = extends if extends is not None else None
    self.items = items if items is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Class')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.extends is not None:  # MaybeType
      x1 = self.extends.PrettyTree()
      L.append(field('extends', x1))

    if self.items:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.items:
        x2.children.append(i2.PrettyTree())
      L.append(field('items', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Class')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.extends is not None:  # MaybeType
      x1 = self.extends.AbbreviatedTree()
      L.append(field('extends', x1))

    if self.items:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.items:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('items', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command__Use(command_t):
  tag = 34
  __slots__ = ('path', 'alias', 'names', 'spids')

  def __init__(self, path=None, alias=None, names=None, spids=None):
    # type: (Optional[single_quoted], Optional[Token], Optional[List[use_name]], Optional[List[int]]) -> None
    self.path = path
    self.alias = alias if alias is not None else None
    self.names = names if names is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Use')
    L = out_node.fields

    assert self.path is not None
    x0 = self.path.PrettyTree()
    L.append(field('path', x0))

    if self.alias is not None:  # MaybeType
      x1 = self.alias.PrettyTree()
      L.append(field('alias', x1))

    if self.names:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.names:
        x2.children.append(i2.PrettyTree())
      L.append(field('names', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command.Use')
    L = out_node.fields
    assert self.path is not None
    x0 = self.path.AbbreviatedTree()
    L.append(field('path', x0))

    if self.alias is not None:  # MaybeType
      x1 = self.alias.AbbreviatedTree()
      L.append(field('alias', x1))

    if self.names:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.names:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('names', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class command(object):
  NoOp = command__NoOp
  Simple = command__Simple
  ExpandedAlias = command__ExpandedAlias
  Sentence = command__Sentence
  ShAssignment = command__ShAssignment
  ControlFlow = command__ControlFlow
  Pipeline = command__Pipeline
  AndOr = command__AndOr
  DoGroup = command__DoGroup
  Subshell = command__Subshell
  DParen = command__DParen
  DBracket = command__DBracket
  ForEach = command__ForEach
  ForExpr = command__ForExpr
  WhileUntil = command__WhileUntil
  If = command__If
  Case = command__Case
  ShFunction = command__ShFunction
  TimeBlock = command__TimeBlock
  CommandList = command__CommandList
  BareDecl = command__BareDecl
  VarDecl = command__VarDecl
  PlaceMutation = command__PlaceMutation
  Expr = command__Expr
  Return = command__Return
  OilCondition = command__OilCondition
  OilForIn = command__OilForIn
  Proc = command__Proc
  Func = command__Func
  Data = command__Data
  Enum = command__Enum
  Class = command__Class
  Use = command__Use

class variant_type_e(object):
  Anon = 1
  Ref = 2

_variant_type_str = {
  1: 'variant_type.Anon',
  2: 'variant_type.Ref',
}

def variant_type_str(tag):
  # type: (int) -> str
  return _variant_type_str[tag]

class variant_type_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class variant_type__Anon(variant_type_t):
  tag = 1
  __slots__ = ('params',)

  def __init__(self, params=None):
    # type: (Optional[List[param]]) -> None
    self.params = params if params is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('variant_type.Anon')
    L = out_node.fields

    if self.params:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.params:
        x0.children.append(i0.PrettyTree())
      L.append(field('params', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('variant_type.Anon')
    L = out_node.fields
    if self.params:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.params:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('params', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class variant_type__Ref(variant_type_t):
  tag = 2
  __slots__ = ('type_name',)

  def __init__(self, type_name=None):
    # type: (Optional[Token]) -> None
    self.type_name = type_name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('variant_type.Ref')
    L = out_node.fields

    assert self.type_name is not None
    x0 = self.type_name.PrettyTree()
    L.append(field('type_name', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('variant_type.Ref')
    L = out_node.fields
    assert self.type_name is not None
    x0 = self.type_name.AbbreviatedTree()
    L.append(field('type_name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class variant_type(object):
  Anon = variant_type__Anon
  Ref = variant_type__Ref

class class_item_e(object):
  Data = 1
  Method = 2

_class_item_str = {
  1: 'class_item.Data',
  2: 'class_item.Method',
}

def class_item_str(tag):
  # type: (int) -> str
  return _class_item_str[tag]

class class_item_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class class_item__Data(class_item_t):
  tag = 1
  __slots__ = ('keyword', 'fields')

  def __init__(self, keyword=None, fields=None):
    # type: (Optional[Token], Optional[List[name_type]]) -> None
    self.keyword = keyword
    self.fields = fields if fields is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_item.Data')
    L = out_node.fields

    assert self.keyword is not None
    x0 = self.keyword.PrettyTree()
    L.append(field('keyword', x0))

    if self.fields:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.fields:
        x1.children.append(i1.PrettyTree())
      L.append(field('fields', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_item.Data')
    L = out_node.fields
    assert self.keyword is not None
    x0 = self.keyword.AbbreviatedTree()
    L.append(field('keyword', x0))

    if self.fields:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.fields:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('fields', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class class_item__Method(class_item_t):
  tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_item.Method')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_item.Method')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class class_item(object):
  Data = class_item__Data
  Method = class_item__Method

class proc_sig_e(object):
  Open = 1
  Closed = 2

_proc_sig_str = {
  1: 'proc_sig.Open',
  2: 'proc_sig.Closed',
}

def proc_sig_str(tag):
  # type: (int) -> str
  return _proc_sig_str[tag]

class proc_sig_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class proc_sig__Open(proc_sig_t):
  tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('proc_sig.Open')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('proc_sig.Open')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class proc_sig__Closed(proc_sig_t):
  tag = 2
  __slots__ = ('params', 'rest', 'block')

  def __init__(self, params=None, rest=None, block=None):
    # type: (Optional[List[param]], Optional[Token], Optional[Token]) -> None
    self.params = params if params is not None else []
    self.rest = rest if rest is not None else None
    self.block = block if block is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('proc_sig.Closed')
    L = out_node.fields

    if self.params:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.params:
        x0.children.append(i0.PrettyTree())
      L.append(field('params', x0))

    if self.rest is not None:  # MaybeType
      x1 = self.rest.PrettyTree()
      L.append(field('rest', x1))

    if self.block is not None:  # MaybeType
      x2 = self.block.PrettyTree()
      L.append(field('block', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('proc_sig.Closed')
    L = out_node.fields
    if self.params:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.params:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('params', x0))

    if self.rest is not None:  # MaybeType
      x1 = self.rest.AbbreviatedTree()
      L.append(field('rest', x1))

    if self.block is not None:  # MaybeType
      x2 = self.block.AbbreviatedTree()
      L.append(field('block', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class proc_sig(object):
  Open = proc_sig__Open
  Closed = proc_sig__Closed

class glob_part_e(object):
  Literal = 1
  Operator = 2
  CharClass = 3

_glob_part_str = {
  1: 'glob_part.Literal',
  2: 'glob_part.Operator',
  3: 'glob_part.CharClass',
}

def glob_part_str(tag):
  # type: (int) -> str
  return _glob_part_str[tag]

class glob_part_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class glob_part__Literal(glob_part_t):
  tag = 1
  __slots__ = ('id', 's')

  def __init__(self, id=None, s=None):
    # type: (Optional[Id_t], Optional[str]) -> None
    self.id = id
    self.s = s

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('glob_part.Literal')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('glob_part.Literal')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class glob_part__Operator(glob_part_t):
  tag = 2
  __slots__ = ('op_id',)

  def __init__(self, op_id=None):
    # type: (Optional[Id_t]) -> None
    self.op_id = op_id

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('glob_part.Operator')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('glob_part.Operator')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(field('op_id', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class glob_part__CharClass(glob_part_t):
  tag = 3
  __slots__ = ('negated', 'strs')

  def __init__(self, negated=None, strs=None):
    # type: (Optional[bool], Optional[List[str]]) -> None
    self.negated = negated
    self.strs = strs if strs is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('glob_part.CharClass')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x0))

    if self.strs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.strs:
        x1.children.append(NewLeaf(i1, color_e.StringConst))
      L.append(field('strs', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('glob_part.CharClass')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x0))

    if self.strs:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.strs:
        x1.children.append(NewLeaf(i1, color_e.StringConst))
      L.append(field('strs', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class glob_part(object):
  Literal = glob_part__Literal
  Operator = glob_part__Operator
  CharClass = glob_part__CharClass

class printf_part_e(object):
  Literal = 1
  Percent = 2

_printf_part_str = {
  1: 'printf_part.Literal',
  2: 'printf_part.Percent',
}

def printf_part_str(tag):
  # type: (int) -> str
  return _printf_part_str[tag]

class printf_part_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class printf_part__Literal(printf_part_t):
  tag = 1
  __slots__ = ('token',)

  def __init__(self, token=None):
    # type: (Optional[Token]) -> None
    self.token = token

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('printf_part.Literal')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(field('token', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('printf_part.Literal')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(field('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class printf_part__Percent(printf_part_t):
  tag = 2
  __slots__ = ('flags', 'width', 'precision', 'type')

  def __init__(self, flags=None, width=None, precision=None, type=None):
    # type: (Optional[List[Token]], Optional[Token], Optional[Token], Optional[Token]) -> None
    self.flags = flags if flags is not None else []
    self.width = width if width is not None else None
    self.precision = precision if precision is not None else None
    self.type = type

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('printf_part.Percent')
    L = out_node.fields

    if self.flags:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.flags:
        x0.children.append(i0.PrettyTree())
      L.append(field('flags', x0))

    if self.width is not None:  # MaybeType
      x1 = self.width.PrettyTree()
      L.append(field('width', x1))

    if self.precision is not None:  # MaybeType
      x2 = self.precision.PrettyTree()
      L.append(field('precision', x2))

    assert self.type is not None
    x3 = self.type.PrettyTree()
    L.append(field('type', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('printf_part.Percent')
    L = out_node.fields
    if self.flags:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.flags:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('flags', x0))

    if self.width is not None:  # MaybeType
      x1 = self.width.AbbreviatedTree()
      L.append(field('width', x1))

    if self.precision is not None:  # MaybeType
      x2 = self.precision.AbbreviatedTree()
      L.append(field('precision', x2))

    assert self.type is not None
    x3 = self.type.AbbreviatedTree()
    L.append(field('type', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class printf_part(object):
  Literal = printf_part__Literal
  Percent = printf_part__Percent

class expr_context_t(pybase.SimpleObj):
  pass

class expr_context_e(object):
  Load = expr_context_t(1)
  Store = expr_context_t(2)
  Del = expr_context_t(3)
  AugLoad = expr_context_t(4)
  AugStore = expr_context_t(5)
  Param = expr_context_t(6)

_expr_context_str = {
  1: 'expr_context.Load',
  2: 'expr_context.Store',
  3: 'expr_context.Del',
  4: 'expr_context.AugLoad',
  5: 'expr_context.AugStore',
  6: 'expr_context.Param',
}

def expr_context_str(val):
  # type: (expr_context_t) -> str
  return _expr_context_str[val]

class type_expr_e(object):
  Simple = 1
  Compound = 2

_type_expr_str = {
  1: 'type_expr.Simple',
  2: 'type_expr.Compound',
}

def type_expr_str(tag):
  # type: (int) -> str
  return _type_expr_str[tag]

class type_expr_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class type_expr__Simple(type_expr_t):
  tag = 1
  __slots__ = ('name',)

  def __init__(self, name=None):
    # type: (Optional[Token]) -> None
    self.name = name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('type_expr.Simple')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('type_expr.Simple')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class type_expr__Compound(type_expr_t):
  tag = 2
  __slots__ = ('name', 'params')

  def __init__(self, name=None, params=None):
    # type: (Optional[Token], Optional[List[type_expr_t]]) -> None
    self.name = name
    self.params = params if params is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('type_expr.Compound')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.params:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.params:
        x1.children.append(i1.PrettyTree())
      L.append(field('params', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('type_expr.Compound')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.params:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.params:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('params', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class type_expr(object):
  Simple = type_expr__Simple
  Compound = type_expr__Compound

class place_expr_e(object):
  Var = 1
  Subscript = 1023
  Attribute = 1024

_place_expr_str = {
  1: 'place_expr.Var',
  1023: 'place_expr.Subscript',
  1024: 'place_expr.Attribute',
}

def place_expr_str(tag):
  # type: (int) -> str
  return _place_expr_str[tag]

class place_expr_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class place_expr__Var(place_expr_t):
  tag = 1
  __slots__ = ('name',)

  def __init__(self, name=None):
    # type: (Optional[Token]) -> None
    self.name = name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('place_expr.Var')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('place_expr.Var')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class place_expr(object):
  Var = place_expr__Var

class expr_e(object):
  Var = 1
  Const = 2
  ShArrayLiteral = 1008
  ArrayLiteral = 4
  RegexLiteral = 5
  SimpleVarSub = 1005
  BracedVarSub = 1006
  CommandSub = 1007
  SingleQuoted = 1004
  DoubleQuoted = 1003
  Lambda = 11
  Unary = 12
  Binary = 13
  Compare = 14
  FuncCall = 15
  IfExp = 16
  Tuple = 17
  List = 18
  Dict = 19
  Implicit = 20
  ListComp = 21
  DictComp = 22
  GeneratorExp = 23
  Range = 24
  Slice = 25
  Subscript = 1023
  Attribute = 1024
  Spread = 28

_expr_str = {
  1: 'expr.Var',
  2: 'expr.Const',
  4: 'expr.ArrayLiteral',
  5: 'expr.RegexLiteral',
  11: 'expr.Lambda',
  12: 'expr.Unary',
  13: 'expr.Binary',
  14: 'expr.Compare',
  15: 'expr.FuncCall',
  16: 'expr.IfExp',
  17: 'expr.Tuple',
  18: 'expr.List',
  19: 'expr.Dict',
  20: 'expr.Implicit',
  21: 'expr.ListComp',
  22: 'expr.DictComp',
  23: 'expr.GeneratorExp',
  24: 'expr.Range',
  25: 'expr.Slice',
  28: 'expr.Spread',
  1003: 'expr.DoubleQuoted',
  1004: 'expr.SingleQuoted',
  1005: 'expr.SimpleVarSub',
  1006: 'expr.BracedVarSub',
  1007: 'expr.CommandSub',
  1008: 'expr.ShArrayLiteral',
  1023: 'expr.Subscript',
  1024: 'expr.Attribute',
}

def expr_str(tag):
  # type: (int) -> str
  return _expr_str[tag]

class expr_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class expr__Var(expr_t):
  tag = 1
  __slots__ = ('name', 'spids')

  def __init__(self, name=None, spids=None):
    # type: (Optional[Token], Optional[List[int]]) -> None
    self.name = name
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Var')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Var')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _expr__Var(self)
    return p if p else self._AbbreviatedTree()

class expr__Const(expr_t):
  tag = 2
  __slots__ = ('c', 'spids')

  def __init__(self, c=None, spids=None):
    # type: (Optional[Token], Optional[List[int]]) -> None
    self.c = c
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Const')
    L = out_node.fields

    assert self.c is not None
    x0 = self.c.PrettyTree()
    L.append(field('c', x0))

    if self.spids:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.spids:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(field('spids', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Const')
    L = out_node.fields
    assert self.c is not None
    x0 = self.c.AbbreviatedTree()
    L.append(field('c', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _expr__Const(self)
    return p if p else self._AbbreviatedTree()

class expr__ArrayLiteral(expr_t):
  tag = 4
  __slots__ = ('left', 'items', 'spids')

  def __init__(self, left=None, items=None, spids=None):
    # type: (Optional[Token], Optional[List[expr_t]], Optional[List[int]]) -> None
    self.left = left
    self.items = items if items is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.ArrayLiteral')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    if self.items:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.items:
        x1.children.append(i1.PrettyTree())
      L.append(field('items', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.ArrayLiteral')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    if self.items:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.items:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('items', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__RegexLiteral(expr_t):
  tag = 5
  __slots__ = ('left', 'regex', 'flags', 'trans_pref', 'spids')

  def __init__(self, left=None, regex=None, flags=None, trans_pref=None,
               spids=None):
    # type: (Optional[Token], Optional[re_t], Optional[List[Token]], Optional[Token], Optional[List[int]]) -> None
    self.left = left
    self.regex = regex
    self.flags = flags if flags is not None else []
    self.trans_pref = trans_pref if trans_pref is not None else None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.RegexLiteral')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    assert self.regex is not None
    x1 = self.regex.PrettyTree()
    L.append(field('regex', x1))

    if self.flags:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.flags:
        x2.children.append(i2.PrettyTree())
      L.append(field('flags', x2))

    if self.trans_pref is not None:  # MaybeType
      x3 = self.trans_pref.PrettyTree()
      L.append(field('trans_pref', x3))

    if self.spids:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.spids:
        x4.children.append(hnode.Leaf(str(i4), color_e.OtherConst))
      L.append(field('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.RegexLiteral')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    assert self.regex is not None
    x1 = self.regex.AbbreviatedTree()
    L.append(field('regex', x1))

    if self.flags:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.flags:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('flags', x2))

    if self.trans_pref is not None:  # MaybeType
      x3 = self.trans_pref.AbbreviatedTree()
      L.append(field('trans_pref', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Lambda(expr_t):
  tag = 11
  __slots__ = ('params', 'body', 'spids')

  def __init__(self, params=None, body=None, spids=None):
    # type: (Optional[List[name_type]], Optional[expr_t], Optional[List[int]]) -> None
    self.params = params if params is not None else []
    self.body = body
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Lambda')
    L = out_node.fields

    if self.params:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.params:
        x0.children.append(i0.PrettyTree())
      L.append(field('params', x0))

    assert self.body is not None
    x1 = self.body.PrettyTree()
    L.append(field('body', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Lambda')
    L = out_node.fields
    if self.params:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.params:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('params', x0))

    assert self.body is not None
    x1 = self.body.AbbreviatedTree()
    L.append(field('body', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Unary(expr_t):
  tag = 12
  __slots__ = ('op', 'child', 'spids')

  def __init__(self, op=None, child=None, spids=None):
    # type: (Optional[Token], Optional[expr_t], Optional[List[int]]) -> None
    self.op = op
    self.child = child
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Unary')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(field('op', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(field('child', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Unary')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(field('op', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(field('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Binary(expr_t):
  tag = 13
  __slots__ = ('op', 'left', 'right', 'spids')

  def __init__(self, op=None, left=None, right=None, spids=None):
    # type: (Optional[Token], Optional[expr_t], Optional[expr_t], Optional[List[int]]) -> None
    self.op = op
    self.left = left
    self.right = right
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Binary')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(field('op', x0))

    assert self.left is not None
    x1 = self.left.PrettyTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.PrettyTree()
    L.append(field('right', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Binary')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(field('op', x0))

    assert self.left is not None
    x1 = self.left.AbbreviatedTree()
    L.append(field('left', x1))

    assert self.right is not None
    x2 = self.right.AbbreviatedTree()
    L.append(field('right', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Compare(expr_t):
  tag = 14
  __slots__ = ('left', 'ops', 'comparators', 'spids')

  def __init__(self, left=None, ops=None, comparators=None, spids=None):
    # type: (Optional[expr_t], Optional[List[speck]], Optional[List[expr_t]], Optional[List[int]]) -> None
    self.left = left
    self.ops = ops if ops is not None else []
    self.comparators = comparators if comparators is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Compare')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    if self.ops:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.ops:
        x1.children.append(i1.PrettyTree())
      L.append(field('ops', x1))

    if self.comparators:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.comparators:
        x2.children.append(i2.PrettyTree())
      L.append(field('comparators', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Compare')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    if self.ops:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.ops:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('ops', x1))

    if self.comparators:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.comparators:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('comparators', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__FuncCall(expr_t):
  tag = 15
  __slots__ = ('func', 'args', 'spids')

  def __init__(self, func=None, args=None, spids=None):
    # type: (Optional[expr_t], Optional[arg_list], Optional[List[int]]) -> None
    self.func = func
    self.args = args
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.FuncCall')
    L = out_node.fields

    assert self.func is not None
    x0 = self.func.PrettyTree()
    L.append(field('func', x0))

    assert self.args is not None
    x1 = self.args.PrettyTree()
    L.append(field('args', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.FuncCall')
    L = out_node.fields
    assert self.func is not None
    x0 = self.func.AbbreviatedTree()
    L.append(field('func', x0))

    assert self.args is not None
    x1 = self.args.AbbreviatedTree()
    L.append(field('args', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__IfExp(expr_t):
  tag = 16
  __slots__ = ('test', 'body', 'orelse', 'spids')

  def __init__(self, test=None, body=None, orelse=None, spids=None):
    # type: (Optional[expr_t], Optional[expr_t], Optional[expr_t], Optional[List[int]]) -> None
    self.test = test
    self.body = body
    self.orelse = orelse
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.IfExp')
    L = out_node.fields

    assert self.test is not None
    x0 = self.test.PrettyTree()
    L.append(field('test', x0))

    assert self.body is not None
    x1 = self.body.PrettyTree()
    L.append(field('body', x1))

    assert self.orelse is not None
    x2 = self.orelse.PrettyTree()
    L.append(field('orelse', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.IfExp')
    L = out_node.fields
    assert self.test is not None
    x0 = self.test.AbbreviatedTree()
    L.append(field('test', x0))

    assert self.body is not None
    x1 = self.body.AbbreviatedTree()
    L.append(field('body', x1))

    assert self.orelse is not None
    x2 = self.orelse.AbbreviatedTree()
    L.append(field('orelse', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Tuple(expr_t):
  tag = 17
  __slots__ = ('elts', 'ctx', 'spids')

  def __init__(self, elts=None, ctx=None, spids=None):
    # type: (Optional[List[expr_t]], Optional[expr_context_t], Optional[List[int]]) -> None
    self.elts = elts if elts is not None else []
    self.ctx = ctx if ctx is not None else expr_context_e.Load
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Tuple')
    L = out_node.fields

    if self.elts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.elts:
        x0.children.append(i0.PrettyTree())
      L.append(field('elts', x0))

    x1 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Tuple')
    L = out_node.fields
    if self.elts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.elts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('elts', x0))

    x1 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__List(expr_t):
  tag = 18
  __slots__ = ('elts', 'ctx', 'spids')

  def __init__(self, elts=None, ctx=None, spids=None):
    # type: (Optional[List[expr_t]], Optional[expr_context_t], Optional[List[int]]) -> None
    self.elts = elts if elts is not None else []
    self.ctx = ctx if ctx is not None else expr_context_e.Load
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.List')
    L = out_node.fields

    if self.elts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.elts:
        x0.children.append(i0.PrettyTree())
      L.append(field('elts', x0))

    x1 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.List')
    L = out_node.fields
    if self.elts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.elts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('elts', x0))

    x1 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Dict(expr_t):
  tag = 19
  __slots__ = ('keys', 'values', 'spids')

  def __init__(self, keys=None, values=None, spids=None):
    # type: (Optional[List[expr_t]], Optional[List[expr_t]], Optional[List[int]]) -> None
    self.keys = keys if keys is not None else []
    self.values = values if values is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Dict')
    L = out_node.fields

    if self.keys:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.keys:
        x0.children.append(i0.PrettyTree())
      L.append(field('keys', x0))

    if self.values:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.values:
        x1.children.append(i1.PrettyTree())
      L.append(field('values', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Dict')
    L = out_node.fields
    if self.keys:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.keys:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('keys', x0))

    if self.values:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.values:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('values', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Implicit(expr_t):
  tag = 20
  __slots__ = ('spids',)

  def __init__(self, spids=None):
    # type: (Optional[List[int]]) -> None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Implicit')
    L = out_node.fields

    if self.spids:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.spids:
        x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
      L.append(field('spids', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Implicit')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__ListComp(expr_t):
  tag = 21
  __slots__ = ('elt', 'generators', 'spids')

  def __init__(self, elt=None, generators=None, spids=None):
    # type: (Optional[expr_t], Optional[List[comprehension]], Optional[List[int]]) -> None
    self.elt = elt
    self.generators = generators if generators is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.ListComp')
    L = out_node.fields

    assert self.elt is not None
    x0 = self.elt.PrettyTree()
    L.append(field('elt', x0))

    if self.generators:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.generators:
        x1.children.append(i1.PrettyTree())
      L.append(field('generators', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.ListComp')
    L = out_node.fields
    assert self.elt is not None
    x0 = self.elt.AbbreviatedTree()
    L.append(field('elt', x0))

    if self.generators:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.generators:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('generators', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__DictComp(expr_t):
  tag = 22
  __slots__ = ('key', 'value', 'generators', 'spids')

  def __init__(self, key=None, value=None, generators=None, spids=None):
    # type: (Optional[expr_t], Optional[expr_t], Optional[List[comprehension]], Optional[List[int]]) -> None
    self.key = key
    self.value = value
    self.generators = generators if generators is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.DictComp')
    L = out_node.fields

    assert self.key is not None
    x0 = self.key.PrettyTree()
    L.append(field('key', x0))

    assert self.value is not None
    x1 = self.value.PrettyTree()
    L.append(field('value', x1))

    if self.generators:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.generators:
        x2.children.append(i2.PrettyTree())
      L.append(field('generators', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.DictComp')
    L = out_node.fields
    assert self.key is not None
    x0 = self.key.AbbreviatedTree()
    L.append(field('key', x0))

    assert self.value is not None
    x1 = self.value.AbbreviatedTree()
    L.append(field('value', x1))

    if self.generators:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.generators:
        x2.children.append(i2.AbbreviatedTree())
      L.append(field('generators', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__GeneratorExp(expr_t):
  tag = 23
  __slots__ = ('elt', 'generators', 'spids')

  def __init__(self, elt=None, generators=None, spids=None):
    # type: (Optional[expr_t], Optional[List[comprehension]], Optional[List[int]]) -> None
    self.elt = elt
    self.generators = generators if generators is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.GeneratorExp')
    L = out_node.fields

    assert self.elt is not None
    x0 = self.elt.PrettyTree()
    L.append(field('elt', x0))

    if self.generators:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.generators:
        x1.children.append(i1.PrettyTree())
      L.append(field('generators', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.GeneratorExp')
    L = out_node.fields
    assert self.elt is not None
    x0 = self.elt.AbbreviatedTree()
    L.append(field('elt', x0))

    if self.generators:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.generators:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('generators', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Range(expr_t):
  tag = 24
  __slots__ = ('lower', 'upper', 'spids')

  def __init__(self, lower=None, upper=None, spids=None):
    # type: (Optional[expr_t], Optional[expr_t], Optional[List[int]]) -> None
    self.lower = lower
    self.upper = upper
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Range')
    L = out_node.fields

    assert self.lower is not None
    x0 = self.lower.PrettyTree()
    L.append(field('lower', x0))

    assert self.upper is not None
    x1 = self.upper.PrettyTree()
    L.append(field('upper', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Range')
    L = out_node.fields
    assert self.lower is not None
    x0 = self.lower.AbbreviatedTree()
    L.append(field('lower', x0))

    assert self.upper is not None
    x1 = self.upper.AbbreviatedTree()
    L.append(field('upper', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Slice(expr_t):
  tag = 25
  __slots__ = ('lower', 'upper', 'spids')

  def __init__(self, lower=None, upper=None, spids=None):
    # type: (Optional[expr_t], Optional[expr_t], Optional[List[int]]) -> None
    self.lower = lower if lower is not None else None
    self.upper = upper if upper is not None else None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Slice')
    L = out_node.fields

    if self.lower is not None:  # MaybeType
      x0 = self.lower.PrettyTree()
      L.append(field('lower', x0))

    if self.upper is not None:  # MaybeType
      x1 = self.upper.PrettyTree()
      L.append(field('upper', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Slice')
    L = out_node.fields
    if self.lower is not None:  # MaybeType
      x0 = self.lower.AbbreviatedTree()
      L.append(field('lower', x0))

    if self.upper is not None:  # MaybeType
      x1 = self.upper.AbbreviatedTree()
      L.append(field('upper', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr__Spread(expr_t):
  tag = 28
  __slots__ = ('child', 'ctx', 'spids')

  def __init__(self, child=None, ctx=None, spids=None):
    # type: (Optional[expr_t], Optional[expr_context_t], Optional[List[int]]) -> None
    self.child = child
    self.ctx = ctx if ctx is not None else expr_context_e.Load
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Spread')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    x1 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('expr.Spread')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    x1 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class expr(object):
  Var = expr__Var
  Const = expr__Const
  ArrayLiteral = expr__ArrayLiteral
  RegexLiteral = expr__RegexLiteral
  Lambda = expr__Lambda
  Unary = expr__Unary
  Binary = expr__Binary
  Compare = expr__Compare
  FuncCall = expr__FuncCall
  IfExp = expr__IfExp
  Tuple = expr__Tuple
  List = expr__List
  Dict = expr__Dict
  Implicit = expr__Implicit
  ListComp = expr__ListComp
  DictComp = expr__DictComp
  GeneratorExp = expr__GeneratorExp
  Range = expr__Range
  Slice = expr__Slice
  Spread = expr__Spread

class class_literal_term_e(object):
  PosixClass = 1025
  PerlClass = 1026
  Range = 3
  CharLiteral = 4
  SimpleVarSub = 1005
  BracedVarSub = 1006
  SingleQuoted = 1004
  DoubleQuoted = 1003
  ByteSet = 9
  CodePoint = 10

_class_literal_term_str = {
  3: 'class_literal_term.Range',
  4: 'class_literal_term.CharLiteral',
  9: 'class_literal_term.ByteSet',
  10: 'class_literal_term.CodePoint',
  1003: 'class_literal_term.DoubleQuoted',
  1004: 'class_literal_term.SingleQuoted',
  1005: 'class_literal_term.SimpleVarSub',
  1006: 'class_literal_term.BracedVarSub',
  1025: 'class_literal_term.PosixClass',
  1026: 'class_literal_term.PerlClass',
}

def class_literal_term_str(tag):
  # type: (int) -> str
  return _class_literal_term_str[tag]

class class_literal_term_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class class_literal_term__Range(class_literal_term_t):
  tag = 3
  __slots__ = ('start', 'end')

  def __init__(self, start=None, end=None):
    # type: (Optional[str], Optional[str]) -> None
    self.start = start
    self.end = end

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.Range')
    L = out_node.fields

    x0 = NewLeaf(self.start, color_e.StringConst)
    L.append(field('start', x0))

    x1 = NewLeaf(self.end, color_e.StringConst)
    L.append(field('end', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.Range')
    L = out_node.fields
    x0 = NewLeaf(self.start, color_e.StringConst)
    L.append(field('start', x0))

    x1 = NewLeaf(self.end, color_e.StringConst)
    L.append(field('end', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class class_literal_term__CharLiteral(class_literal_term_t):
  tag = 4
  __slots__ = ('tok',)

  def __init__(self, tok=None):
    # type: (Optional[Token]) -> None
    self.tok = tok

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.CharLiteral')
    L = out_node.fields

    assert self.tok is not None
    x0 = self.tok.PrettyTree()
    L.append(field('tok', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.CharLiteral')
    L = out_node.fields
    assert self.tok is not None
    x0 = self.tok.AbbreviatedTree()
    L.append(field('tok', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class class_literal_term__ByteSet(class_literal_term_t):
  tag = 9
  __slots__ = ('bytes', 'spid')

  def __init__(self, bytes=None, spid=None):
    # type: (Optional[str], Optional[int]) -> None
    self.bytes = bytes
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.ByteSet')
    L = out_node.fields

    x0 = NewLeaf(self.bytes, color_e.StringConst)
    L.append(field('bytes', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.ByteSet')
    L = out_node.fields
    x0 = NewLeaf(self.bytes, color_e.StringConst)
    L.append(field('bytes', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class class_literal_term__CodePoint(class_literal_term_t):
  tag = 10
  __slots__ = ('i', 'spid')

  def __init__(self, i=None, spid=None):
    # type: (Optional[int], Optional[int]) -> None
    self.i = i
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.CodePoint')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(field('i', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('class_literal_term.CodePoint')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(field('i', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class class_literal_term(object):
  Range = class_literal_term__Range
  CharLiteral = class_literal_term__CharLiteral
  ByteSet = class_literal_term__ByteSet
  CodePoint = class_literal_term__CodePoint

class re_repeat_e(object):
  Op = 1
  Num = 2
  Range = 3

_re_repeat_str = {
  1: 're_repeat.Op',
  2: 're_repeat.Num',
  3: 're_repeat.Range',
}

def re_repeat_str(tag):
  # type: (int) -> str
  return _re_repeat_str[tag]

class re_repeat_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class re_repeat__Op(re_repeat_t):
  tag = 1
  __slots__ = ('op',)

  def __init__(self, op=None):
    # type: (Optional[Token]) -> None
    self.op = op

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re_repeat.Op')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(field('op', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re_repeat.Op')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(field('op', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re_repeat__Num(re_repeat_t):
  tag = 2
  __slots__ = ('times',)

  def __init__(self, times=None):
    # type: (Optional[Token]) -> None
    self.times = times

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re_repeat.Num')
    L = out_node.fields

    assert self.times is not None
    x0 = self.times.PrettyTree()
    L.append(field('times', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re_repeat.Num')
    L = out_node.fields
    assert self.times is not None
    x0 = self.times.AbbreviatedTree()
    L.append(field('times', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re_repeat__Range(re_repeat_t):
  tag = 3
  __slots__ = ('lower', 'upper')

  def __init__(self, lower=None, upper=None):
    # type: (Optional[Token], Optional[Token]) -> None
    self.lower = lower if lower is not None else None
    self.upper = upper if upper is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re_repeat.Range')
    L = out_node.fields

    if self.lower is not None:  # MaybeType
      x0 = self.lower.PrettyTree()
      L.append(field('lower', x0))

    if self.upper is not None:  # MaybeType
      x1 = self.upper.PrettyTree()
      L.append(field('upper', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re_repeat.Range')
    L = out_node.fields
    if self.lower is not None:  # MaybeType
      x0 = self.lower.AbbreviatedTree()
      L.append(field('lower', x0))

    if self.upper is not None:  # MaybeType
      x1 = self.upper.AbbreviatedTree()
      L.append(field('upper', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re_repeat(object):
  Op = re_repeat__Op
  Num = re_repeat__Num
  Range = re_repeat__Range

class re_e(object):
  Speck = 1002
  Token = 1001
  PosixClass = 1025
  PerlClass = 1026
  ClassLiteral = 5
  Splice = 6
  SimpleVarSub = 1005
  BracedVarSub = 1006
  SingleQuoted = 1004
  DoubleQuoted = 1003
  Repeat = 11
  Seq = 12
  Alt = 13
  Group = 14
  Capture = 15
  Backtracking = 16
  Primitive = 17
  LiteralChars = 18

_re_str = {
  5: 're.ClassLiteral',
  6: 're.Splice',
  11: 're.Repeat',
  12: 're.Seq',
  13: 're.Alt',
  14: 're.Group',
  15: 're.Capture',
  16: 're.Backtracking',
  17: 're.Primitive',
  18: 're.LiteralChars',
  1001: 're.Token',
  1002: 're.Speck',
  1003: 're.DoubleQuoted',
  1004: 're.SingleQuoted',
  1005: 're.SimpleVarSub',
  1006: 're.BracedVarSub',
  1025: 're.PosixClass',
  1026: 're.PerlClass',
}

def re_str(tag):
  # type: (int) -> str
  return _re_str[tag]

class re_t(pybase.CompoundObj):
  def tag_(self):
    # type: () -> int
    return self.tag
  pass

class re__ClassLiteral(re_t):
  tag = 5
  __slots__ = ('negated', 'terms')

  def __init__(self, negated=None, terms=None):
    # type: (Optional[bool], Optional[List[class_literal_term_t]]) -> None
    self.negated = negated
    self.terms = terms if terms is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.ClassLiteral')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x0))

    if self.terms:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.terms:
        x1.children.append(i1.PrettyTree())
      L.append(field('terms', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.ClassLiteral')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x0))

    if self.terms:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.terms:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('terms', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Splice(re_t):
  tag = 6
  __slots__ = ('name',)

  def __init__(self, name=None):
    # type: (Optional[Token]) -> None
    self.name = name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Splice')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Splice')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Repeat(re_t):
  tag = 11
  __slots__ = ('child', 'op')

  def __init__(self, child=None, op=None):
    # type: (Optional[re_t], Optional[re_repeat_t]) -> None
    self.child = child
    self.op = op

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Repeat')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    assert self.op is not None
    x1 = self.op.PrettyTree()
    L.append(field('op', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Repeat')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    assert self.op is not None
    x1 = self.op.AbbreviatedTree()
    L.append(field('op', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Seq(re_t):
  tag = 12
  __slots__ = ('children',)

  def __init__(self, children=None):
    # type: (Optional[List[re_t]]) -> None
    self.children = children if children is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Seq')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(field('children', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Seq')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('children', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Alt(re_t):
  tag = 13
  __slots__ = ('children',)

  def __init__(self, children=None):
    # type: (Optional[List[re_t]]) -> None
    self.children = children if children is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Alt')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(field('children', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Alt')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('children', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Group(re_t):
  tag = 14
  __slots__ = ('child',)

  def __init__(self, child=None):
    # type: (Optional[re_t]) -> None
    self.child = child

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Group')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Group')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Capture(re_t):
  tag = 15
  __slots__ = ('child', 'var_name')

  def __init__(self, child=None, var_name=None):
    # type: (Optional[re_t], Optional[Token]) -> None
    self.child = child
    self.var_name = var_name if var_name is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Capture')
    L = out_node.fields

    assert self.child is not None
    x0 = self.child.PrettyTree()
    L.append(field('child', x0))

    if self.var_name is not None:  # MaybeType
      x1 = self.var_name.PrettyTree()
      L.append(field('var_name', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Capture')
    L = out_node.fields
    assert self.child is not None
    x0 = self.child.AbbreviatedTree()
    L.append(field('child', x0))

    if self.var_name is not None:  # MaybeType
      x1 = self.var_name.AbbreviatedTree()
      L.append(field('var_name', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Backtracking(re_t):
  tag = 16
  __slots__ = ('negated', 'name', 'child')

  def __init__(self, negated=None, name=None, child=None):
    # type: (Optional[bool], Optional[Token], Optional[re_t]) -> None
    self.negated = negated
    self.name = name
    self.child = child

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Backtracking')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x0))

    assert self.name is not None
    x1 = self.name.PrettyTree()
    L.append(field('name', x1))

    assert self.child is not None
    x2 = self.child.PrettyTree()
    L.append(field('child', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Backtracking')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.negated else 'F', color_e.OtherConst)
    L.append(field('negated', x0))

    assert self.name is not None
    x1 = self.name.AbbreviatedTree()
    L.append(field('name', x1))

    assert self.child is not None
    x2 = self.child.AbbreviatedTree()
    L.append(field('child', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__Primitive(re_t):
  tag = 17
  __slots__ = ('id',)

  def __init__(self, id=None):
    # type: (Optional[Id_t]) -> None
    self.id = id

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Primitive')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.Primitive')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re__LiteralChars(re_t):
  tag = 18
  __slots__ = ('s', 'spid')

  def __init__(self, s=None, spid=None):
    # type: (Optional[str], Optional[int]) -> None
    self.s = s
    self.spid = spid

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.LiteralChars')
    L = out_node.fields

    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('re.LiteralChars')
    L = out_node.fields
    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(field('s', x0))

    x1 = hnode.Leaf(str(self.spid), color_e.OtherConst)
    L.append(field('spid', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class re(object):
  ClassLiteral = re__ClassLiteral
  Splice = re__Splice
  Repeat = re__Repeat
  Seq = re__Seq
  Alt = re__Alt
  Group = re__Group
  Capture = re__Capture
  Backtracking = re__Backtracking
  Primitive = re__Primitive
  LiteralChars = re__LiteralChars

class line_span(pybase.CompoundObj):
  tag = 1000
  __slots__ = ('line_id', 'col', 'length')

  def __init__(self, line_id=None, col=None, length=None):
    # type: (Optional[int], Optional[int], Optional[int]) -> None
    self.line_id = line_id
    self.col = col
    self.length = length

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('line_span')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.line_id), color_e.OtherConst)
    L.append(field('line_id', x0))

    x1 = hnode.Leaf(str(self.col), color_e.OtherConst)
    L.append(field('col', x1))

    x2 = hnode.Leaf(str(self.length), color_e.OtherConst)
    L.append(field('length', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('line_span')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.line_id), color_e.OtherConst)
    L.append(field('line_id', x0))

    x1 = hnode.Leaf(str(self.col), color_e.OtherConst)
    L.append(field('col', x1))

    x2 = hnode.Leaf(str(self.length), color_e.OtherConst)
    L.append(field('length', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class Token(suffix_op_t, word_part_t, word_t, arith_expr_t, re_t):
  tag = 1001
  __slots__ = ('id', 'span_id', 'val')

  def __init__(self, id=None, span_id=None, val=None):
    # type: (Optional[Id_t], Optional[int], Optional[str]) -> None
    self.id = id
    self.span_id = span_id
    self.val = val

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('Token')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = hnode.Leaf(str(self.span_id), color_e.OtherConst)
    L.append(field('span_id', x1))

    x2 = NewLeaf(self.val, color_e.StringConst)
    L.append(field('val', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('Token')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = hnode.Leaf(str(self.span_id), color_e.OtherConst)
    L.append(field('span_id', x1))

    x2 = NewLeaf(self.val, color_e.StringConst)
    L.append(field('val', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _Token(self)
    return p if p else self._AbbreviatedTree()

class speck(re_t):
  tag = 1002
  __slots__ = ('id', 'span_id')

  def __init__(self, id=None, span_id=None):
    # type: (Optional[Id_t], Optional[int]) -> None
    self.id = id
    self.span_id = span_id

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('speck')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = hnode.Leaf(str(self.span_id), color_e.OtherConst)
    L.append(field('span_id', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('speck')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.id), color_e.UserType)
    L.append(field('id', x0))

    x1 = hnode.Leaf(str(self.span_id), color_e.OtherConst)
    L.append(field('span_id', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _speck(self)
    return p if p else self._AbbreviatedTree()

class double_quoted(word_part_t, expr_t, class_literal_term_t, re_t):
  tag = 1003
  __slots__ = ('left', 'parts', 'spids')

  def __init__(self, left=None, parts=None, spids=None):
    # type: (Optional[Token], Optional[List[word_part_t]], Optional[List[int]]) -> None
    self.left = left
    self.parts = parts if parts is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('double_quoted')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    if self.parts:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.parts:
        x1.children.append(i1.PrettyTree())
      L.append(field('parts', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('double_quoted')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    if self.parts:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.parts:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('parts', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _double_quoted(self)
    return p if p else self._AbbreviatedTree()

class single_quoted(word_part_t, expr_t, class_literal_term_t, re_t):
  tag = 1004
  __slots__ = ('left', 'tokens', 'spids')

  def __init__(self, left=None, tokens=None, spids=None):
    # type: (Optional[Token], Optional[List[Token]], Optional[List[int]]) -> None
    self.left = left
    self.tokens = tokens if tokens is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('single_quoted')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    if self.tokens:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.tokens:
        x1.children.append(i1.PrettyTree())
      L.append(field('tokens', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('single_quoted')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    if self.tokens:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.tokens:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('tokens', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _single_quoted(self)
    return p if p else self._AbbreviatedTree()

class simple_var_sub(word_part_t, expr_t, class_literal_term_t, re_t):
  tag = 1005
  __slots__ = ('token',)

  def __init__(self, token=None):
    # type: (Optional[Token]) -> None
    self.token = token

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('simple_var_sub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(field('token', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('simple_var_sub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(field('token', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _simple_var_sub(self)
    return p if p else self._AbbreviatedTree()

class braced_var_sub(word_part_t, expr_t, class_literal_term_t, re_t):
  tag = 1006
  __slots__ = ('token', 'prefix_op', 'bracket_op', 'suffix_op', 'spids')

  def __init__(self, token=None, prefix_op=None, bracket_op=None,
               suffix_op=None, spids=None):
    # type: (Optional[Token], Optional[speck], Optional[bracket_op_t], Optional[suffix_op_t], Optional[List[int]]) -> None
    self.token = token
    self.prefix_op = prefix_op if prefix_op is not None else None
    self.bracket_op = bracket_op if bracket_op is not None else None
    self.suffix_op = suffix_op if suffix_op is not None else None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('braced_var_sub')
    L = out_node.fields

    assert self.token is not None
    x0 = self.token.PrettyTree()
    L.append(field('token', x0))

    if self.prefix_op is not None:  # MaybeType
      x1 = self.prefix_op.PrettyTree()
      L.append(field('prefix_op', x1))

    if self.bracket_op is not None:  # MaybeType
      x2 = self.bracket_op.PrettyTree()
      L.append(field('bracket_op', x2))

    if self.suffix_op is not None:  # MaybeType
      x3 = self.suffix_op.PrettyTree()
      L.append(field('suffix_op', x3))

    if self.spids:  # ArrayType
      x4 = hnode.Array([])
      for i4 in self.spids:
        x4.children.append(hnode.Leaf(str(i4), color_e.OtherConst))
      L.append(field('spids', x4))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('braced_var_sub')
    L = out_node.fields
    assert self.token is not None
    x0 = self.token.AbbreviatedTree()
    L.append(field('token', x0))

    if self.prefix_op is not None:  # MaybeType
      x1 = self.prefix_op.AbbreviatedTree()
      L.append(field('prefix_op', x1))

    if self.bracket_op is not None:  # MaybeType
      x2 = self.bracket_op.AbbreviatedTree()
      L.append(field('bracket_op', x2))

    if self.suffix_op is not None:  # MaybeType
      x3 = self.suffix_op.AbbreviatedTree()
      L.append(field('suffix_op', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _braced_var_sub(self)
    return p if p else self._AbbreviatedTree()

class command_sub(word_part_t, expr_t):
  tag = 1007
  __slots__ = ('left_token', 'child', 'spids')

  def __init__(self, left_token=None, child=None, spids=None):
    # type: (Optional[Token], Optional[command_t], Optional[List[int]]) -> None
    self.left_token = left_token
    self.child = child
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command_sub')
    L = out_node.fields

    assert self.left_token is not None
    x0 = self.left_token.PrettyTree()
    L.append(field('left_token', x0))

    assert self.child is not None
    x1 = self.child.PrettyTree()
    L.append(field('child', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('command_sub')
    L = out_node.fields
    assert self.left_token is not None
    x0 = self.left_token.AbbreviatedTree()
    L.append(field('left_token', x0))

    assert self.child is not None
    x1 = self.child.AbbreviatedTree()
    L.append(field('child', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class sh_array_literal(word_part_t, expr_t):
  tag = 1008
  __slots__ = ('left', 'words', 'spids')

  def __init__(self, left=None, words=None, spids=None):
    # type: (Optional[Token], Optional[List[word_t]], Optional[List[int]]) -> None
    self.left = left
    self.words = words if words is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_array_literal')
    L = out_node.fields

    assert self.left is not None
    x0 = self.left.PrettyTree()
    L.append(field('left', x0))

    if self.words:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.words:
        x1.children.append(i1.PrettyTree())
      L.append(field('words', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('sh_array_literal')
    L = out_node.fields
    assert self.left is not None
    x0 = self.left.AbbreviatedTree()
    L.append(field('left', x0))

    if self.words:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.words:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('words', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class arg_list(pybase.CompoundObj):
  tag = 1009
  __slots__ = ('positional', 'named')

  def __init__(self, positional=None, named=None):
    # type: (Optional[List[expr_t]], Optional[List[named_arg]]) -> None
    self.positional = positional if positional is not None else []
    self.named = named if named is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arg_list')
    L = out_node.fields

    if self.positional:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.positional:
        x0.children.append(i0.PrettyTree())
      L.append(field('positional', x0))

    if self.named:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.named:
        x1.children.append(i1.PrettyTree())
      L.append(field('named', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('arg_list')
    L = out_node.fields
    if self.positional:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.positional:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('positional', x0))

    if self.named:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.named:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('named', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class compound_word(word_t, arith_expr_t, redir_param_t):
  tag = 1010
  __slots__ = ('parts',)

  def __init__(self, parts=None):
    # type: (Optional[List[word_part_t]]) -> None
    self.parts = parts if parts is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('compound_word')
    L = out_node.fields

    if self.parts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.parts:
        x0.children.append(i0.PrettyTree())
      L.append(field('parts', x0))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('compound_word')
    L = out_node.fields
    if self.parts:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.parts:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('parts', x0))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    p = _compound_word(self)
    return p if p else self._AbbreviatedTree()

class redir(pybase.CompoundObj):
  tag = 1011
  __slots__ = ('op', 'loc', 'arg')

  def __init__(self, op=None, loc=None, arg=None):
    # type: (Optional[Token], Optional[redir_loc_t], Optional[redir_param_t]) -> None
    self.op = op
    self.loc = loc
    self.arg = arg

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir')
    L = out_node.fields

    assert self.op is not None
    x0 = self.op.PrettyTree()
    L.append(field('op', x0))

    assert self.loc is not None
    x1 = self.loc.PrettyTree()
    L.append(field('loc', x1))

    assert self.arg is not None
    x2 = self.arg.PrettyTree()
    L.append(field('arg', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('redir')
    L = out_node.fields
    assert self.op is not None
    x0 = self.op.AbbreviatedTree()
    L.append(field('op', x0))

    assert self.loc is not None
    x1 = self.loc.AbbreviatedTree()
    L.append(field('loc', x1))

    assert self.arg is not None
    x2 = self.arg.AbbreviatedTree()
    L.append(field('arg', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class assign_pair(pybase.CompoundObj):
  tag = 1012
  __slots__ = ('lhs', 'op', 'rhs', 'spids')

  def __init__(self, lhs=None, op=None, rhs=None, spids=None):
    # type: (Optional[sh_lhs_expr_t], Optional[assign_op_t], Optional[word_t], Optional[List[int]]) -> None
    self.lhs = lhs
    self.op = op if op is not None else assign_op_e.Equal
    self.rhs = rhs if rhs is not None else None
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('assign_pair')
    L = out_node.fields

    assert self.lhs is not None
    x0 = self.lhs.PrettyTree()
    L.append(field('lhs', x0))

    x1 = hnode.Leaf(assign_op_str(self.op), color_e.TypeName)
    L.append(field('op', x1))

    if self.rhs is not None:  # MaybeType
      x2 = self.rhs.PrettyTree()
      L.append(field('rhs', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('assign_pair')
    L = out_node.fields
    assert self.lhs is not None
    x0 = self.lhs.AbbreviatedTree()
    L.append(field('lhs', x0))

    x1 = hnode.Leaf(assign_op_str(self.op), color_e.TypeName)
    L.append(field('op', x1))

    if self.rhs is not None:  # MaybeType
      x2 = self.rhs.AbbreviatedTree()
      L.append(field('rhs', x2))

    if self.spids:  # ArrayType
      x3 = hnode.Array([])
      for i3 in self.spids:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(field('spids', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class env_pair(pybase.CompoundObj):
  tag = 1013
  __slots__ = ('name', 'val', 'spids')

  def __init__(self, name=None, val=None, spids=None):
    # type: (Optional[str], Optional[word_t], Optional[List[int]]) -> None
    self.name = name
    self.val = val
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('env_pair')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    assert self.val is not None
    x1 = self.val.PrettyTree()
    L.append(field('val', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('env_pair')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x0))

    assert self.val is not None
    x1 = self.val.AbbreviatedTree()
    L.append(field('val', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class case_arm(pybase.CompoundObj):
  tag = 1014
  __slots__ = ('pat_list', 'action', 'spids')

  def __init__(self, pat_list=None, action=None, spids=None):
    # type: (Optional[List[word_t]], Optional[List[command_t]], Optional[List[int]]) -> None
    self.pat_list = pat_list if pat_list is not None else []
    self.action = action if action is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('case_arm')
    L = out_node.fields

    if self.pat_list:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.pat_list:
        x0.children.append(i0.PrettyTree())
      L.append(field('pat_list', x0))

    if self.action:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.action:
        x1.children.append(i1.PrettyTree())
      L.append(field('action', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('case_arm')
    L = out_node.fields
    if self.pat_list:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.pat_list:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('pat_list', x0))

    if self.action:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.action:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('action', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class if_arm(pybase.CompoundObj):
  tag = 1015
  __slots__ = ('cond', 'action', 'spids')

  def __init__(self, cond=None, action=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[command_t]], Optional[List[int]]) -> None
    self.cond = cond if cond is not None else []
    self.action = action if action is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('if_arm')
    L = out_node.fields

    if self.cond:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.cond:
        x0.children.append(i0.PrettyTree())
      L.append(field('cond', x0))

    if self.action:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.action:
        x1.children.append(i1.PrettyTree())
      L.append(field('action', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('if_arm')
    L = out_node.fields
    if self.cond:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.cond:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('cond', x0))

    if self.action:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.action:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('action', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class BraceGroup(command_t):
  tag = 1016
  __slots__ = ('children', 'redirects', 'spids')

  def __init__(self, children=None, redirects=None, spids=None):
    # type: (Optional[List[command_t]], Optional[List[redir]], Optional[List[int]]) -> None
    self.children = children if children is not None else []
    self.redirects = redirects if redirects is not None else []
    self.spids = spids if spids is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('BraceGroup')
    L = out_node.fields

    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.PrettyTree())
      L.append(field('children', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.PrettyTree())
      L.append(field('redirects', x1))

    if self.spids:  # ArrayType
      x2 = hnode.Array([])
      for i2 in self.spids:
        x2.children.append(hnode.Leaf(str(i2), color_e.OtherConst))
      L.append(field('spids', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('BraceGroup')
    L = out_node.fields
    if self.children:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.children:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('children', x0))

    if self.redirects:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.redirects:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('redirects', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class variant(pybase.CompoundObj):
  tag = 1017
  __slots__ = ('tag_name', 'typ')

  def __init__(self, tag_name=None, typ=None):
    # type: (Optional[Token], Optional[variant_type_t]) -> None
    self.tag_name = tag_name
    self.typ = typ if typ is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('variant')
    L = out_node.fields

    assert self.tag_name is not None
    x0 = self.tag_name.PrettyTree()
    L.append(field('tag_name', x0))

    if self.typ is not None:  # MaybeType
      x1 = self.typ.PrettyTree()
      L.append(field('typ', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('variant')
    L = out_node.fields
    assert self.tag_name is not None
    x0 = self.tag_name.AbbreviatedTree()
    L.append(field('tag_name', x0))

    if self.typ is not None:  # MaybeType
      x1 = self.typ.AbbreviatedTree()
      L.append(field('typ', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class use_name(pybase.CompoundObj):
  tag = 1018
  __slots__ = ('name', 'alias')

  def __init__(self, name=None, alias=None):
    # type: (Optional[Token], Optional[Token]) -> None
    self.name = name
    self.alias = alias if alias is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('use_name')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.alias is not None:  # MaybeType
      x1 = self.alias.PrettyTree()
      L.append(field('alias', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('use_name')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.alias is not None:  # MaybeType
      x1 = self.alias.AbbreviatedTree()
      L.append(field('alias', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class param(pybase.CompoundObj):
  tag = 1019
  __slots__ = ('name', 'type', 'default_val')

  def __init__(self, name=None, type=None, default_val=None):
    # type: (Optional[Token], Optional[type_expr_t], Optional[expr_t]) -> None
    self.name = name
    self.type = type if type is not None else None
    self.default_val = default_val if default_val is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('param')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.type is not None:  # MaybeType
      x1 = self.type.PrettyTree()
      L.append(field('type', x1))

    if self.default_val is not None:  # MaybeType
      x2 = self.default_val.PrettyTree()
      L.append(field('default_val', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('param')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.type is not None:  # MaybeType
      x1 = self.type.AbbreviatedTree()
      L.append(field('type', x1))

    if self.default_val is not None:  # MaybeType
      x2 = self.default_val.AbbreviatedTree()
      L.append(field('default_val', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class name_type(pybase.CompoundObj):
  tag = 1020
  __slots__ = ('name', 'typ')

  def __init__(self, name=None, typ=None):
    # type: (Optional[Token], Optional[type_expr_t]) -> None
    self.name = name
    self.typ = typ if typ is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('name_type')
    L = out_node.fields

    assert self.name is not None
    x0 = self.name.PrettyTree()
    L.append(field('name', x0))

    if self.typ is not None:  # MaybeType
      x1 = self.typ.PrettyTree()
      L.append(field('typ', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('name_type')
    L = out_node.fields
    assert self.name is not None
    x0 = self.name.AbbreviatedTree()
    L.append(field('name', x0))

    if self.typ is not None:  # MaybeType
      x1 = self.typ.AbbreviatedTree()
      L.append(field('typ', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class comprehension(pybase.CompoundObj):
  tag = 1021
  __slots__ = ('lhs', 'iter', 'cond')

  def __init__(self, lhs=None, iter=None, cond=None):
    # type: (Optional[List[name_type]], Optional[expr_t], Optional[expr_t]) -> None
    self.lhs = lhs if lhs is not None else []
    self.iter = iter
    self.cond = cond if cond is not None else None

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('comprehension')
    L = out_node.fields

    if self.lhs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.lhs:
        x0.children.append(i0.PrettyTree())
      L.append(field('lhs', x0))

    assert self.iter is not None
    x1 = self.iter.PrettyTree()
    L.append(field('iter', x1))

    if self.cond is not None:  # MaybeType
      x2 = self.cond.PrettyTree()
      L.append(field('cond', x2))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('comprehension')
    L = out_node.fields
    if self.lhs:  # ArrayType
      x0 = hnode.Array([])
      for i0 in self.lhs:
        x0.children.append(i0.AbbreviatedTree())
      L.append(field('lhs', x0))

    assert self.iter is not None
    x1 = self.iter.AbbreviatedTree()
    L.append(field('iter', x1))

    if self.cond is not None:  # MaybeType
      x2 = self.cond.AbbreviatedTree()
      L.append(field('cond', x2))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class named_arg(pybase.CompoundObj):
  tag = 1022
  __slots__ = ('name', 'value')

  def __init__(self, name=None, value=None):
    # type: (Optional[Token], Optional[expr_t]) -> None
    self.name = name if name is not None else None
    self.value = value

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('named_arg')
    L = out_node.fields

    if self.name is not None:  # MaybeType
      x0 = self.name.PrettyTree()
      L.append(field('name', x0))

    assert self.value is not None
    x1 = self.value.PrettyTree()
    L.append(field('value', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('named_arg')
    L = out_node.fields
    if self.name is not None:  # MaybeType
      x0 = self.name.AbbreviatedTree()
      L.append(field('name', x0))

    assert self.value is not None
    x1 = self.value.AbbreviatedTree()
    L.append(field('value', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class subscript(place_expr_t, expr_t):
  tag = 1023
  __slots__ = ('obj', 'indices')

  def __init__(self, obj=None, indices=None):
    # type: (Optional[expr_t], Optional[List[expr_t]]) -> None
    self.obj = obj
    self.indices = indices if indices is not None else []

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('subscript')
    L = out_node.fields

    assert self.obj is not None
    x0 = self.obj.PrettyTree()
    L.append(field('obj', x0))

    if self.indices:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.indices:
        x1.children.append(i1.PrettyTree())
      L.append(field('indices', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('subscript')
    L = out_node.fields
    assert self.obj is not None
    x0 = self.obj.AbbreviatedTree()
    L.append(field('obj', x0))

    if self.indices:  # ArrayType
      x1 = hnode.Array([])
      for i1 in self.indices:
        x1.children.append(i1.AbbreviatedTree())
      L.append(field('indices', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class attribute(place_expr_t, expr_t):
  tag = 1024
  __slots__ = ('obj', 'op', 'attr', 'ctx')

  def __init__(self, obj=None, op=None, attr=None, ctx=None):
    # type: (Optional[expr_t], Optional[Token], Optional[Token], Optional[expr_context_t]) -> None
    self.obj = obj
    self.op = op
    self.attr = attr
    self.ctx = ctx if ctx is not None else expr_context_e.Load

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('attribute')
    L = out_node.fields

    assert self.obj is not None
    x0 = self.obj.PrettyTree()
    L.append(field('obj', x0))

    assert self.op is not None
    x1 = self.op.PrettyTree()
    L.append(field('op', x1))

    assert self.attr is not None
    x2 = self.attr.PrettyTree()
    L.append(field('attr', x2))

    x3 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x3))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('attribute')
    L = out_node.fields
    assert self.obj is not None
    x0 = self.obj.AbbreviatedTree()
    L.append(field('obj', x0))

    assert self.op is not None
    x1 = self.op.AbbreviatedTree()
    L.append(field('op', x1))

    assert self.attr is not None
    x2 = self.attr.AbbreviatedTree()
    L.append(field('attr', x2))

    x3 = hnode.Leaf(expr_context_str(self.ctx), color_e.TypeName)
    L.append(field('ctx', x3))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class posix_class(class_literal_term_t, re_t):
  tag = 1025
  __slots__ = ('negated', 'name')

  def __init__(self, negated=None, name=None):
    # type: (Optional[speck], Optional[str]) -> None
    self.negated = negated if negated is not None else None
    self.name = name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('posix_class')
    L = out_node.fields

    if self.negated is not None:  # MaybeType
      x0 = self.negated.PrettyTree()
      L.append(field('negated', x0))

    x1 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('posix_class')
    L = out_node.fields
    if self.negated is not None:  # MaybeType
      x0 = self.negated.AbbreviatedTree()
      L.append(field('negated', x0))

    x1 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

class perl_class(class_literal_term_t, re_t):
  tag = 1026
  __slots__ = ('negated', 'name')

  def __init__(self, negated=None, name=None):
    # type: (Optional[speck], Optional[str]) -> None
    self.negated = negated if negated is not None else None
    self.name = name

  def PrettyTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('perl_class')
    L = out_node.fields

    if self.negated is not None:  # MaybeType
      x0 = self.negated.PrettyTree()
      L.append(field('negated', x0))

    x1 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x1))

    return out_node

  def _AbbreviatedTree(self):
    # type: () -> hnode_t
    out_node = NewRecord('perl_class')
    L = out_node.fields
    if self.negated is not None:  # MaybeType
      x0 = self.negated.AbbreviatedTree()
      L.append(field('negated', x0))

    x1 = NewLeaf(self.name, color_e.StringConst)
    L.append(field('name', x1))

    return out_node

  def AbbreviatedTree(self):
    # type: () -> hnode_t
    return self._AbbreviatedTree()

#
# CONCATENATED FILE
#

"""
syntax_abbrev.py - Abbreviations for pretty-printing syntax.asdl.

This module is not used directly, but is combined with generated code.
"""

from _devbuild.gen.id_kind_asdl import Id
from _devbuild.gen.hnode_asdl import hnode_t
from asdl import runtime


def _AbbreviateToken(tok, out):
  # type: (Token, List[hnode_t]) -> None
  if tok.id != Id.Lit_Chars:
    n1 = runtime.NewLeaf(Id_str(tok.id), color_e.OtherConst)
    out.append(n1)

  n2 = runtime.NewLeaf(tok.val, color_e.StringConst)
  out.append(n2)


def _Token(obj):
  # type: (Token) -> hnode_t
  p_node = runtime.NewRecord('')  # don't show node type
  p_node.abbrev = True

  p_node.left = '<'
  p_node.right = '>'
  _AbbreviateToken(obj, p_node.unnamed_fields)
  return p_node


def _compound_word(obj):
  # type: (compound_word) -> hnode_t
  p_node = runtime.NewRecord('')  # don't show node type
  p_node.abbrev = True
  p_node.left = '{'
  p_node.right = '}'

  for part in obj.parts:
    p_node.unnamed_fields.append(part.AbbreviatedTree())
  return p_node


def _speck(obj):
  # type: (speck) -> hnode_t
  """Always abbreviate a speck as the Id."""
  p_node = runtime.NewRecord('')  # don't show node type
  p_node.abbrev = True

  n1 = runtime.NewLeaf(Id_str(obj.id), color_e.OtherConst)
  p_node.unnamed_fields.append(n1)
  return p_node


def _double_quoted(obj):
  # type: (double_quoted) -> hnode_t
  if obj.left.id != Id.Left_DoubleQuote:
    return None  # Fall back on obj._AbbreviatedTree()

  p_node = runtime.NewRecord('DQ')
  p_node.abbrev = True

  for part in obj.parts:
    p_node.unnamed_fields.append(part.AbbreviatedTree())
  return p_node


def _single_quoted(obj):
  # type: (single_quoted) -> hnode_t

  # Only abbreviate 'foo', not $'foo\n'
  if obj.left.id != Id.Left_SingleQuoteRaw:
    return None  # Fall back on obj._AbbreviatedTree()

  p_node = runtime.NewRecord('SQ')
  p_node.abbrev = True

  for token in obj.tokens:
    p_node.unnamed_fields.append(token.AbbreviatedTree())
  return p_node


def _simple_var_sub(obj):
  # type: (simple_var_sub) -> hnode_t
  p_node = runtime.NewRecord('$')
  p_node.abbrev = True
  _AbbreviateToken(obj.token, p_node.unnamed_fields)
  return p_node


def _braced_var_sub(obj):
  # type: (braced_var_sub) -> hnode_t
  p_node = runtime.NewRecord('${')
  if obj.prefix_op or obj.bracket_op or obj.suffix_op:
    return None  # we have other fields to display; don't abbreviate

  p_node.abbrev = True
  _AbbreviateToken(obj.token, p_node.unnamed_fields)
  return p_node


def _command__Simple(obj):
  # type: (command__Simple) -> hnode_t
  p_node = runtime.NewRecord('C')
  if obj.redirects or obj.more_env or obj.block or obj.do_fork == False:
    return None  # we have other fields to display; don't abbreviate

  p_node.abbrev = True

  for w in obj.words:
    p_node.unnamed_fields.append(w.AbbreviatedTree())
  return p_node


def _expr__Var(obj):
  # type: (expr__Var) -> hnode_t
  p_node = runtime.NewRecord('Var')
  p_node.abbrev = True

  assert obj.name.id == Id.Expr_Name, obj.name
  n1 = runtime.NewLeaf(obj.name.val, color_e.StringConst)
  p_node.unnamed_fields.append(n1)
  return p_node


def _expr__Const(obj):
  # type: (expr__Const) -> hnode_t
  p_node = runtime.NewRecord('Const')
  p_node.abbrev = True

  tok = obj.c
  out = p_node.unnamed_fields

  n1 = runtime.NewLeaf(Id_str(tok.id), color_e.OtherConst)
  out.append(n1)

  n2 = runtime.NewLeaf(tok.val, color_e.StringConst)
  out.append(n2)
  return p_node
