from asdl import pybase
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, field

class bool_arg_type_t(pybase.SimpleObj):
  pass

class bool_arg_type_e(object):
  Undefined = bool_arg_type_t(1)
  Path = bool_arg_type_t(2)
  Int = bool_arg_type_t(3)
  Str = bool_arg_type_t(4)
  Other = bool_arg_type_t(5)

_bool_arg_type_str = {
  1: 'bool_arg_type.Undefined',
  2: 'bool_arg_type.Path',
  3: 'bool_arg_type.Int',
  4: 'bool_arg_type.Str',
  5: 'bool_arg_type.Other',
}

def bool_arg_type_str(val):
  # type: (bool_arg_type_t) -> str
  return _bool_arg_type_str[val]

class redir_arg_type_t(pybase.SimpleObj):
  pass

class redir_arg_type_e(object):
  Path = redir_arg_type_t(1)
  Desc = redir_arg_type_t(2)
  Here = redir_arg_type_t(3)

_redir_arg_type_str = {
  1: 'redir_arg_type.Path',
  2: 'redir_arg_type.Desc',
  3: 'redir_arg_type.Here',
}

def redir_arg_type_str(val):
  # type: (redir_arg_type_t) -> str
  return _redir_arg_type_str[val]

class lex_mode_t(pybase.SimpleObj):
  pass

class lex_mode_e(object):
  Undefined = lex_mode_t(1)
  Comment = lex_mode_t(2)
  ShCommand = lex_mode_t(3)
  Backtick = lex_mode_t(4)
  DBracket = lex_mode_t(5)
  SQ_Raw = lex_mode_t(6)
  DQ = lex_mode_t(7)
  SQ_C = lex_mode_t(8)
  Arith = lex_mode_t(9)
  ExtGlob = lex_mode_t(10)
  VSub_1 = lex_mode_t(11)
  VSub_2 = lex_mode_t(12)
  VSub_ArgUnquoted = lex_mode_t(13)
  VSub_ArgDQ = lex_mode_t(14)
  BashRegex = lex_mode_t(15)
  BashRegexChars = lex_mode_t(16)
  PrintfOuter = lex_mode_t(17)
  PrintfPercent = lex_mode_t(18)
  Expr = lex_mode_t(19)

_lex_mode_str = {
  1: 'lex_mode.Undefined',
  2: 'lex_mode.Comment',
  3: 'lex_mode.ShCommand',
  4: 'lex_mode.Backtick',
  5: 'lex_mode.DBracket',
  6: 'lex_mode.SQ_Raw',
  7: 'lex_mode.DQ',
  8: 'lex_mode.SQ_C',
  9: 'lex_mode.Arith',
  10: 'lex_mode.ExtGlob',
  11: 'lex_mode.VSub_1',
  12: 'lex_mode.VSub_2',
  13: 'lex_mode.VSub_ArgUnquoted',
  14: 'lex_mode.VSub_ArgDQ',
  15: 'lex_mode.BashRegex',
  16: 'lex_mode.BashRegexChars',
  17: 'lex_mode.PrintfOuter',
  18: 'lex_mode.PrintfPercent',
  19: 'lex_mode.Expr',
}

def lex_mode_str(val):
  # type: (lex_mode_t) -> str
  return _lex_mode_str[val]

