#ifndef OPTION_ASDL_H
#define OPTION_ASDL_H

namespace option_asdl {
namespace option_i {
  const int errexit = 1;
  const int nounset = 2;
  const int pipefail = 3;
  const int inherit_errexit = 4;
  const int nullglob = 5;
  const int noexec = 6;
  const int xtrace = 7;
  const int verbose = 8;
  const int noglob = 9;
  const int noclobber = 10;
  const int posix = 11;
  const int vi = 12;
  const int emacs = 13;
  const int interactive = 14;
  const int hashall = 15;
  const int failglob = 16;
  const int extglob = 17;
  const int eval_unsafe_arith = 18;
  const int parse_dynamic_arith = 19;
  const int compat_array = 20;
  const int verbose_errexit = 21;
  const int allow_command_sub = 22;
  const int dynamic_scope = 23;
  const int redefine_module = 24;
  const int _running_trap = 25;
  const int strict_argv = 26;
  const int strict_arith = 27;
  const int strict_array = 28;
  const int strict_control_flow = 29;
  const int strict_errexit = 30;
  const int strict_nameref = 31;
  const int strict_word_eval = 32;
  const int strict_tilde = 33;
  const int strict_glob = 34;
  const int parse_at = 35;
  const int parse_brace = 36;
  const int parse_paren = 37;
  const int parse_raw_string = 38;
  const int parse_triple_quote = 39;
  const int parse_triple_dot = 40;
  const int simple_word_eval = 41;
  const int dashglob = 42;
  const int expand_aliases = 43;
  const int command_sub_errexit = 44;
  const int process_sub_fail = 45;
  const int xtrace_rich = 46;
  const int xtrace_details = 47;
  const int sigpipe_status_ok = 48;
  const int redefine_proc = 49;
  const int parse_equals = 50;
  const int parse_at_all = 51;
  const int parse_backslash = 52;
  const int parse_backticks = 53;
  const int parse_dollar = 54;
  const int parse_ignored = 55;
  const int parse_amp = 56;
  const int simple_echo = 57;
  const int simple_eval_builtin = 58;
  const int simple_test_builtin = 59;
  const int parse_tea = 60;
  const int lastpipe = 61;
  const int progcomp = 62;
  const int histappend = 63;
  const int hostcomplete = 64;
  const int cmdhist = 65;
  const int assoc_expand_once = 66;
  const int autocd = 67;
  const int cdable_vars = 68;
  const int cdspell = 69;
  const int checkhash = 70;
  const int checkjobs = 71;
  const int checkwinsize = 72;
  const int complete_fullquote = 73;
  const int direxpand = 74;
  const int dirspell = 75;
  const int dotglob = 76;
  const int execfail = 77;
  const int extdebug = 78;
  const int extquote = 79;
  const int force_fignore = 80;
  const int globasciiranges = 81;
  const int globstar = 82;
  const int gnu_errfmt = 83;
  const int histreedit = 84;
  const int histverify = 85;
  const int huponexit = 86;
  const int interactive_comments = 87;
  const int lithist = 88;
  const int localvar_inherit = 89;
  const int localvar_unset = 90;
  const int login_shell = 91;
  const int mailwarn = 92;
  const int no_empty_cmd_completion = 93;
  const int nocaseglob = 94;
  const int nocasematch = 95;
  const int progcomp_alias = 96;
  const int promptvars = 97;
  const int restricted_shell = 98;
  const int shift_verbose = 99;
  const int sourcepath = 100;
  const int xpg_echo = 101;
  const int ARRAY_SIZE = 102;
};

const char* option_str(int tag);

typedef int option_t;

namespace builtin_i {
  const int colon = 1;
  const int dot = 2;
  const int exec_ = 3;
  const int eval = 4;
  const int set = 5;
  const int shift = 6;
  const int times = 7;
  const int trap = 8;
  const int unset = 9;
  const int builtin = 10;
  const int readonly = 11;
  const int local = 12;
  const int declare = 13;
  const int typeset = 14;
  const int export_ = 15;
  const int test = 16;
  const int bracket = 17;
  const int true_ = 18;
  const int false_ = 19;
  const int try_ = 20;
  const int read = 21;
  const int echo = 22;
  const int printf = 23;
  const int mapfile = 24;
  const int readarray = 25;
  const int cd = 26;
  const int pushd = 27;
  const int popd = 28;
  const int dirs = 29;
  const int pwd = 30;
  const int source = 31;
  const int umask = 32;
  const int wait = 33;
  const int jobs = 34;
  const int fg = 35;
  const int bg = 36;
  const int shopt = 37;
  const int complete = 38;
  const int compgen = 39;
  const int compopt = 40;
  const int compadjust = 41;
  const int getopts = 42;
  const int command = 43;
  const int type = 44;
  const int hash = 45;
  const int help = 46;
  const int history = 47;
  const int alias = 48;
  const int unalias = 49;
  const int bind = 50;
  const int append = 51;
  const int shvar = 52;
  const int write = 53;
  const int json = 54;
  const int pp = 55;
  const int module = 56;
  const int use = 57;
  const int argparse = 58;
  const int fopen = 59;
  const int fork = 60;
  const int forkwait = 61;
  const int runproc = 62;
  const int push_registers = 63;
  const int cat = 64;
  const int ARRAY_SIZE = 65;
};

const char* builtin_str(int tag);

typedef int builtin_t;


}  // namespace option_asdl

#endif  // OPTION_ASDL_H
