#ifndef ID_KIND_ASDL_H
#define ID_KIND_ASDL_H

namespace id_kind_asdl {
namespace Id {
  const int Word_Compound = 1;
  const int Arith_Semi = 2;
  const int Arith_Comma = 3;
  const int Arith_Plus = 4;
  const int Arith_Minus = 5;
  const int Arith_Star = 6;
  const int Arith_Slash = 7;
  const int Arith_Percent = 8;
  const int Arith_DPlus = 9;
  const int Arith_DMinus = 10;
  const int Arith_DStar = 11;
  const int Arith_LParen = 12;
  const int Arith_RParen = 13;
  const int Arith_LBracket = 14;
  const int Arith_RBracket = 15;
  const int Arith_RBrace = 16;
  const int Arith_QMark = 17;
  const int Arith_Colon = 18;
  const int Arith_LessEqual = 19;
  const int Arith_Less = 20;
  const int Arith_GreatEqual = 21;
  const int Arith_Great = 22;
  const int Arith_DEqual = 23;
  const int Arith_NEqual = 24;
  const int Arith_DAmp = 25;
  const int Arith_DPipe = 26;
  const int Arith_Bang = 27;
  const int Arith_DGreat = 28;
  const int Arith_DLess = 29;
  const int Arith_Amp = 30;
  const int Arith_Pipe = 31;
  const int Arith_Caret = 32;
  const int Arith_Tilde = 33;
  const int Arith_Equal = 34;
  const int Arith_PlusEqual = 35;
  const int Arith_MinusEqual = 36;
  const int Arith_StarEqual = 37;
  const int Arith_SlashEqual = 38;
  const int Arith_PercentEqual = 39;
  const int Arith_DGreatEqual = 40;
  const int Arith_DLessEqual = 41;
  const int Arith_AmpEqual = 42;
  const int Arith_PipeEqual = 43;
  const int Arith_CaretEqual = 44;
  const int Eof_Real = 45;
  const int Eof_RParen = 46;
  const int Eof_Backtick = 47;
  const int Undefined_Tok = 48;
  const int Unknown_Tok = 49;
  const int Unknown_Backslash = 50;
  const int Eol_Tok = 51;
  const int Ignored_LineCont = 52;
  const int Ignored_Space = 53;
  const int Ignored_Comment = 54;
  const int WS_Space = 55;
  const int Lit_Chars = 56;
  const int Lit_VarLike = 57;
  const int Lit_ArrayLhsOpen = 58;
  const int Lit_ArrayLhsClose = 59;
  const int Lit_Splice = 60;
  const int Lit_AtLBraceDot = 61;
  const int Lit_Other = 62;
  const int Lit_EscapedChar = 63;
  const int Lit_RegexMeta = 64;
  const int Lit_LBracket = 65;
  const int Lit_RBracket = 66;
  const int Lit_Star = 67;
  const int Lit_QMark = 68;
  const int Lit_LBrace = 69;
  const int Lit_RBrace = 70;
  const int Lit_Comma = 71;
  const int Lit_Equals = 72;
  const int Lit_Underscore = 73;
  const int Lit_Dollar = 74;
  const int Lit_DRightBracket = 75;
  const int Lit_TildeLike = 76;
  const int Lit_Pound = 77;
  const int Lit_TPound = 78;
  const int Lit_TDot = 79;
  const int Lit_Slash = 80;
  const int Lit_Percent = 81;
  const int Lit_Colon = 82;
  const int Lit_Digits = 83;
  const int Lit_At = 84;
  const int Lit_ArithVarLike = 85;
  const int Lit_BadBackslash = 86;
  const int Lit_CompDummy = 87;
  const int Backtick_Right = 88;
  const int Backtick_Quoted = 89;
  const int Backtick_Other = 90;
  const int History_Op = 91;
  const int History_Num = 92;
  const int History_Search = 93;
  const int History_Other = 94;
  const int Op_Newline = 95;
  const int Op_Amp = 96;
  const int Op_Pipe = 97;
  const int Op_PipeAmp = 98;
  const int Op_DAmp = 99;
  const int Op_DPipe = 100;
  const int Op_Semi = 101;
  const int Op_DSemi = 102;
  const int Op_LParen = 103;
  const int Op_RParen = 104;
  const int Op_DLeftParen = 105;
  const int Op_DRightParen = 106;
  const int Op_Less = 107;
  const int Op_Great = 108;
  const int Op_Bang = 109;
  const int Op_LBracket = 110;
  const int Op_RBracket = 111;
  const int Op_LBrace = 112;
  const int Op_RBrace = 113;
  const int Expr_Reserved = 114;
  const int Expr_Symbol = 115;
  const int Expr_Name = 116;
  const int Expr_DecInt = 117;
  const int Expr_BinInt = 118;
  const int Expr_OctInt = 119;
  const int Expr_HexInt = 120;
  const int Expr_Float = 121;
  const int Expr_Bang = 122;
  const int Expr_Dot = 123;
  const int Expr_DColon = 124;
  const int Expr_RArrow = 125;
  const int Expr_RDArrow = 126;
  const int Expr_DSlash = 127;
  const int Expr_TEqual = 128;
  const int Expr_NotDEqual = 129;
  const int Expr_TildeDEqual = 130;
  const int Expr_At = 131;
  const int Expr_DoubleAt = 132;
  const int Expr_Ellipsis = 133;
  const int Expr_Dollar = 134;
  const int Expr_NotTilde = 135;
  const int Expr_DTilde = 136;
  const int Expr_NotDTilde = 137;
  const int Expr_CastedDummy = 138;
  const int Expr_Null = 139;
  const int Expr_True = 140;
  const int Expr_False = 141;
  const int Expr_And = 142;
  const int Expr_Or = 143;
  const int Expr_Not = 144;
  const int Expr_For = 145;
  const int Expr_Is = 146;
  const int Expr_In = 147;
  const int Expr_If = 148;
  const int Expr_Else = 149;
  const int Expr_Func = 150;
  const int Expr_As = 151;
  const int Expr_Virtual = 152;
  const int Expr_Override = 153;
  const int Expr_Abstract = 154;
  const int Expr_While = 155;
  const int Expr_Break = 156;
  const int Expr_Continue = 157;
  const int Expr_Return = 158;
  const int Char_OneChar = 159;
  const int Char_Stop = 160;
  const int Char_Hex = 161;
  const int Char_Octal3 = 162;
  const int Char_Octal4 = 163;
  const int Char_Unicode4 = 164;
  const int Char_Unicode8 = 165;
  const int Char_UBraced = 166;
  const int Char_Pound = 167;
  const int Char_Literals = 168;
  const int Re_Start = 169;
  const int Re_End = 170;
  const int Re_Dot = 171;
  const int Redir_Less = 172;
  const int Redir_Great = 173;
  const int Redir_DLess = 174;
  const int Redir_TLess = 175;
  const int Redir_DGreat = 176;
  const int Redir_GreatAnd = 177;
  const int Redir_LessAnd = 178;
  const int Redir_DLessDash = 179;
  const int Redir_LessGreat = 180;
  const int Redir_Clobber = 181;
  const int Redir_AndGreat = 182;
  const int Redir_AndDGreat = 183;
  const int Redir_GreatPlus = 184;
  const int Redir_DGreatPlus = 185;
  const int Left_DoubleQuote = 186;
  const int Left_SingleQuote = 187;
  const int Left_RSingleQuote = 188;
  const int Left_DollarSingleQuote = 189;
  const int Left_TDoubleQuote = 190;
  const int Left_TSingleQuote = 191;
  const int Left_RTSingleQuote = 192;
  const int Left_DollarTSingleQuote = 193;
  const int Left_Backtick = 194;
  const int Left_DollarParen = 195;
  const int Left_DollarBrace = 196;
  const int Left_DollarDParen = 197;
  const int Left_DollarBracket = 198;
  const int Left_DollarDoubleQuote = 199;
  const int Left_ProcSubIn = 200;
  const int Left_ProcSubOut = 201;
  const int Left_AtParen = 202;
  const int Left_CaretParen = 203;
  const int Left_CaretBracket = 204;
  const int Left_CaretBrace = 205;
  const int Left_PercentParen = 206;
  const int Right_DoubleQuote = 207;
  const int Right_SingleQuote = 208;
  const int Right_Backtick = 209;
  const int Right_DollarBrace = 210;
  const int Right_DollarDParen = 211;
  const int Right_DollarDoubleQuote = 212;
  const int Right_DollarSingleQuote = 213;
  const int Right_Subshell = 214;
  const int Right_ShFunction = 215;
  const int Right_CasePat = 216;
  const int Right_ShArrayLiteral = 217;
  const int Right_ExtGlob = 218;
  const int Right_BlockLiteral = 219;
  const int ExtGlob_Comma = 220;
  const int ExtGlob_At = 221;
  const int ExtGlob_Star = 222;
  const int ExtGlob_Plus = 223;
  const int ExtGlob_QMark = 224;
  const int ExtGlob_Bang = 225;
  const int VSub_DollarName = 226;
  const int VSub_Name = 227;
  const int VSub_Number = 228;
  const int VSub_Bang = 229;
  const int VSub_At = 230;
  const int VSub_Pound = 231;
  const int VSub_Dollar = 232;
  const int VSub_Star = 233;
  const int VSub_Hyphen = 234;
  const int VSub_QMark = 235;
  const int VSub_Dot = 236;
  const int VTest_ColonHyphen = 237;
  const int VTest_Hyphen = 238;
  const int VTest_ColonEquals = 239;
  const int VTest_Equals = 240;
  const int VTest_ColonQMark = 241;
  const int VTest_QMark = 242;
  const int VTest_ColonPlus = 243;
  const int VTest_Plus = 244;
  const int VOp0_Q = 245;
  const int VOp0_E = 246;
  const int VOp0_P = 247;
  const int VOp0_A = 248;
  const int VOp0_a = 249;
  const int VOp1_Percent = 250;
  const int VOp1_DPercent = 251;
  const int VOp1_Pound = 252;
  const int VOp1_DPound = 253;
  const int VOp1_Caret = 254;
  const int VOp1_DCaret = 255;
  const int VOp1_Comma = 256;
  const int VOp1_DComma = 257;
  const int VOpOil_Pipe = 258;
  const int VOpOil_Space = 259;
  const int VOp2_Slash = 260;
  const int VOp2_Colon = 261;
  const int VOp2_LBracket = 262;
  const int VOp2_RBracket = 263;
  const int VOp3_At = 264;
  const int VOp3_Star = 265;
  const int Node_PostDPlus = 266;
  const int Node_PostDMinus = 267;
  const int Node_UnaryPlus = 268;
  const int Node_UnaryMinus = 269;
  const int Node_NotIn = 270;
  const int Node_IsNot = 271;
  const int KW_DLeftBracket = 272;
  const int KW_Bang = 273;
  const int KW_For = 274;
  const int KW_While = 275;
  const int KW_Until = 276;
  const int KW_Do = 277;
  const int KW_Done = 278;
  const int KW_In = 279;
  const int KW_Case = 280;
  const int KW_Esac = 281;
  const int KW_If = 282;
  const int KW_Fi = 283;
  const int KW_Then = 284;
  const int KW_Else = 285;
  const int KW_Elif = 286;
  const int KW_Function = 287;
  const int KW_Time = 288;
  const int KW_Const = 289;
  const int KW_Var = 290;
  const int KW_SetVar = 291;
  const int KW_SetRef = 292;
  const int KW_SetGlobal = 293;
  const int KW_Proc = 294;
  const int KW_Func = 295;
  const int KW_Data = 296;
  const int KW_Enum = 297;
  const int KW_Class = 298;
  const int KW_Import = 299;
  const int ControlFlow_Break = 300;
  const int ControlFlow_Continue = 301;
  const int ControlFlow_Return = 302;
  const int ControlFlow_Exit = 303;
  const int Glob_LBracket = 304;
  const int Glob_RBracket = 305;
  const int Glob_Star = 306;
  const int Glob_QMark = 307;
  const int Glob_Bang = 308;
  const int Glob_Caret = 309;
  const int Glob_EscapedChar = 310;
  const int Glob_BadBackslash = 311;
  const int Glob_CleanLiterals = 312;
  const int Glob_OtherLiteral = 313;
  const int Format_EscapedPercent = 314;
  const int Format_Percent = 315;
  const int Format_Flag = 316;
  const int Format_Num = 317;
  const int Format_Dot = 318;
  const int Format_Type = 319;
  const int Format_Star = 320;
  const int Format_Time = 321;
  const int Format_Zero = 322;
  const int PS_Subst = 323;
  const int PS_Octal3 = 324;
  const int PS_LBrace = 325;
  const int PS_RBrace = 326;
  const int PS_Literals = 327;
  const int PS_BadBackslash = 328;
  const int Range_Int = 329;
  const int Range_Char = 330;
  const int Range_Dots = 331;
  const int Range_Other = 332;
  const int QSN_LiteralBytes = 333;
  const int QSN_SpecialByte = 334;
  const int QSN_Begin2 = 335;
  const int QSN_Begin3 = 336;
  const int QSN_Begin4 = 337;
  const int QSN_Cont = 338;
  const int BoolUnary_z = 339;
  const int BoolUnary_n = 340;
  const int BoolUnary_o = 341;
  const int BoolUnary_t = 342;
  const int BoolUnary_v = 343;
  const int BoolUnary_R = 344;
  const int BoolUnary_a = 345;
  const int BoolUnary_b = 346;
  const int BoolUnary_c = 347;
  const int BoolUnary_d = 348;
  const int BoolUnary_e = 349;
  const int BoolUnary_f = 350;
  const int BoolUnary_g = 351;
  const int BoolUnary_h = 352;
  const int BoolUnary_k = 353;
  const int BoolUnary_L = 354;
  const int BoolUnary_p = 355;
  const int BoolUnary_r = 356;
  const int BoolUnary_s = 357;
  const int BoolUnary_S = 358;
  const int BoolUnary_u = 359;
  const int BoolUnary_w = 360;
  const int BoolUnary_x = 361;
  const int BoolUnary_O = 362;
  const int BoolUnary_G = 363;
  const int BoolUnary_N = 364;
  const int BoolBinary_GlobEqual = 365;
  const int BoolBinary_GlobDEqual = 366;
  const int BoolBinary_GlobNEqual = 367;
  const int BoolBinary_EqualTilde = 368;
  const int BoolBinary_ef = 369;
  const int BoolBinary_nt = 370;
  const int BoolBinary_ot = 371;
  const int BoolBinary_eq = 372;
  const int BoolBinary_ne = 373;
  const int BoolBinary_gt = 374;
  const int BoolBinary_ge = 375;
  const int BoolBinary_lt = 376;
  const int BoolBinary_le = 377;
  const int BoolBinary_Equal = 378;
  const int BoolBinary_DEqual = 379;
  const int BoolBinary_NEqual = 380;
  const int ARRAY_SIZE = 381;
};

const char* Id_str(int tag);

typedef int Id_t;

enum class Kind {
  Word = 1,
  Arith = 2,
  Eof = 3,
  Undefined = 4,
  Unknown = 5,
  Eol = 6,
  Ignored = 7,
  WS = 8,
  Lit = 9,
  Backtick = 10,
  History = 11,
  Op = 12,
  Expr = 13,
  Char = 14,
  Re = 15,
  Redir = 16,
  Left = 17,
  Right = 18,
  ExtGlob = 19,
  VSub = 20,
  VTest = 21,
  VOp0 = 22,
  VOp1 = 23,
  VOpOil = 24,
  VOp2 = 25,
  VOp3 = 26,
  Node = 27,
  KW = 28,
  ControlFlow = 29,
  Glob = 30,
  Format = 31,
  PS = 32,
  Range = 33,
  QSN = 34,
  BoolUnary = 35,
  BoolBinary = 36,
};
typedef Kind Kind_t;

const char* Kind_str(Kind tag);


}  // namespace id_kind_asdl

#endif  // ID_KIND_ASDL_H
