// _build/cpp/syntax_asdl.h is generated by asdl/tool.py

#ifndef SYNTAX_ASDL
#define SYNTAX_ASDL

#include <cstdint>

#include "mylib.h"  // for old Str, List, etc.
#include "hnode_asdl.h"
using hnode_asdl::hnode_t;

#include "id_kind_asdl.h"
using id_kind_asdl::Id_t;

namespace syntax_asdl {

class parse_result_t;
class source_t;
class line_span;
class Token;
class speck;
class bracket_op_t;
class suffix_op_t;
class double_quoted;
class single_quoted;
class simple_var_sub;
class braced_var_sub;
class command_sub;
class sh_array_literal;
class arg_list;
class word_part_t;
class compound_word;
class string_line;
class triple_quoted;
class word_t;
class sh_lhs_expr_t;
class arith_expr_t;
class bool_expr_t;
class redir_loc_t;
class redir_param_t;
class redir;
class assign_pair;
class env_pair;
class condition_t;
class case_arm;
class if_arm;
class BraceGroup;
class command_t;
class variant_type_t;
class variant;
class class_item_t;
class import_name;
class proc_sig_t;
class param;
class glob_part_t;
class printf_part_t;
class type_expr_t;
class name_type;
class comprehension;
class named_arg;
class subscript;
class attribute;
class place_expr_t;
class expr_t;
class posix_class;
class perl_class;
class class_literal_term_t;
class re_repeat_t;
class re_t;

namespace parse_result_e {
  const int EmptyLine = 1;
  const int Eof = 2;
  const int Node = 3;
};

const char* parse_result_str(int tag);

class parse_result_t {
 protected:
  parse_result_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(parse_result_t)
};

class parse_result__EmptyLine : public parse_result_t {
 public:
  parse_result__EmptyLine() :
                          type_tag_(static_cast<uint16_t>(parse_result_e::EmptyLine)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(parse_result__EmptyLine)
};

class parse_result__Eof : public parse_result_t {
 public:
  parse_result__Eof() : type_tag_(static_cast<uint16_t>(parse_result_e::Eof)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(parse_result__Eof)
};

class parse_result__Node : public parse_result_t {
 public:
  parse_result__Node() :
                     type_tag_(static_cast<uint16_t>(parse_result_e::Node)),
                     cmd(nullptr) {
  }
  parse_result__Node(command_t* cmd) :
                     type_tag_(static_cast<uint16_t>(parse_result_e::Node)),
                     cmd(cmd) {
  }
  OBJ_HEADER();
  command_t* cmd;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(parse_result__Node)
};

namespace parse_result {
  typedef parse_result__EmptyLine EmptyLine;
  typedef parse_result__Eof Eof;
  typedef parse_result__Node Node;
}

namespace source_e {
  const int Interactive = 1;
  const int Headless = 2;
  const int Unused = 3;
  const int CFlag = 4;
  const int Stdin = 5;
  const int MainFile = 6;
  const int SourcedFile = 7;
  const int ArgvWord = 8;
  const int Variable = 9;
  const int Alias = 10;
  const int Reparsed = 11;
};

const char* source_str(int tag);

class source_t {
 protected:
  source_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(source_t)
};

class source__Interactive : public source_t {
 public:
  source__Interactive() :
                      type_tag_(static_cast<uint16_t>(source_e::Interactive)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Interactive)
};

class source__Headless : public source_t {
 public:
  source__Headless() : type_tag_(static_cast<uint16_t>(source_e::Headless)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Headless)
};

class source__Unused : public source_t {
 public:
  source__Unused() : type_tag_(static_cast<uint16_t>(source_e::Unused)),
                 comment(new Str("")) {
  }
  source__Unused(Str* comment) :
                 type_tag_(static_cast<uint16_t>(source_e::Unused)),
                 comment(comment) {
  }
  OBJ_HEADER();
  Str* comment;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Unused)
};

class source__CFlag : public source_t {
 public:
  source__CFlag() : type_tag_(static_cast<uint16_t>(source_e::CFlag)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__CFlag)
};

class source__Stdin : public source_t {
 public:
  source__Stdin() : type_tag_(static_cast<uint16_t>(source_e::Stdin)),
                comment(new Str("")) {
  }
  source__Stdin(Str* comment) :
                type_tag_(static_cast<uint16_t>(source_e::Stdin)),
                comment(comment) {
  }
  OBJ_HEADER();
  Str* comment;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Stdin)
};

class source__MainFile : public source_t {
 public:
  source__MainFile() : type_tag_(static_cast<uint16_t>(source_e::MainFile)),
                   path(new Str("")) {
  }
  source__MainFile(Str* path) :
                   type_tag_(static_cast<uint16_t>(source_e::MainFile)),
                   path(path) {
  }
  OBJ_HEADER();
  Str* path;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__MainFile)
};

class source__SourcedFile : public source_t {
 public:
  source__SourcedFile() :
                      type_tag_(static_cast<uint16_t>(source_e::SourcedFile)),
                      path(new Str("")), spid(-1) {
  }
  source__SourcedFile(Str* path, int spid) :
                      type_tag_(static_cast<uint16_t>(source_e::SourcedFile)),
                      path(path), spid(spid) {
  }
  OBJ_HEADER();
  Str* path;
  int spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__SourcedFile)
};

class source__ArgvWord : public source_t {
 public:
  source__ArgvWord() : type_tag_(static_cast<uint16_t>(source_e::ArgvWord)),
                   what(new Str("")), span_id(-1) {
  }
  source__ArgvWord(Str* what, int span_id) :
                   type_tag_(static_cast<uint16_t>(source_e::ArgvWord)),
                   what(what), span_id(span_id) {
  }
  OBJ_HEADER();
  Str* what;
  int span_id;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__ArgvWord)
};

class source__Variable : public source_t {
 public:
  source__Variable() : type_tag_(static_cast<uint16_t>(source_e::Variable)),
                   var_name(new Str("")), spid(-1) {
  }
  source__Variable(Str* var_name, int spid) :
                   type_tag_(static_cast<uint16_t>(source_e::Variable)),
                   var_name(var_name), spid(spid) {
  }
  OBJ_HEADER();
  Str* var_name;
  int spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Variable)
};

class source__Alias : public source_t {
 public:
  source__Alias() : type_tag_(static_cast<uint16_t>(source_e::Alias)),
                argv0(new Str("")), argv0_spid(-1) {
  }
  source__Alias(Str* argv0, int argv0_spid) :
                type_tag_(static_cast<uint16_t>(source_e::Alias)),
                argv0(argv0), argv0_spid(argv0_spid) {
  }
  OBJ_HEADER();
  Str* argv0;
  int argv0_spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Alias)
};

class source__Reparsed : public source_t {
 public:
  source__Reparsed() : type_tag_(static_cast<uint16_t>(source_e::Reparsed)),
                   what(new Str("")), left_spid(-1), right_spid(-1) {
  }
  source__Reparsed(Str* what, int left_spid, int right_spid) :
                   type_tag_(static_cast<uint16_t>(source_e::Reparsed)),
                   what(what), left_spid(left_spid), right_spid(right_spid) {
  }
  OBJ_HEADER();
  Str* what;
  int left_spid;
  int right_spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(source__Reparsed)
};

namespace source {
  typedef source__Interactive Interactive;
  typedef source__Headless Headless;
  typedef source__Unused Unused;
  typedef source__CFlag CFlag;
  typedef source__Stdin Stdin;
  typedef source__MainFile MainFile;
  typedef source__SourcedFile SourcedFile;
  typedef source__ArgvWord ArgvWord;
  typedef source__Variable Variable;
  typedef source__Alias Alias;
  typedef source__Reparsed Reparsed;
}

namespace bracket_op_e {
  const int WholeArray = 1;
  const int ArrayIndex = 2;
};

const char* bracket_op_str(int tag);

class bracket_op_t {
 protected:
  bracket_op_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(bracket_op_t)
};

class bracket_op__WholeArray : public bracket_op_t {
 public:
  bracket_op__WholeArray() :
                         type_tag_(static_cast<uint16_t>(bracket_op_e::WholeArray)), op_id(-1) {
  }
  bracket_op__WholeArray(Id_t op_id) :
                         type_tag_(static_cast<uint16_t>(bracket_op_e::WholeArray)), op_id(op_id) {
  }
  OBJ_HEADER();
  Id_t op_id;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bracket_op__WholeArray)
};

class bracket_op__ArrayIndex : public bracket_op_t {
 public:
  bracket_op__ArrayIndex() :
                         type_tag_(static_cast<uint16_t>(bracket_op_e::ArrayIndex)), expr(nullptr) {
  }
  bracket_op__ArrayIndex(arith_expr_t* expr) :
                         type_tag_(static_cast<uint16_t>(bracket_op_e::ArrayIndex)), expr(expr) {
  }
  OBJ_HEADER();
  arith_expr_t* expr;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bracket_op__ArrayIndex)
};

namespace bracket_op {
  typedef bracket_op__WholeArray WholeArray;
  typedef bracket_op__ArrayIndex ArrayIndex;
}

namespace suffix_op_e {
  const int Nullary = 201;
  const int Unary = 2;
  const int Static = 3;
  const int PatSub = 4;
  const int Slice = 5;
};

const char* suffix_op_str(int tag);

class suffix_op_t {
 protected:
  suffix_op_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(suffix_op_t)
};

class suffix_op__Unary : public suffix_op_t {
 public:
  suffix_op__Unary() : type_tag_(static_cast<uint16_t>(suffix_op_e::Unary)),
                   tok(nullptr), arg_word(nullptr), spids(new List<int>()) {
  }
  suffix_op__Unary(Token* tok, word_t* arg_word) :
                   type_tag_(static_cast<uint16_t>(suffix_op_e::Unary)),
                   tok(tok), arg_word(arg_word), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* tok;
  word_t* arg_word;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(suffix_op__Unary)
};

class suffix_op__Static : public suffix_op_t {
 public:
  suffix_op__Static() : type_tag_(static_cast<uint16_t>(suffix_op_e::Static)),
                    tok(nullptr), arg(new Str("")), spids(new List<int>()) {
  }
  suffix_op__Static(Token* tok, Str* arg) :
                    type_tag_(static_cast<uint16_t>(suffix_op_e::Static)),
                    tok(tok), arg(arg), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* tok;
  Str* arg;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(suffix_op__Static)
};

class suffix_op__PatSub : public suffix_op_t {
 public:
  suffix_op__PatSub() : type_tag_(static_cast<uint16_t>(suffix_op_e::PatSub)),
                    pat(nullptr), replace(nullptr), replace_mode(-1), spids(new
                    List<int>()) {
  }
  suffix_op__PatSub(word_t* pat, word_t* replace, Id_t replace_mode) :
                    type_tag_(static_cast<uint16_t>(suffix_op_e::PatSub)),
                    pat(pat), replace(replace), replace_mode(replace_mode),
                    spids(new List<int>()) {
  }
  OBJ_HEADER();
  word_t* pat;
  word_t* replace;
  Id_t replace_mode;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(suffix_op__PatSub)
};

class suffix_op__Slice : public suffix_op_t {
 public:
  suffix_op__Slice() : type_tag_(static_cast<uint16_t>(suffix_op_e::Slice)),
                   begin(nullptr), length(nullptr), spids(new List<int>()) {
  }
  suffix_op__Slice(arith_expr_t* begin, arith_expr_t* length) :
                   type_tag_(static_cast<uint16_t>(suffix_op_e::Slice)),
                   begin(begin), length(length), spids(new List<int>()) {
  }
  OBJ_HEADER();
  arith_expr_t* begin;
  arith_expr_t* length;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(suffix_op__Slice)
};

namespace suffix_op {
  typedef suffix_op__Unary Unary;
  typedef suffix_op__Static Static;
  typedef suffix_op__PatSub PatSub;
  typedef suffix_op__Slice Slice;
}

namespace word_part_e {
  const int ShArrayLiteral = 208;
  const int AssocArrayLiteral = 2;
  const int Literal = 201;
  const int EscapedLiteral = 4;
  const int SingleQuoted = 204;
  const int DoubleQuoted = 203;
  const int SimpleVarSub = 205;
  const int BracedVarSub = 206;
  const int CommandSub = 207;
  const int TildeSub = 10;
  const int ArithSub = 11;
  const int BracedTuple = 12;
  const int BracedRange = 13;
  const int ExtGlob = 14;
  const int Splice = 15;
  const int FuncCall = 16;
  const int ExprSub = 17;
};

const char* word_part_str(int tag);

class word_part_t {
 protected:
  word_part_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(word_part_t)
};

class word_part__AssocArrayLiteral : public word_part_t {
 public:
  word_part__AssocArrayLiteral() :
                               type_tag_(static_cast<uint16_t>(word_part_e::AssocArrayLiteral)), left(nullptr), pairs(new List<compound_word*>()), spids(new List<int>()) {
  }
  word_part__AssocArrayLiteral(Token* left, List<compound_word*>* pairs) :
                               type_tag_(static_cast<uint16_t>(word_part_e::AssocArrayLiteral)), left(left), pairs(pairs), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  List<compound_word*>* pairs;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__AssocArrayLiteral)
};

class word_part__EscapedLiteral : public word_part_t {
 public:
  word_part__EscapedLiteral() :
                            type_tag_(static_cast<uint16_t>(word_part_e::EscapedLiteral)), token(nullptr), spids(new List<int>()) {
  }
  word_part__EscapedLiteral(Token* token) :
                            type_tag_(static_cast<uint16_t>(word_part_e::EscapedLiteral)), token(token), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* token;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__EscapedLiteral)
};

class word_part__TildeSub : public word_part_t {
 public:
  word_part__TildeSub() :
                      type_tag_(static_cast<uint16_t>(word_part_e::TildeSub)),
                      token(nullptr), spids(new List<int>()) {
  }
  word_part__TildeSub(Token* token) :
                      type_tag_(static_cast<uint16_t>(word_part_e::TildeSub)),
                      token(token), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* token;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__TildeSub)
};

class word_part__ArithSub : public word_part_t {
 public:
  word_part__ArithSub() :
                      type_tag_(static_cast<uint16_t>(word_part_e::ArithSub)),
                      anode(nullptr), spids(new List<int>()) {
  }
  word_part__ArithSub(arith_expr_t* anode) :
                      type_tag_(static_cast<uint16_t>(word_part_e::ArithSub)),
                      anode(anode), spids(new List<int>()) {
  }
  OBJ_HEADER();
  arith_expr_t* anode;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__ArithSub)
};

class word_part__BracedTuple : public word_part_t {
 public:
  word_part__BracedTuple() :
                         type_tag_(static_cast<uint16_t>(word_part_e::BracedTuple)), words(new List<compound_word*>()), spids(new List<int>()) {
  }
  word_part__BracedTuple(List<compound_word*>* words) :
                         type_tag_(static_cast<uint16_t>(word_part_e::BracedTuple)), words(words), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<compound_word*>* words;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__BracedTuple)
};

class word_part__BracedRange : public word_part_t {
 public:
  word_part__BracedRange() :
                         type_tag_(static_cast<uint16_t>(word_part_e::BracedRange)), kind(-1), start(new Str("")), end(new Str("")), step(-1), spids(new List<int>()) {
  }
  word_part__BracedRange(Id_t kind, Str* start, Str* end, int step) :
                         type_tag_(static_cast<uint16_t>(word_part_e::BracedRange)), kind(kind), start(start), end(end), step(step), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Id_t kind;
  Str* start;
  Str* end;
  int step;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__BracedRange)
};

class word_part__ExtGlob : public word_part_t {
 public:
  word_part__ExtGlob() :
                     type_tag_(static_cast<uint16_t>(word_part_e::ExtGlob)),
                     op(nullptr), arms(new List<compound_word*>()), spids(new
                     List<int>()) {
  }
  word_part__ExtGlob(Token* op, List<compound_word*>* arms) :
                     type_tag_(static_cast<uint16_t>(word_part_e::ExtGlob)),
                     op(op), arms(arms), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* op;
  List<compound_word*>* arms;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__ExtGlob)
};

class word_part__Splice : public word_part_t {
 public:
  word_part__Splice() : type_tag_(static_cast<uint16_t>(word_part_e::Splice)),
                    name(nullptr), spids(new List<int>()) {
  }
  word_part__Splice(Token* name) :
                    type_tag_(static_cast<uint16_t>(word_part_e::Splice)),
                    name(name), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__Splice)
};

class word_part__FuncCall : public word_part_t {
 public:
  word_part__FuncCall() :
                      type_tag_(static_cast<uint16_t>(word_part_e::FuncCall)),
                      name(nullptr), args(nullptr), spids(new List<int>()) {
  }
  word_part__FuncCall(Token* name, arg_list* args) :
                      type_tag_(static_cast<uint16_t>(word_part_e::FuncCall)),
                      name(name), args(args), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  arg_list* args;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__FuncCall)
};

class word_part__ExprSub : public word_part_t {
 public:
  word_part__ExprSub() :
                     type_tag_(static_cast<uint16_t>(word_part_e::ExprSub)),
                     left(nullptr), child(nullptr), spids(new List<int>()) {
  }
  word_part__ExprSub(Token* left, expr_t* child) :
                     type_tag_(static_cast<uint16_t>(word_part_e::ExprSub)),
                     left(left), child(child), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  expr_t* child;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word_part__ExprSub)
};

namespace word_part {
  typedef word_part__AssocArrayLiteral AssocArrayLiteral;
  typedef word_part__EscapedLiteral EscapedLiteral;
  typedef word_part__TildeSub TildeSub;
  typedef word_part__ArithSub ArithSub;
  typedef word_part__BracedTuple BracedTuple;
  typedef word_part__BracedRange BracedRange;
  typedef word_part__ExtGlob ExtGlob;
  typedef word_part__Splice Splice;
  typedef word_part__FuncCall FuncCall;
  typedef word_part__ExprSub ExprSub;
}

namespace word_e {
  const int Empty = 1;
  const int Token = 201;
  const int Compound = 210;
  const int BracedTree = 4;
  const int String = 5;
};

const char* word_str(int tag);

class word_t {
 protected:
  word_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(word_t)
};

class word__Empty : public word_t {
 public:
  word__Empty() : type_tag_(static_cast<uint16_t>(word_e::Empty)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word__Empty)
};

class word__BracedTree : public word_t {
 public:
  word__BracedTree() : type_tag_(static_cast<uint16_t>(word_e::BracedTree)),
                   parts(new List<word_part_t*>()) {
  }
  word__BracedTree(List<word_part_t*>* parts) :
                   type_tag_(static_cast<uint16_t>(word_e::BracedTree)),
                   parts(parts) {
  }
  OBJ_HEADER();
  List<word_part_t*>* parts;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word__BracedTree)
};

class word__String : public word_t {
 public:
  word__String() : type_tag_(static_cast<uint16_t>(word_e::String)), id(-1),
               s(new Str("")), span_id(-1) {
  }
  word__String(Id_t id, Str* s, int span_id) :
               type_tag_(static_cast<uint16_t>(word_e::String)), id(id), s(s),
               span_id(span_id) {
  }
  OBJ_HEADER();
  Id_t id;
  Str* s;
  int span_id;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(word__String)
};

namespace word {
  typedef word__Empty Empty;
  typedef word__BracedTree BracedTree;
  typedef word__String String;
}

namespace sh_lhs_expr_e {
  const int Name = 1;
  const int IndexedName = 2;
  const int UnparsedIndex = 3;
};

const char* sh_lhs_expr_str(int tag);

class sh_lhs_expr_t {
 protected:
  sh_lhs_expr_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(sh_lhs_expr_t)
};

class sh_lhs_expr__Name : public sh_lhs_expr_t {
 public:
  sh_lhs_expr__Name() : type_tag_(static_cast<uint16_t>(sh_lhs_expr_e::Name)),
                    name(new Str("")), spids(new List<int>()) {
  }
  sh_lhs_expr__Name(Str* name) :
                    type_tag_(static_cast<uint16_t>(sh_lhs_expr_e::Name)),
                    name(name), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Str* name;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(sh_lhs_expr__Name)
};

class sh_lhs_expr__IndexedName : public sh_lhs_expr_t {
 public:
  sh_lhs_expr__IndexedName() :
                           type_tag_(static_cast<uint16_t>(sh_lhs_expr_e::IndexedName)), name(new Str("")), index(nullptr), spids(new List<int>()) {
  }
  sh_lhs_expr__IndexedName(Str* name, arith_expr_t* index) :
                           type_tag_(static_cast<uint16_t>(sh_lhs_expr_e::IndexedName)), name(name), index(index), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Str* name;
  arith_expr_t* index;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(sh_lhs_expr__IndexedName)
};

class sh_lhs_expr__UnparsedIndex : public sh_lhs_expr_t {
 public:
  sh_lhs_expr__UnparsedIndex() :
                             type_tag_(static_cast<uint16_t>(sh_lhs_expr_e::UnparsedIndex)), name(new Str("")), index(new Str("")), spids(new List<int>()) {
  }
  sh_lhs_expr__UnparsedIndex(Str* name, Str* index) :
                             type_tag_(static_cast<uint16_t>(sh_lhs_expr_e::UnparsedIndex)), name(name), index(index), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Str* name;
  Str* index;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(sh_lhs_expr__UnparsedIndex)
};

namespace sh_lhs_expr {
  typedef sh_lhs_expr__Name Name;
  typedef sh_lhs_expr__IndexedName IndexedName;
  typedef sh_lhs_expr__UnparsedIndex UnparsedIndex;
}

namespace arith_expr_e {
  const int VarRef = 201;
  const int Word = 210;
  const int UnaryAssign = 3;
  const int BinaryAssign = 4;
  const int Unary = 5;
  const int Binary = 6;
  const int TernaryOp = 7;
};

const char* arith_expr_str(int tag);

class arith_expr_t {
 protected:
  arith_expr_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(arith_expr_t)
};

class arith_expr__UnaryAssign : public arith_expr_t {
 public:
  arith_expr__UnaryAssign() :
                          type_tag_(static_cast<uint16_t>(arith_expr_e::UnaryAssign)), op_id(-1), child(nullptr) {
  }
  arith_expr__UnaryAssign(Id_t op_id, arith_expr_t* child) :
                          type_tag_(static_cast<uint16_t>(arith_expr_e::UnaryAssign)), op_id(op_id), child(child) {
  }
  OBJ_HEADER();
  Id_t op_id;
  arith_expr_t* child;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(arith_expr__UnaryAssign)
};

class arith_expr__BinaryAssign : public arith_expr_t {
 public:
  arith_expr__BinaryAssign() :
                           type_tag_(static_cast<uint16_t>(arith_expr_e::BinaryAssign)), op_id(-1), left(nullptr), right(nullptr) {
  }
  arith_expr__BinaryAssign(Id_t op_id, arith_expr_t* left, arith_expr_t* right)
                           :
                           type_tag_(static_cast<uint16_t>(arith_expr_e::BinaryAssign)), op_id(op_id), left(left), right(right) {
  }
  OBJ_HEADER();
  Id_t op_id;
  arith_expr_t* left;
  arith_expr_t* right;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(arith_expr__BinaryAssign)
};

class arith_expr__Unary : public arith_expr_t {
 public:
  arith_expr__Unary() : type_tag_(static_cast<uint16_t>(arith_expr_e::Unary)),
                    op_id(-1), child(nullptr) {
  }
  arith_expr__Unary(Id_t op_id, arith_expr_t* child) :
                    type_tag_(static_cast<uint16_t>(arith_expr_e::Unary)),
                    op_id(op_id), child(child) {
  }
  OBJ_HEADER();
  Id_t op_id;
  arith_expr_t* child;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(arith_expr__Unary)
};

class arith_expr__Binary : public arith_expr_t {
 public:
  arith_expr__Binary() :
                     type_tag_(static_cast<uint16_t>(arith_expr_e::Binary)),
                     op_id(-1), left(nullptr), right(nullptr) {
  }
  arith_expr__Binary(Id_t op_id, arith_expr_t* left, arith_expr_t* right) :
                     type_tag_(static_cast<uint16_t>(arith_expr_e::Binary)),
                     op_id(op_id), left(left), right(right) {
  }
  OBJ_HEADER();
  Id_t op_id;
  arith_expr_t* left;
  arith_expr_t* right;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(arith_expr__Binary)
};

class arith_expr__TernaryOp : public arith_expr_t {
 public:
  arith_expr__TernaryOp() :
                        type_tag_(static_cast<uint16_t>(arith_expr_e::TernaryOp)), cond(nullptr), true_expr(nullptr), false_expr(nullptr) {
  }
  arith_expr__TernaryOp(arith_expr_t* cond, arith_expr_t* true_expr,
                        arith_expr_t* false_expr) :
                        type_tag_(static_cast<uint16_t>(arith_expr_e::TernaryOp)), cond(cond), true_expr(true_expr), false_expr(false_expr) {
  }
  OBJ_HEADER();
  arith_expr_t* cond;
  arith_expr_t* true_expr;
  arith_expr_t* false_expr;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(arith_expr__TernaryOp)
};

namespace arith_expr {
  typedef arith_expr__UnaryAssign UnaryAssign;
  typedef arith_expr__BinaryAssign BinaryAssign;
  typedef arith_expr__Unary Unary;
  typedef arith_expr__Binary Binary;
  typedef arith_expr__TernaryOp TernaryOp;
}

namespace bool_expr_e {
  const int WordTest = 1;
  const int Binary = 2;
  const int Unary = 3;
  const int LogicalNot = 4;
  const int LogicalAnd = 5;
  const int LogicalOr = 6;
};

const char* bool_expr_str(int tag);

class bool_expr_t {
 protected:
  bool_expr_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(bool_expr_t)
};

class bool_expr__WordTest : public bool_expr_t {
 public:
  bool_expr__WordTest() :
                      type_tag_(static_cast<uint16_t>(bool_expr_e::WordTest)),
                      w(nullptr) {
  }
  bool_expr__WordTest(word_t* w) :
                      type_tag_(static_cast<uint16_t>(bool_expr_e::WordTest)),
                      w(w) {
  }
  OBJ_HEADER();
  word_t* w;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bool_expr__WordTest)
};

class bool_expr__Binary : public bool_expr_t {
 public:
  bool_expr__Binary() : type_tag_(static_cast<uint16_t>(bool_expr_e::Binary)),
                    op_id(-1), left(nullptr), right(nullptr) {
  }
  bool_expr__Binary(Id_t op_id, word_t* left, word_t* right) :
                    type_tag_(static_cast<uint16_t>(bool_expr_e::Binary)),
                    op_id(op_id), left(left), right(right) {
  }
  OBJ_HEADER();
  Id_t op_id;
  word_t* left;
  word_t* right;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bool_expr__Binary)
};

class bool_expr__Unary : public bool_expr_t {
 public:
  bool_expr__Unary() : type_tag_(static_cast<uint16_t>(bool_expr_e::Unary)),
                   op_id(-1), child(nullptr) {
  }
  bool_expr__Unary(Id_t op_id, word_t* child) :
                   type_tag_(static_cast<uint16_t>(bool_expr_e::Unary)),
                   op_id(op_id), child(child) {
  }
  OBJ_HEADER();
  Id_t op_id;
  word_t* child;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bool_expr__Unary)
};

class bool_expr__LogicalNot : public bool_expr_t {
 public:
  bool_expr__LogicalNot() :
                        type_tag_(static_cast<uint16_t>(bool_expr_e::LogicalNot)), child(nullptr) {
  }
  bool_expr__LogicalNot(bool_expr_t* child) :
                        type_tag_(static_cast<uint16_t>(bool_expr_e::LogicalNot)), child(child) {
  }
  OBJ_HEADER();
  bool_expr_t* child;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bool_expr__LogicalNot)
};

class bool_expr__LogicalAnd : public bool_expr_t {
 public:
  bool_expr__LogicalAnd() :
                        type_tag_(static_cast<uint16_t>(bool_expr_e::LogicalAnd)), left(nullptr), right(nullptr) {
  }
  bool_expr__LogicalAnd(bool_expr_t* left, bool_expr_t* right) :
                        type_tag_(static_cast<uint16_t>(bool_expr_e::LogicalAnd)), left(left), right(right) {
  }
  OBJ_HEADER();
  bool_expr_t* left;
  bool_expr_t* right;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bool_expr__LogicalAnd)
};

class bool_expr__LogicalOr : public bool_expr_t {
 public:
  bool_expr__LogicalOr() :
                       type_tag_(static_cast<uint16_t>(bool_expr_e::LogicalOr)), left(nullptr), right(nullptr) {
  }
  bool_expr__LogicalOr(bool_expr_t* left, bool_expr_t* right) :
                       type_tag_(static_cast<uint16_t>(bool_expr_e::LogicalOr)), left(left), right(right) {
  }
  OBJ_HEADER();
  bool_expr_t* left;
  bool_expr_t* right;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(bool_expr__LogicalOr)
};

namespace bool_expr {
  typedef bool_expr__WordTest WordTest;
  typedef bool_expr__Binary Binary;
  typedef bool_expr__Unary Unary;
  typedef bool_expr__LogicalNot LogicalNot;
  typedef bool_expr__LogicalAnd LogicalAnd;
  typedef bool_expr__LogicalOr LogicalOr;
}

namespace redir_loc_e {
  const int Fd = 1;
  const int VarName = 2;
};

const char* redir_loc_str(int tag);

class redir_loc_t {
 protected:
  redir_loc_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(redir_loc_t)
};

class redir_loc__Fd : public redir_loc_t {
 public:
  redir_loc__Fd() : type_tag_(static_cast<uint16_t>(redir_loc_e::Fd)), fd(-1) {
  }
  redir_loc__Fd(int fd) : type_tag_(static_cast<uint16_t>(redir_loc_e::Fd)),
                fd(fd) {
  }
  OBJ_HEADER();
  int fd;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(redir_loc__Fd)
};

class redir_loc__VarName : public redir_loc_t {
 public:
  redir_loc__VarName() :
                     type_tag_(static_cast<uint16_t>(redir_loc_e::VarName)),
                     name(new Str("")) {
  }
  redir_loc__VarName(Str* name) :
                     type_tag_(static_cast<uint16_t>(redir_loc_e::VarName)),
                     name(name) {
  }
  OBJ_HEADER();
  Str* name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(redir_loc__VarName)
};

namespace redir_loc {
  typedef redir_loc__Fd Fd;
  typedef redir_loc__VarName VarName;
}

namespace redir_param_e {
  const int Word = 210;
  const int HereDoc = 2;
};

const char* redir_param_str(int tag);

class redir_param_t {
 protected:
  redir_param_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(redir_param_t)
};

class redir_param__HereDoc : public redir_param_t {
 public:
  redir_param__HereDoc() :
                       type_tag_(static_cast<uint16_t>(redir_param_e::HereDoc)), here_begin(nullptr), here_end_span_id(-1), stdin_parts(new List<word_part_t*>()) {
  }
  redir_param__HereDoc(word_t* here_begin, int here_end_span_id,
                       List<word_part_t*>* stdin_parts) :
                       type_tag_(static_cast<uint16_t>(redir_param_e::HereDoc)), here_begin(here_begin), here_end_span_id(here_end_span_id), stdin_parts(stdin_parts) {
  }
  OBJ_HEADER();
  word_t* here_begin;
  int here_end_span_id;
  List<word_part_t*>* stdin_parts;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(redir_param__HereDoc)
};

namespace redir_param {
  typedef redir_param__HereDoc HereDoc;
}

enum class assign_op_e {
  Equal = 1,
  PlusEqual = 2,
};
typedef assign_op_e assign_op_t;

const char* assign_op_str(assign_op_e tag);

namespace condition_e {
  const int Shell = 1;
  const int Oil = 2;
};

const char* condition_str(int tag);

class condition_t {
 protected:
  condition_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(condition_t)
};

class condition__Shell : public condition_t {
 public:
  condition__Shell() : type_tag_(static_cast<uint16_t>(condition_e::Shell)),
                   commands(new List<command_t*>()) {
  }
  condition__Shell(List<command_t*>* commands) :
                   type_tag_(static_cast<uint16_t>(condition_e::Shell)),
                   commands(commands) {
  }
  OBJ_HEADER();
  List<command_t*>* commands;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(condition__Shell)
};

class condition__Oil : public condition_t {
 public:
  condition__Oil() : type_tag_(static_cast<uint16_t>(condition_e::Oil)),
                 e(nullptr) {
  }
  condition__Oil(expr_t* e) :
                 type_tag_(static_cast<uint16_t>(condition_e::Oil)), e(e) {
  }
  OBJ_HEADER();
  expr_t* e;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(condition__Oil)
};

namespace condition {
  typedef condition__Shell Shell;
  typedef condition__Oil Oil;
}

namespace command_e {
  const int NoOp = 1;
  const int Simple = 2;
  const int ExpandedAlias = 3;
  const int Sentence = 4;
  const int ShAssignment = 5;
  const int ControlFlow = 6;
  const int Pipeline = 7;
  const int AndOr = 8;
  const int DoGroup = 9;
  const int BraceGroup = 218;
  const int Subshell = 11;
  const int DParen = 12;
  const int DBracket = 13;
  const int ForEach = 14;
  const int ForExpr = 15;
  const int WhileUntil = 16;
  const int If = 17;
  const int Case = 18;
  const int ShFunction = 19;
  const int TimeBlock = 20;
  const int CommandList = 21;
  const int BareDecl = 22;
  const int VarDecl = 23;
  const int PlaceMutation = 24;
  const int Expr = 25;
  const int OilForIn = 26;
  const int Proc = 27;
  const int Func = 28;
  const int Data = 29;
  const int Enum = 30;
  const int Class = 31;
  const int Import = 32;
  const int For = 33;
  const int While = 34;
  const int Break = 35;
  const int Continue = 36;
  const int Return = 37;
};

const char* command_str(int tag);

class command_t {
 protected:
  command_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(command_t)
};

class command__NoOp : public command_t {
 public:
  command__NoOp() : type_tag_(static_cast<uint16_t>(command_e::NoOp)),
                spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__NoOp)
};

class command__Simple : public command_t {
 public:
  command__Simple() : type_tag_(static_cast<uint16_t>(command_e::Simple)),
                  words(new List<word_t*>()), redirects(new List<redir*>()),
                  more_env(new List<env_pair*>()), block(nullptr),
                  do_fork(false), spids(new List<int>()) {
  }
  command__Simple(List<word_t*>* words, List<redir*>* redirects,
                  List<env_pair*>* more_env, BraceGroup* block, bool do_fork) :
                  type_tag_(static_cast<uint16_t>(command_e::Simple)),
                  words(words), redirects(redirects), more_env(more_env),
                  block(block), do_fork(do_fork), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<word_t*>* words;
  List<redir*>* redirects;
  List<env_pair*>* more_env;
  BraceGroup* block;
  bool do_fork;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Simple)
};

class command__ExpandedAlias : public command_t {
 public:
  command__ExpandedAlias() :
                         type_tag_(static_cast<uint16_t>(command_e::ExpandedAlias)), child(nullptr), redirects(new List<redir*>()), more_env(new List<env_pair*>()), spids(new List<int>()) {
  }
  command__ExpandedAlias(command_t* child, List<redir*>* redirects,
                         List<env_pair*>* more_env) :
                         type_tag_(static_cast<uint16_t>(command_e::ExpandedAlias)), child(child), redirects(redirects), more_env(more_env), spids(new List<int>()) {
  }
  OBJ_HEADER();
  command_t* child;
  List<redir*>* redirects;
  List<env_pair*>* more_env;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__ExpandedAlias)
};

class command__Sentence : public command_t {
 public:
  command__Sentence() : type_tag_(static_cast<uint16_t>(command_e::Sentence)),
                    child(nullptr), terminator(nullptr), spids(new List<int>())
                    {
  }
  command__Sentence(command_t* child, Token* terminator) :
                    type_tag_(static_cast<uint16_t>(command_e::Sentence)),
                    child(child), terminator(terminator), spids(new
                    List<int>()) {
  }
  OBJ_HEADER();
  command_t* child;
  Token* terminator;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Sentence)
};

class command__ShAssignment : public command_t {
 public:
  command__ShAssignment() :
                        type_tag_(static_cast<uint16_t>(command_e::ShAssignment)), pairs(new List<assign_pair*>()), redirects(new List<redir*>()), spids(new List<int>()) {
  }
  command__ShAssignment(List<assign_pair*>* pairs, List<redir*>* redirects) :
                        type_tag_(static_cast<uint16_t>(command_e::ShAssignment)), pairs(pairs), redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<assign_pair*>* pairs;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__ShAssignment)
};

class command__ControlFlow : public command_t {
 public:
  command__ControlFlow() :
                       type_tag_(static_cast<uint16_t>(command_e::ControlFlow)), token(nullptr), arg_word(nullptr), spids(new List<int>()) {
  }
  command__ControlFlow(Token* token, word_t* arg_word) :
                       type_tag_(static_cast<uint16_t>(command_e::ControlFlow)), token(token), arg_word(arg_word), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* token;
  word_t* arg_word;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__ControlFlow)
};

class command__Pipeline : public command_t {
 public:
  command__Pipeline() : type_tag_(static_cast<uint16_t>(command_e::Pipeline)),
                    children(new List<command_t*>()), negated(false),
                    stderr_indices(new List<int>()), spids(new List<int>()) {
  }
  command__Pipeline(List<command_t*>* children, bool negated, List<int>*
                    stderr_indices) :
                    type_tag_(static_cast<uint16_t>(command_e::Pipeline)),
                    children(children), negated(negated),
                    stderr_indices(stderr_indices), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<command_t*>* children;
  bool negated;
  List<int>* stderr_indices;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Pipeline)
};

class command__AndOr : public command_t {
 public:
  command__AndOr() : type_tag_(static_cast<uint16_t>(command_e::AndOr)),
                 ops(new List<Id_t>()), children(new List<command_t*>()),
                 spids(new List<int>()) {
  }
  command__AndOr(List<Id_t>* ops, List<command_t*>* children) :
                 type_tag_(static_cast<uint16_t>(command_e::AndOr)), ops(ops),
                 children(children), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<Id_t>* ops;
  List<command_t*>* children;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__AndOr)
};

class command__DoGroup : public command_t {
 public:
  command__DoGroup() : type_tag_(static_cast<uint16_t>(command_e::DoGroup)),
                   children(new List<command_t*>()), spids(new List<int>()) {
  }
  command__DoGroup(List<command_t*>* children) :
                   type_tag_(static_cast<uint16_t>(command_e::DoGroup)),
                   children(children), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<command_t*>* children;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__DoGroup)
};

class command__Subshell : public command_t {
 public:
  command__Subshell() : type_tag_(static_cast<uint16_t>(command_e::Subshell)),
                    child(nullptr), redirects(new List<redir*>()), spids(new
                    List<int>()) {
  }
  command__Subshell(command_t* child, List<redir*>* redirects) :
                    type_tag_(static_cast<uint16_t>(command_e::Subshell)),
                    child(child), redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  command_t* child;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Subshell)
};

class command__DParen : public command_t {
 public:
  command__DParen() : type_tag_(static_cast<uint16_t>(command_e::DParen)),
                  child(nullptr), redirects(new List<redir*>()), spids(new
                  List<int>()) {
  }
  command__DParen(arith_expr_t* child, List<redir*>* redirects) :
                  type_tag_(static_cast<uint16_t>(command_e::DParen)),
                  child(child), redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  arith_expr_t* child;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__DParen)
};

class command__DBracket : public command_t {
 public:
  command__DBracket() : type_tag_(static_cast<uint16_t>(command_e::DBracket)),
                    expr(nullptr), redirects(new List<redir*>()), spids(new
                    List<int>()) {
  }
  command__DBracket(bool_expr_t* expr, List<redir*>* redirects) :
                    type_tag_(static_cast<uint16_t>(command_e::DBracket)),
                    expr(expr), redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  bool_expr_t* expr;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__DBracket)
};

class command__ForEach : public command_t {
 public:
  command__ForEach() : type_tag_(static_cast<uint16_t>(command_e::ForEach)),
                   iter_name(new Str("")), iter_words(new List<word_t*>()),
                   do_arg_iter(false), body(nullptr), redirects(new
                   List<redir*>()), spids(new List<int>()) {
  }
  command__ForEach(Str* iter_name, List<word_t*>* iter_words, bool do_arg_iter,
                   command_t* body, List<redir*>* redirects) :
                   type_tag_(static_cast<uint16_t>(command_e::ForEach)),
                   iter_name(iter_name), iter_words(iter_words),
                   do_arg_iter(do_arg_iter), body(body), redirects(redirects),
                   spids(new List<int>()) {
  }
  OBJ_HEADER();
  Str* iter_name;
  List<word_t*>* iter_words;
  bool do_arg_iter;
  command_t* body;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__ForEach)
};

class command__ForExpr : public command_t {
 public:
  command__ForExpr() : type_tag_(static_cast<uint16_t>(command_e::ForExpr)),
                   init(nullptr), cond(nullptr), update(nullptr),
                   body(nullptr), redirects(new List<redir*>()), spids(new
                   List<int>()) {
  }
  command__ForExpr(arith_expr_t* init, arith_expr_t* cond, arith_expr_t*
                   update, command_t* body, List<redir*>* redirects) :
                   type_tag_(static_cast<uint16_t>(command_e::ForExpr)),
                   init(init), cond(cond), update(update), body(body),
                   redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  arith_expr_t* init;
  arith_expr_t* cond;
  arith_expr_t* update;
  command_t* body;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__ForExpr)
};

class command__WhileUntil : public command_t {
 public:
  command__WhileUntil() :
                      type_tag_(static_cast<uint16_t>(command_e::WhileUntil)),
                      keyword(nullptr), cond(nullptr), body(nullptr),
                      redirects(new List<redir*>()), spids(new List<int>()) {
  }
  command__WhileUntil(Token* keyword, condition_t* cond, command_t* body,
                      List<redir*>* redirects) :
                      type_tag_(static_cast<uint16_t>(command_e::WhileUntil)),
                      keyword(keyword), cond(cond), body(body),
                      redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* keyword;
  condition_t* cond;
  command_t* body;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__WhileUntil)
};

class command__If : public command_t {
 public:
  command__If() : type_tag_(static_cast<uint16_t>(command_e::If)), arms(new
              List<if_arm*>()), else_action(new List<command_t*>()),
              redirects(new List<redir*>()), spids(new List<int>()) {
  }
  command__If(List<if_arm*>* arms, List<command_t*>* else_action, List<redir*>*
              redirects) : type_tag_(static_cast<uint16_t>(command_e::If)),
              arms(arms), else_action(else_action), redirects(redirects),
              spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<if_arm*>* arms;
  List<command_t*>* else_action;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__If)
};

class command__Case : public command_t {
 public:
  command__Case() : type_tag_(static_cast<uint16_t>(command_e::Case)),
                to_match(nullptr), arms(new List<case_arm*>()), redirects(new
                List<redir*>()), spids(new List<int>()) {
  }
  command__Case(word_t* to_match, List<case_arm*>* arms, List<redir*>*
                redirects) : type_tag_(static_cast<uint16_t>(command_e::Case)),
                to_match(to_match), arms(arms), redirects(redirects), spids(new
                List<int>()) {
  }
  OBJ_HEADER();
  word_t* to_match;
  List<case_arm*>* arms;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Case)
};

class command__ShFunction : public command_t {
 public:
  command__ShFunction() :
                      type_tag_(static_cast<uint16_t>(command_e::ShFunction)),
                      name(new Str("")), body(nullptr), spids(new List<int>()) {
  }
  command__ShFunction(Str* name, command_t* body) :
                      type_tag_(static_cast<uint16_t>(command_e::ShFunction)),
                      name(name), body(body), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Str* name;
  command_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__ShFunction)
};

class command__TimeBlock : public command_t {
 public:
  command__TimeBlock() :
                     type_tag_(static_cast<uint16_t>(command_e::TimeBlock)),
                     pipeline(nullptr), spids(new List<int>()) {
  }
  command__TimeBlock(command_t* pipeline) :
                     type_tag_(static_cast<uint16_t>(command_e::TimeBlock)),
                     pipeline(pipeline), spids(new List<int>()) {
  }
  OBJ_HEADER();
  command_t* pipeline;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__TimeBlock)
};

class command__CommandList : public command_t {
 public:
  command__CommandList() :
                       type_tag_(static_cast<uint16_t>(command_e::CommandList)), children(new List<command_t*>()), spids(new List<int>()) {
  }
  command__CommandList(List<command_t*>* children) :
                       type_tag_(static_cast<uint16_t>(command_e::CommandList)), children(children), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<command_t*>* children;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__CommandList)
};

class command__BareDecl : public command_t {
 public:
  command__BareDecl() : type_tag_(static_cast<uint16_t>(command_e::BareDecl)),
                    lhs(nullptr), rhs(nullptr), spids(new List<int>()) {
  }
  command__BareDecl(Token* lhs, expr_t* rhs) :
                    type_tag_(static_cast<uint16_t>(command_e::BareDecl)),
                    lhs(lhs), rhs(rhs), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* lhs;
  expr_t* rhs;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__BareDecl)
};

class command__VarDecl : public command_t {
 public:
  command__VarDecl() : type_tag_(static_cast<uint16_t>(command_e::VarDecl)),
                   keyword(nullptr), lhs(new List<name_type*>()), rhs(nullptr),
                   spids(new List<int>()) {
  }
  command__VarDecl(Token* keyword, List<name_type*>* lhs, expr_t* rhs) :
                   type_tag_(static_cast<uint16_t>(command_e::VarDecl)),
                   keyword(keyword), lhs(lhs), rhs(rhs), spids(new List<int>())
                   {
  }
  OBJ_HEADER();
  Token* keyword;
  List<name_type*>* lhs;
  expr_t* rhs;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__VarDecl)
};

class command__PlaceMutation : public command_t {
 public:
  command__PlaceMutation() :
                         type_tag_(static_cast<uint16_t>(command_e::PlaceMutation)), keyword(nullptr), lhs(new List<place_expr_t*>()), op(nullptr), rhs(nullptr), spids(new List<int>()) {
  }
  command__PlaceMutation(Token* keyword, List<place_expr_t*>* lhs, Token* op,
                         expr_t* rhs) :
                         type_tag_(static_cast<uint16_t>(command_e::PlaceMutation)), keyword(keyword), lhs(lhs), op(op), rhs(rhs), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* keyword;
  List<place_expr_t*>* lhs;
  Token* op;
  expr_t* rhs;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__PlaceMutation)
};

class command__Expr : public command_t {
 public:
  command__Expr() : type_tag_(static_cast<uint16_t>(command_e::Expr)),
                keyword(nullptr), e(nullptr), spids(new List<int>()) {
  }
  command__Expr(speck* keyword, expr_t* e) :
                type_tag_(static_cast<uint16_t>(command_e::Expr)),
                keyword(keyword), e(e), spids(new List<int>()) {
  }
  OBJ_HEADER();
  speck* keyword;
  expr_t* e;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Expr)
};

class command__OilForIn : public command_t {
 public:
  command__OilForIn() : type_tag_(static_cast<uint16_t>(command_e::OilForIn)),
                    lhs(new List<name_type*>()), iterable(nullptr),
                    body(nullptr), spids(new List<int>()) {
  }
  command__OilForIn(List<name_type*>* lhs, expr_t* iterable, command_t* body) :
                    type_tag_(static_cast<uint16_t>(command_e::OilForIn)),
                    lhs(lhs), iterable(iterable), body(body), spids(new
                    List<int>()) {
  }
  OBJ_HEADER();
  List<name_type*>* lhs;
  expr_t* iterable;
  command_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__OilForIn)
};

class command__Proc : public command_t {
 public:
  command__Proc() : type_tag_(static_cast<uint16_t>(command_e::Proc)),
                name(nullptr), sig(nullptr), body(nullptr), spids(new
                List<int>()) {
  }
  command__Proc(Token* name, proc_sig_t* sig, command_t* body) :
                type_tag_(static_cast<uint16_t>(command_e::Proc)), name(name),
                sig(sig), body(body), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  proc_sig_t* sig;
  command_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Proc)
};

class command__Func : public command_t {
 public:
  command__Func() : type_tag_(static_cast<uint16_t>(command_e::Func)),
                name(nullptr), pos_params(new List<param*>()),
                pos_splat(nullptr), named_params(new List<param*>()),
                named_splat(nullptr), return_types(new List<type_expr_t*>()),
                body(nullptr), spids(new List<int>()) {
  }
  command__Func(Token* name, List<param*>* pos_params, Token* pos_splat,
                List<param*>* named_params, Token* named_splat,
                List<type_expr_t*>* return_types, command_t* body) :
                type_tag_(static_cast<uint16_t>(command_e::Func)), name(name),
                pos_params(pos_params), pos_splat(pos_splat),
                named_params(named_params), named_splat(named_splat),
                return_types(return_types), body(body), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  List<param*>* pos_params;
  Token* pos_splat;
  List<param*>* named_params;
  Token* named_splat;
  List<type_expr_t*>* return_types;
  command_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Func)
};

class command__Data : public command_t {
 public:
  command__Data() : type_tag_(static_cast<uint16_t>(command_e::Data)),
                name(nullptr), params(new List<param*>()), spids(new
                List<int>()) {
  }
  command__Data(Token* name, List<param*>* params) :
                type_tag_(static_cast<uint16_t>(command_e::Data)), name(name),
                params(params), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  List<param*>* params;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Data)
};

class command__Enum : public command_t {
 public:
  command__Enum() : type_tag_(static_cast<uint16_t>(command_e::Enum)),
                name(nullptr), variants(new List<variant*>()), spids(new
                List<int>()) {
  }
  command__Enum(Token* name, List<variant*>* variants) :
                type_tag_(static_cast<uint16_t>(command_e::Enum)), name(name),
                variants(variants), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  List<variant*>* variants;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Enum)
};

class command__Class : public command_t {
 public:
  command__Class() : type_tag_(static_cast<uint16_t>(command_e::Class)),
                 name(nullptr), extends(nullptr), items(new
                 List<class_item_t*>()), spids(new List<int>()) {
  }
  command__Class(Token* name, Token* extends, List<class_item_t*>* items) :
                 type_tag_(static_cast<uint16_t>(command_e::Class)),
                 name(name), extends(extends), items(items), spids(new
                 List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  Token* extends;
  List<class_item_t*>* items;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Class)
};

class command__Import : public command_t {
 public:
  command__Import() : type_tag_(static_cast<uint16_t>(command_e::Import)),
                  path(nullptr), alias(nullptr), names(new
                  List<import_name*>()), spids(new List<int>()) {
  }
  command__Import(single_quoted* path, Token* alias, List<import_name*>* names)
                  : type_tag_(static_cast<uint16_t>(command_e::Import)),
                  path(path), alias(alias), names(names), spids(new
                  List<int>()) {
  }
  OBJ_HEADER();
  single_quoted* path;
  Token* alias;
  List<import_name*>* names;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Import)
};

class command__For : public command_t {
 public:
  command__For() : type_tag_(static_cast<uint16_t>(command_e::For)),
               targets(new List<name_type*>()), iterable(nullptr),
               body(nullptr), spids(new List<int>()) {
  }
  command__For(List<name_type*>* targets, expr_t* iterable, command_t* body) :
               type_tag_(static_cast<uint16_t>(command_e::For)),
               targets(targets), iterable(iterable), body(body), spids(new
               List<int>()) {
  }
  OBJ_HEADER();
  List<name_type*>* targets;
  expr_t* iterable;
  command_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__For)
};

class command__While : public command_t {
 public:
  command__While() : type_tag_(static_cast<uint16_t>(command_e::While)),
                 test(nullptr), body(nullptr), spids(new List<int>()) {
  }
  command__While(expr_t* test, command_t* body) :
                 type_tag_(static_cast<uint16_t>(command_e::While)),
                 test(test), body(body), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* test;
  command_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__While)
};

class command__Break : public command_t {
 public:
  command__Break() : type_tag_(static_cast<uint16_t>(command_e::Break)),
                 spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Break)
};

class command__Continue : public command_t {
 public:
  command__Continue() : type_tag_(static_cast<uint16_t>(command_e::Continue)),
                    spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Continue)
};

class command__Return : public command_t {
 public:
  command__Return() : type_tag_(static_cast<uint16_t>(command_e::Return)),
                  value(nullptr), spids(new List<int>()) {
  }
  command__Return(expr_t* value) :
                  type_tag_(static_cast<uint16_t>(command_e::Return)),
                  value(value), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* value;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command__Return)
};

namespace command {
  typedef command__NoOp NoOp;
  typedef command__Simple Simple;
  typedef command__ExpandedAlias ExpandedAlias;
  typedef command__Sentence Sentence;
  typedef command__ShAssignment ShAssignment;
  typedef command__ControlFlow ControlFlow;
  typedef command__Pipeline Pipeline;
  typedef command__AndOr AndOr;
  typedef command__DoGroup DoGroup;
  typedef command__Subshell Subshell;
  typedef command__DParen DParen;
  typedef command__DBracket DBracket;
  typedef command__ForEach ForEach;
  typedef command__ForExpr ForExpr;
  typedef command__WhileUntil WhileUntil;
  typedef command__If If;
  typedef command__Case Case;
  typedef command__ShFunction ShFunction;
  typedef command__TimeBlock TimeBlock;
  typedef command__CommandList CommandList;
  typedef command__BareDecl BareDecl;
  typedef command__VarDecl VarDecl;
  typedef command__PlaceMutation PlaceMutation;
  typedef command__Expr Expr;
  typedef command__OilForIn OilForIn;
  typedef command__Proc Proc;
  typedef command__Func Func;
  typedef command__Data Data;
  typedef command__Enum Enum;
  typedef command__Class Class;
  typedef command__Import Import;
  typedef command__For For;
  typedef command__While While;
  typedef command__Break Break;
  typedef command__Continue Continue;
  typedef command__Return Return;
}

namespace variant_type_e {
  const int Anon = 1;
  const int Ref = 2;
};

const char* variant_type_str(int tag);

class variant_type_t {
 protected:
  variant_type_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(variant_type_t)
};

class variant_type__Anon : public variant_type_t {
 public:
  variant_type__Anon() :
                     type_tag_(static_cast<uint16_t>(variant_type_e::Anon)),
                     params(new List<param*>()) {
  }
  variant_type__Anon(List<param*>* params) :
                     type_tag_(static_cast<uint16_t>(variant_type_e::Anon)),
                     params(params) {
  }
  OBJ_HEADER();
  List<param*>* params;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(variant_type__Anon)
};

class variant_type__Ref : public variant_type_t {
 public:
  variant_type__Ref() : type_tag_(static_cast<uint16_t>(variant_type_e::Ref)),
                    type_name(nullptr) {
  }
  variant_type__Ref(Token* type_name) :
                    type_tag_(static_cast<uint16_t>(variant_type_e::Ref)),
                    type_name(type_name) {
  }
  OBJ_HEADER();
  Token* type_name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(variant_type__Ref)
};

namespace variant_type {
  typedef variant_type__Anon Anon;
  typedef variant_type__Ref Ref;
}

namespace class_item_e {
  const int Data = 1;
  const int Method = 2;
};

const char* class_item_str(int tag);

class class_item_t {
 protected:
  class_item_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(class_item_t)
};

class class_item__Data : public class_item_t {
 public:
  class_item__Data() : type_tag_(static_cast<uint16_t>(class_item_e::Data)),
                   keyword(nullptr), fields(new List<name_type*>()) {
  }
  class_item__Data(Token* keyword, List<name_type*>* fields) :
                   type_tag_(static_cast<uint16_t>(class_item_e::Data)),
                   keyword(keyword), fields(fields) {
  }
  OBJ_HEADER();
  Token* keyword;
  List<name_type*>* fields;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(class_item__Data)
};

class class_item__Method : public class_item_t {
 public:
  class_item__Method() : type_tag_(static_cast<uint16_t>(class_item_e::Method))
                     {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(class_item__Method)
};

namespace class_item {
  typedef class_item__Data Data;
  typedef class_item__Method Method;
}

namespace proc_sig_e {
  const int Open = 1;
  const int Closed = 2;
};

const char* proc_sig_str(int tag);

class proc_sig_t {
 protected:
  proc_sig_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(proc_sig_t)
};

class proc_sig__Open : public proc_sig_t {
 public:
  proc_sig__Open() : type_tag_(static_cast<uint16_t>(proc_sig_e::Open)) {
  }
  OBJ_HEADER();
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(proc_sig__Open)
};

class proc_sig__Closed : public proc_sig_t {
 public:
  proc_sig__Closed() : type_tag_(static_cast<uint16_t>(proc_sig_e::Closed)),
                   params(new List<param*>()), rest(nullptr), block(nullptr) {
  }
  proc_sig__Closed(List<param*>* params, Token* rest, Token* block) :
                   type_tag_(static_cast<uint16_t>(proc_sig_e::Closed)),
                   params(params), rest(rest), block(block) {
  }
  OBJ_HEADER();
  List<param*>* params;
  Token* rest;
  Token* block;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(proc_sig__Closed)
};

namespace proc_sig {
  typedef proc_sig__Open Open;
  typedef proc_sig__Closed Closed;
}

namespace glob_part_e {
  const int Literal = 1;
  const int Operator = 2;
  const int CharClass = 3;
};

const char* glob_part_str(int tag);

class glob_part_t {
 protected:
  glob_part_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(glob_part_t)
};

class glob_part__Literal : public glob_part_t {
 public:
  glob_part__Literal() :
                     type_tag_(static_cast<uint16_t>(glob_part_e::Literal)),
                     id(-1), s(new Str("")) {
  }
  glob_part__Literal(Id_t id, Str* s) :
                     type_tag_(static_cast<uint16_t>(glob_part_e::Literal)),
                     id(id), s(s) {
  }
  OBJ_HEADER();
  Id_t id;
  Str* s;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(glob_part__Literal)
};

class glob_part__Operator : public glob_part_t {
 public:
  glob_part__Operator() :
                      type_tag_(static_cast<uint16_t>(glob_part_e::Operator)),
                      op_id(-1) {
  }
  glob_part__Operator(Id_t op_id) :
                      type_tag_(static_cast<uint16_t>(glob_part_e::Operator)),
                      op_id(op_id) {
  }
  OBJ_HEADER();
  Id_t op_id;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(glob_part__Operator)
};

class glob_part__CharClass : public glob_part_t {
 public:
  glob_part__CharClass() :
                       type_tag_(static_cast<uint16_t>(glob_part_e::CharClass)), negated(false), strs(new List<Str*>()) {
  }
  glob_part__CharClass(bool negated, List<Str*>* strs) :
                       type_tag_(static_cast<uint16_t>(glob_part_e::CharClass)), negated(negated), strs(strs) {
  }
  OBJ_HEADER();
  bool negated;
  List<Str*>* strs;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(glob_part__CharClass)
};

namespace glob_part {
  typedef glob_part__Literal Literal;
  typedef glob_part__Operator Operator;
  typedef glob_part__CharClass CharClass;
}

namespace printf_part_e {
  const int Literal = 1;
  const int Percent = 2;
};

const char* printf_part_str(int tag);

class printf_part_t {
 protected:
  printf_part_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(printf_part_t)
};

class printf_part__Literal : public printf_part_t {
 public:
  printf_part__Literal() :
                       type_tag_(static_cast<uint16_t>(printf_part_e::Literal)), token(nullptr) {
  }
  printf_part__Literal(Token* token) :
                       type_tag_(static_cast<uint16_t>(printf_part_e::Literal)), token(token) {
  }
  OBJ_HEADER();
  Token* token;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(printf_part__Literal)
};

class printf_part__Percent : public printf_part_t {
 public:
  printf_part__Percent() :
                       type_tag_(static_cast<uint16_t>(printf_part_e::Percent)), flags(new List<Token*>()), width(nullptr), precision(nullptr), type(nullptr) {
  }
  printf_part__Percent(List<Token*>* flags, Token* width, Token* precision,
                       Token* type) :
                       type_tag_(static_cast<uint16_t>(printf_part_e::Percent)), flags(flags), width(width), precision(precision), type(type) {
  }
  OBJ_HEADER();
  List<Token*>* flags;
  Token* width;
  Token* precision;
  Token* type;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(printf_part__Percent)
};

namespace printf_part {
  typedef printf_part__Literal Literal;
  typedef printf_part__Percent Percent;
}

enum class expr_context_e {
  Load = 1,
  Store = 2,
  Del = 3,
  AugLoad = 4,
  AugStore = 5,
  Param = 6,
};
typedef expr_context_e expr_context_t;

const char* expr_context_str(expr_context_e tag);

namespace type_expr_e {
  const int Simple = 1;
  const int Compound = 2;
};

const char* type_expr_str(int tag);

class type_expr_t {
 protected:
  type_expr_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(type_expr_t)
};

class type_expr__Simple : public type_expr_t {
 public:
  type_expr__Simple() : type_tag_(static_cast<uint16_t>(type_expr_e::Simple)),
                    name(nullptr) {
  }
  type_expr__Simple(Token* name) :
                    type_tag_(static_cast<uint16_t>(type_expr_e::Simple)),
                    name(name) {
  }
  OBJ_HEADER();
  Token* name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(type_expr__Simple)
};

class type_expr__Compound : public type_expr_t {
 public:
  type_expr__Compound() :
                      type_tag_(static_cast<uint16_t>(type_expr_e::Compound)),
                      name(nullptr), params(new List<type_expr_t*>()) {
  }
  type_expr__Compound(Token* name, List<type_expr_t*>* params) :
                      type_tag_(static_cast<uint16_t>(type_expr_e::Compound)),
                      name(name), params(params) {
  }
  OBJ_HEADER();
  Token* name;
  List<type_expr_t*>* params;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(type_expr__Compound)
};

namespace type_expr {
  typedef type_expr__Simple Simple;
  typedef type_expr__Compound Compound;
}

namespace place_expr_e {
  const int Var = 1;
  const int Subscript = 225;
  const int Attribute = 226;
};

const char* place_expr_str(int tag);

class place_expr_t {
 protected:
  place_expr_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(place_expr_t)
};

class place_expr__Var : public place_expr_t {
 public:
  place_expr__Var() : type_tag_(static_cast<uint16_t>(place_expr_e::Var)),
                  name(nullptr) {
  }
  place_expr__Var(Token* name) :
                  type_tag_(static_cast<uint16_t>(place_expr_e::Var)),
                  name(name) {
  }
  OBJ_HEADER();
  Token* name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(place_expr__Var)
};

namespace place_expr {
  typedef place_expr__Var Var;
}

namespace expr_e {
  const int Var = 1;
  const int Const = 2;
  const int ShArrayLiteral = 208;
  const int ArrayLiteral = 4;
  const int RegexLiteral = 5;
  const int SimpleVarSub = 205;
  const int BracedVarSub = 206;
  const int CommandSub = 207;
  const int SingleQuoted = 204;
  const int DoubleQuoted = 203;
  const int Lambda = 11;
  const int Unary = 12;
  const int Binary = 13;
  const int Compare = 14;
  const int FuncCall = 15;
  const int IfExp = 16;
  const int Tuple = 17;
  const int List = 18;
  const int Dict = 19;
  const int Implicit = 20;
  const int ListComp = 21;
  const int DictComp = 22;
  const int GeneratorExp = 23;
  const int Range = 24;
  const int Slice = 25;
  const int Subscript = 225;
  const int Attribute = 226;
  const int Spread = 28;
};

const char* expr_str(int tag);

class expr_t {
 protected:
  expr_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(expr_t)
};

class expr__Var : public expr_t {
 public:
  expr__Var() : type_tag_(static_cast<uint16_t>(expr_e::Var)), name(nullptr),
            spids(new List<int>()) {
  }
  expr__Var(Token* name) : type_tag_(static_cast<uint16_t>(expr_e::Var)),
            name(name), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* name;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Var)
};

class expr__Const : public expr_t {
 public:
  expr__Const() : type_tag_(static_cast<uint16_t>(expr_e::Const)), c(nullptr),
              spids(new List<int>()) {
  }
  expr__Const(Token* c) : type_tag_(static_cast<uint16_t>(expr_e::Const)),
              c(c), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* c;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Const)
};

class expr__ArrayLiteral : public expr_t {
 public:
  expr__ArrayLiteral() :
                     type_tag_(static_cast<uint16_t>(expr_e::ArrayLiteral)),
                     left(nullptr), items(new List<expr_t*>()), spids(new
                     List<int>()) {
  }
  expr__ArrayLiteral(Token* left, List<expr_t*>* items) :
                     type_tag_(static_cast<uint16_t>(expr_e::ArrayLiteral)),
                     left(left), items(items), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  List<expr_t*>* items;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__ArrayLiteral)
};

class expr__RegexLiteral : public expr_t {
 public:
  expr__RegexLiteral() :
                     type_tag_(static_cast<uint16_t>(expr_e::RegexLiteral)),
                     left(nullptr), regex(nullptr), flags(new List<Token*>()),
                     trans_pref(nullptr), spids(new List<int>()) {
  }
  expr__RegexLiteral(Token* left, re_t* regex, List<Token*>* flags, Token*
                     trans_pref) :
                     type_tag_(static_cast<uint16_t>(expr_e::RegexLiteral)),
                     left(left), regex(regex), flags(flags),
                     trans_pref(trans_pref), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  re_t* regex;
  List<Token*>* flags;
  Token* trans_pref;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__RegexLiteral)
};

class expr__Lambda : public expr_t {
 public:
  expr__Lambda() : type_tag_(static_cast<uint16_t>(expr_e::Lambda)), params(new
               List<name_type*>()), body(nullptr), spids(new List<int>()) {
  }
  expr__Lambda(List<name_type*>* params, expr_t* body) :
               type_tag_(static_cast<uint16_t>(expr_e::Lambda)),
               params(params), body(body), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<name_type*>* params;
  expr_t* body;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Lambda)
};

class expr__Unary : public expr_t {
 public:
  expr__Unary() : type_tag_(static_cast<uint16_t>(expr_e::Unary)), op(nullptr),
              child(nullptr), spids(new List<int>()) {
  }
  expr__Unary(Token* op, expr_t* child) :
              type_tag_(static_cast<uint16_t>(expr_e::Unary)), op(op),
              child(child), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* op;
  expr_t* child;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Unary)
};

class expr__Binary : public expr_t {
 public:
  expr__Binary() : type_tag_(static_cast<uint16_t>(expr_e::Binary)),
               op(nullptr), left(nullptr), right(nullptr), spids(new
               List<int>()) {
  }
  expr__Binary(Token* op, expr_t* left, expr_t* right) :
               type_tag_(static_cast<uint16_t>(expr_e::Binary)), op(op),
               left(left), right(right), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* op;
  expr_t* left;
  expr_t* right;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Binary)
};

class expr__Compare : public expr_t {
 public:
  expr__Compare() : type_tag_(static_cast<uint16_t>(expr_e::Compare)),
                left(nullptr), ops(new List<speck*>()), comparators(new
                List<expr_t*>()), spids(new List<int>()) {
  }
  expr__Compare(expr_t* left, List<speck*>* ops, List<expr_t*>* comparators) :
                type_tag_(static_cast<uint16_t>(expr_e::Compare)), left(left),
                ops(ops), comparators(comparators), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* left;
  List<speck*>* ops;
  List<expr_t*>* comparators;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Compare)
};

class expr__FuncCall : public expr_t {
 public:
  expr__FuncCall() : type_tag_(static_cast<uint16_t>(expr_e::FuncCall)),
                 func(nullptr), args(nullptr), spids(new List<int>()) {
  }
  expr__FuncCall(expr_t* func, arg_list* args) :
                 type_tag_(static_cast<uint16_t>(expr_e::FuncCall)),
                 func(func), args(args), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* func;
  arg_list* args;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__FuncCall)
};

class expr__IfExp : public expr_t {
 public:
  expr__IfExp() : type_tag_(static_cast<uint16_t>(expr_e::IfExp)),
              test(nullptr), body(nullptr), orelse(nullptr), spids(new
              List<int>()) {
  }
  expr__IfExp(expr_t* test, expr_t* body, expr_t* orelse) :
              type_tag_(static_cast<uint16_t>(expr_e::IfExp)), test(test),
              body(body), orelse(orelse), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* test;
  expr_t* body;
  expr_t* orelse;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__IfExp)
};

class expr__Tuple : public expr_t {
 public:
  expr__Tuple() : type_tag_(static_cast<uint16_t>(expr_e::Tuple)), elts(new
              List<expr_t*>()), ctx(expr_context_e::Load), spids(new
              List<int>()) {
  }
  expr__Tuple(List<expr_t*>* elts, expr_context_t ctx) :
              type_tag_(static_cast<uint16_t>(expr_e::Tuple)), elts(elts),
              ctx(ctx), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<expr_t*>* elts;
  expr_context_t ctx;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Tuple)
};

class expr__List : public expr_t {
 public:
  expr__List() : type_tag_(static_cast<uint16_t>(expr_e::List)), elts(new
             List<expr_t*>()), ctx(expr_context_e::Load), spids(new
             List<int>()) {
  }
  expr__List(List<expr_t*>* elts, expr_context_t ctx) :
             type_tag_(static_cast<uint16_t>(expr_e::List)), elts(elts),
             ctx(ctx), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<expr_t*>* elts;
  expr_context_t ctx;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__List)
};

class expr__Dict : public expr_t {
 public:
  expr__Dict() : type_tag_(static_cast<uint16_t>(expr_e::Dict)), keys(new
             List<expr_t*>()), values(new List<expr_t*>()), spids(new
             List<int>()) {
  }
  expr__Dict(List<expr_t*>* keys, List<expr_t*>* values) :
             type_tag_(static_cast<uint16_t>(expr_e::Dict)), keys(keys),
             values(values), spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<expr_t*>* keys;
  List<expr_t*>* values;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Dict)
};

class expr__Implicit : public expr_t {
 public:
  expr__Implicit() : type_tag_(static_cast<uint16_t>(expr_e::Implicit)),
                 spids(new List<int>()) {
  }
  OBJ_HEADER();
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Implicit)
};

class expr__ListComp : public expr_t {
 public:
  expr__ListComp() : type_tag_(static_cast<uint16_t>(expr_e::ListComp)),
                 elt(nullptr), generators(new List<comprehension*>()),
                 spids(new List<int>()) {
  }
  expr__ListComp(expr_t* elt, List<comprehension*>* generators) :
                 type_tag_(static_cast<uint16_t>(expr_e::ListComp)), elt(elt),
                 generators(generators), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* elt;
  List<comprehension*>* generators;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__ListComp)
};

class expr__DictComp : public expr_t {
 public:
  expr__DictComp() : type_tag_(static_cast<uint16_t>(expr_e::DictComp)),
                 key(nullptr), value(nullptr), generators(new
                 List<comprehension*>()), spids(new List<int>()) {
  }
  expr__DictComp(expr_t* key, expr_t* value, List<comprehension*>* generators)
                 : type_tag_(static_cast<uint16_t>(expr_e::DictComp)),
                 key(key), value(value), generators(generators), spids(new
                 List<int>()) {
  }
  OBJ_HEADER();
  expr_t* key;
  expr_t* value;
  List<comprehension*>* generators;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__DictComp)
};

class expr__GeneratorExp : public expr_t {
 public:
  expr__GeneratorExp() :
                     type_tag_(static_cast<uint16_t>(expr_e::GeneratorExp)),
                     elt(nullptr), generators(new List<comprehension*>()),
                     spids(new List<int>()) {
  }
  expr__GeneratorExp(expr_t* elt, List<comprehension*>* generators) :
                     type_tag_(static_cast<uint16_t>(expr_e::GeneratorExp)),
                     elt(elt), generators(generators), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* elt;
  List<comprehension*>* generators;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__GeneratorExp)
};

class expr__Range : public expr_t {
 public:
  expr__Range() : type_tag_(static_cast<uint16_t>(expr_e::Range)),
              lower(nullptr), upper(nullptr), spids(new List<int>()) {
  }
  expr__Range(expr_t* lower, expr_t* upper) :
              type_tag_(static_cast<uint16_t>(expr_e::Range)), lower(lower),
              upper(upper), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* lower;
  expr_t* upper;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Range)
};

class expr__Slice : public expr_t {
 public:
  expr__Slice() : type_tag_(static_cast<uint16_t>(expr_e::Slice)),
              lower(nullptr), upper(nullptr), spids(new List<int>()) {
  }
  expr__Slice(expr_t* lower, expr_t* upper) :
              type_tag_(static_cast<uint16_t>(expr_e::Slice)), lower(lower),
              upper(upper), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* lower;
  expr_t* upper;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Slice)
};

class expr__Spread : public expr_t {
 public:
  expr__Spread() : type_tag_(static_cast<uint16_t>(expr_e::Spread)),
               child(nullptr), ctx(expr_context_e::Load), spids(new
               List<int>()) {
  }
  expr__Spread(expr_t* child, expr_context_t ctx) :
               type_tag_(static_cast<uint16_t>(expr_e::Spread)), child(child),
               ctx(ctx), spids(new List<int>()) {
  }
  OBJ_HEADER();
  expr_t* child;
  expr_context_t ctx;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(expr__Spread)
};

namespace expr {
  typedef expr__Var Var;
  typedef expr__Const Const;
  typedef expr__ArrayLiteral ArrayLiteral;
  typedef expr__RegexLiteral RegexLiteral;
  typedef expr__Lambda Lambda;
  typedef expr__Unary Unary;
  typedef expr__Binary Binary;
  typedef expr__Compare Compare;
  typedef expr__FuncCall FuncCall;
  typedef expr__IfExp IfExp;
  typedef expr__Tuple Tuple;
  typedef expr__List List;
  typedef expr__Dict Dict;
  typedef expr__Implicit Implicit;
  typedef expr__ListComp ListComp;
  typedef expr__DictComp DictComp;
  typedef expr__GeneratorExp GeneratorExp;
  typedef expr__Range Range;
  typedef expr__Slice Slice;
  typedef expr__Spread Spread;
}

namespace class_literal_term_e {
  const int PosixClass = 227;
  const int PerlClass = 228;
  const int Range = 3;
  const int CharLiteral = 4;
  const int SimpleVarSub = 205;
  const int BracedVarSub = 206;
  const int SingleQuoted = 204;
  const int DoubleQuoted = 203;
  const int ByteSet = 9;
  const int CodePoint = 10;
};

const char* class_literal_term_str(int tag);

class class_literal_term_t {
 protected:
  class_literal_term_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(class_literal_term_t)
};

class class_literal_term__Range : public class_literal_term_t {
 public:
  class_literal_term__Range() :
                            type_tag_(static_cast<uint16_t>(class_literal_term_e::Range)), start(new Str("")), end(new Str("")) {
  }
  class_literal_term__Range(Str* start, Str* end) :
                            type_tag_(static_cast<uint16_t>(class_literal_term_e::Range)), start(start), end(end) {
  }
  OBJ_HEADER();
  Str* start;
  Str* end;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(class_literal_term__Range)
};

class class_literal_term__CharLiteral : public class_literal_term_t {
 public:
  class_literal_term__CharLiteral() :
                                  type_tag_(static_cast<uint16_t>(class_literal_term_e::CharLiteral)), tok(nullptr) {
  }
  class_literal_term__CharLiteral(Token* tok) :
                                  type_tag_(static_cast<uint16_t>(class_literal_term_e::CharLiteral)), tok(tok) {
  }
  OBJ_HEADER();
  Token* tok;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(class_literal_term__CharLiteral)
};

class class_literal_term__ByteSet : public class_literal_term_t {
 public:
  class_literal_term__ByteSet() :
                              type_tag_(static_cast<uint16_t>(class_literal_term_e::ByteSet)), bytes(new Str("")), spid(-1) {
  }
  class_literal_term__ByteSet(Str* bytes, int spid) :
                              type_tag_(static_cast<uint16_t>(class_literal_term_e::ByteSet)), bytes(bytes), spid(spid) {
  }
  OBJ_HEADER();
  Str* bytes;
  int spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(class_literal_term__ByteSet)
};

class class_literal_term__CodePoint : public class_literal_term_t {
 public:
  class_literal_term__CodePoint() :
                                type_tag_(static_cast<uint16_t>(class_literal_term_e::CodePoint)), i(-1), spid(-1) {
  }
  class_literal_term__CodePoint(int i, int spid) :
                                type_tag_(static_cast<uint16_t>(class_literal_term_e::CodePoint)), i(i), spid(spid) {
  }
  OBJ_HEADER();
  int i;
  int spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(class_literal_term__CodePoint)
};

namespace class_literal_term {
  typedef class_literal_term__Range Range;
  typedef class_literal_term__CharLiteral CharLiteral;
  typedef class_literal_term__ByteSet ByteSet;
  typedef class_literal_term__CodePoint CodePoint;
}

namespace re_repeat_e {
  const int Op = 1;
  const int Num = 2;
  const int Range = 3;
};

const char* re_repeat_str(int tag);

class re_repeat_t {
 protected:
  re_repeat_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(re_repeat_t)
};

class re_repeat__Op : public re_repeat_t {
 public:
  re_repeat__Op() : type_tag_(static_cast<uint16_t>(re_repeat_e::Op)),
                op(nullptr) {
  }
  re_repeat__Op(Token* op) : type_tag_(static_cast<uint16_t>(re_repeat_e::Op)),
                op(op) {
  }
  OBJ_HEADER();
  Token* op;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re_repeat__Op)
};

class re_repeat__Num : public re_repeat_t {
 public:
  re_repeat__Num() : type_tag_(static_cast<uint16_t>(re_repeat_e::Num)),
                 times(nullptr) {
  }
  re_repeat__Num(Token* times) :
                 type_tag_(static_cast<uint16_t>(re_repeat_e::Num)),
                 times(times) {
  }
  OBJ_HEADER();
  Token* times;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re_repeat__Num)
};

class re_repeat__Range : public re_repeat_t {
 public:
  re_repeat__Range() : type_tag_(static_cast<uint16_t>(re_repeat_e::Range)),
                   lower(nullptr), upper(nullptr) {
  }
  re_repeat__Range(Token* lower, Token* upper) :
                   type_tag_(static_cast<uint16_t>(re_repeat_e::Range)),
                   lower(lower), upper(upper) {
  }
  OBJ_HEADER();
  Token* lower;
  Token* upper;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re_repeat__Range)
};

namespace re_repeat {
  typedef re_repeat__Op Op;
  typedef re_repeat__Num Num;
  typedef re_repeat__Range Range;
}

namespace re_e {
  const int Speck = 202;
  const int Token = 201;
  const int PosixClass = 227;
  const int PerlClass = 228;
  const int ClassLiteral = 5;
  const int Splice = 6;
  const int SimpleVarSub = 205;
  const int BracedVarSub = 206;
  const int SingleQuoted = 204;
  const int DoubleQuoted = 203;
  const int Repeat = 11;
  const int Seq = 12;
  const int Alt = 13;
  const int Group = 14;
  const int Capture = 15;
  const int Backtracking = 16;
  const int Primitive = 17;
  const int LiteralChars = 18;
};

const char* re_str(int tag);

class re_t {
 protected:
  re_t() {}
 public:
  int tag_() const {
    return reinterpret_cast<const gc_heap::Obj*>(this)->type_tag_;
  }
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();
  DISALLOW_COPY_AND_ASSIGN(re_t)
};

class re__ClassLiteral : public re_t {
 public:
  re__ClassLiteral() : type_tag_(static_cast<uint16_t>(re_e::ClassLiteral)),
                   negated(false), terms(new List<class_literal_term_t*>()) {
  }
  re__ClassLiteral(bool negated, List<class_literal_term_t*>* terms) :
                   type_tag_(static_cast<uint16_t>(re_e::ClassLiteral)),
                   negated(negated), terms(terms) {
  }
  OBJ_HEADER();
  bool negated;
  List<class_literal_term_t*>* terms;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__ClassLiteral)
};

class re__Splice : public re_t {
 public:
  re__Splice() : type_tag_(static_cast<uint16_t>(re_e::Splice)), name(nullptr) {
  }
  re__Splice(Token* name) : type_tag_(static_cast<uint16_t>(re_e::Splice)),
             name(name) {
  }
  OBJ_HEADER();
  Token* name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Splice)
};

class re__Repeat : public re_t {
 public:
  re__Repeat() : type_tag_(static_cast<uint16_t>(re_e::Repeat)),
             child(nullptr), op(nullptr) {
  }
  re__Repeat(re_t* child, re_repeat_t* op) :
             type_tag_(static_cast<uint16_t>(re_e::Repeat)), child(child),
             op(op) {
  }
  OBJ_HEADER();
  re_t* child;
  re_repeat_t* op;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Repeat)
};

class re__Seq : public re_t {
 public:
  re__Seq() : type_tag_(static_cast<uint16_t>(re_e::Seq)), children(new
          List<re_t*>()) {
  }
  re__Seq(List<re_t*>* children) : type_tag_(static_cast<uint16_t>(re_e::Seq)),
          children(children) {
  }
  OBJ_HEADER();
  List<re_t*>* children;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Seq)
};

class re__Alt : public re_t {
 public:
  re__Alt() : type_tag_(static_cast<uint16_t>(re_e::Alt)), children(new
          List<re_t*>()) {
  }
  re__Alt(List<re_t*>* children) : type_tag_(static_cast<uint16_t>(re_e::Alt)),
          children(children) {
  }
  OBJ_HEADER();
  List<re_t*>* children;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Alt)
};

class re__Group : public re_t {
 public:
  re__Group() : type_tag_(static_cast<uint16_t>(re_e::Group)), child(nullptr) {
  }
  re__Group(re_t* child) : type_tag_(static_cast<uint16_t>(re_e::Group)),
            child(child) {
  }
  OBJ_HEADER();
  re_t* child;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Group)
};

class re__Capture : public re_t {
 public:
  re__Capture() : type_tag_(static_cast<uint16_t>(re_e::Capture)),
              child(nullptr), var_name(nullptr) {
  }
  re__Capture(re_t* child, Token* var_name) :
              type_tag_(static_cast<uint16_t>(re_e::Capture)), child(child),
              var_name(var_name) {
  }
  OBJ_HEADER();
  re_t* child;
  Token* var_name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Capture)
};

class re__Backtracking : public re_t {
 public:
  re__Backtracking() : type_tag_(static_cast<uint16_t>(re_e::Backtracking)),
                   negated(false), name(nullptr), child(nullptr) {
  }
  re__Backtracking(bool negated, Token* name, re_t* child) :
                   type_tag_(static_cast<uint16_t>(re_e::Backtracking)),
                   negated(negated), name(name), child(child) {
  }
  OBJ_HEADER();
  bool negated;
  Token* name;
  re_t* child;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Backtracking)
};

class re__Primitive : public re_t {
 public:
  re__Primitive() : type_tag_(static_cast<uint16_t>(re_e::Primitive)), id(-1) {
  }
  re__Primitive(Id_t id) : type_tag_(static_cast<uint16_t>(re_e::Primitive)),
                id(id) {
  }
  OBJ_HEADER();
  Id_t id;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__Primitive)
};

class re__LiteralChars : public re_t {
 public:
  re__LiteralChars() : type_tag_(static_cast<uint16_t>(re_e::LiteralChars)),
                   s(new Str("")), spid(-1) {
  }
  re__LiteralChars(Str* s, int spid) :
                   type_tag_(static_cast<uint16_t>(re_e::LiteralChars)), s(s),
                   spid(spid) {
  }
  OBJ_HEADER();
  Str* s;
  int spid;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(re__LiteralChars)
};

namespace re {
  typedef re__ClassLiteral ClassLiteral;
  typedef re__Splice Splice;
  typedef re__Repeat Repeat;
  typedef re__Seq Seq;
  typedef re__Alt Alt;
  typedef re__Group Group;
  typedef re__Capture Capture;
  typedef re__Backtracking Backtracking;
  typedef re__Primitive Primitive;
  typedef re__LiteralChars LiteralChars;
}

class line_span {
 public:
  line_span() : type_tag_(200), line_id(-1), col(-1), length(-1) {
  }
  line_span(int line_id, int col, int length) : type_tag_(200),
            line_id(line_id), col(col), length(length) {
  }
  OBJ_HEADER();
  int line_id;
  int col;
  int length;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(line_span)
};

class Token : public suffix_op_t, public word_part_t, public word_t, public
arith_expr_t, public re_t {
 public:
  Token() : type_tag_(201), id(-1), span_id(-1), val(new Str("")) {
  }
  Token(Id_t id, int span_id, Str* val) : type_tag_(201), id(id),
        span_id(span_id), val(val) {
  }
  OBJ_HEADER();
  Id_t id;
  int span_id;
  Str* val;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(Token)
};

class speck : public re_t {
 public:
  speck() : type_tag_(202), id(-1), span_id(-1) {
  }
  speck(Id_t id, int span_id) : type_tag_(202), id(id), span_id(span_id) {
  }
  OBJ_HEADER();
  Id_t id;
  int span_id;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(speck)
};

class double_quoted : public word_part_t, public expr_t, public
class_literal_term_t, public re_t {
 public:
  double_quoted() : type_tag_(203), left(nullptr), parts(new
                List<word_part_t*>()), multiline(false), spids(new List<int>())
                {
  }
  double_quoted(Token* left, List<word_part_t*>* parts, bool multiline) :
                type_tag_(203), left(left), parts(parts), multiline(multiline),
                spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  List<word_part_t*>* parts;
  bool multiline;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(double_quoted)
};

class single_quoted : public word_part_t, public expr_t, public
class_literal_term_t, public re_t {
 public:
  single_quoted() : type_tag_(204), left(nullptr), tokens(new List<Token*>()),
                multiline(false), spids(new List<int>()) {
  }
  single_quoted(Token* left, List<Token*>* tokens, bool multiline) :
                type_tag_(204), left(left), tokens(tokens),
                multiline(multiline), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  List<Token*>* tokens;
  bool multiline;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(single_quoted)
};

class simple_var_sub : public word_part_t, public expr_t, public
class_literal_term_t, public re_t {
 public:
  simple_var_sub() : type_tag_(205), token(nullptr) {
  }
  simple_var_sub(Token* token) : type_tag_(205), token(token) {
  }
  OBJ_HEADER();
  Token* token;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(simple_var_sub)
};

class braced_var_sub : public word_part_t, public expr_t, public
class_literal_term_t, public re_t {
 public:
  braced_var_sub() : type_tag_(206), token(nullptr), prefix_op(nullptr),
                 bracket_op(nullptr), suffix_op(nullptr), spids(new
                 List<int>()) {
  }
  braced_var_sub(Token* token, speck* prefix_op, bracket_op_t* bracket_op,
                 suffix_op_t* suffix_op) : type_tag_(206), token(token),
                 prefix_op(prefix_op), bracket_op(bracket_op),
                 suffix_op(suffix_op), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* token;
  speck* prefix_op;
  bracket_op_t* bracket_op;
  suffix_op_t* suffix_op;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(braced_var_sub)
};

class command_sub : public word_part_t, public expr_t {
 public:
  command_sub() : type_tag_(207), left_token(nullptr), child(nullptr),
              spids(new List<int>()) {
  }
  command_sub(Token* left_token, command_t* child) : type_tag_(207),
              left_token(left_token), child(child), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left_token;
  command_t* child;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(command_sub)
};

class sh_array_literal : public word_part_t, public expr_t {
 public:
  sh_array_literal() : type_tag_(208), left(nullptr), words(new
                   List<word_t*>()), spids(new List<int>()) {
  }
  sh_array_literal(Token* left, List<word_t*>* words) : type_tag_(208),
                   left(left), words(words), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* left;
  List<word_t*>* words;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(sh_array_literal)
};

class arg_list {
 public:
  arg_list() : type_tag_(209), positional(new List<expr_t*>()), named(new
           List<named_arg*>()) {
  }
  arg_list(List<expr_t*>* positional, List<named_arg*>* named) :
           type_tag_(209), positional(positional), named(named) {
  }
  OBJ_HEADER();
  List<expr_t*>* positional;
  List<named_arg*>* named;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(arg_list)
};

class compound_word : public word_t, public arith_expr_t, public redir_param_t {
 public:
  compound_word() : type_tag_(210), parts(new List<word_part_t*>()) {
  }
  compound_word(List<word_part_t*>* parts) : type_tag_(210), parts(parts) {
  }
  OBJ_HEADER();
  List<word_part_t*>* parts;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(compound_word)
};

class string_line {
 public:
  string_line() : type_tag_(211), dedent(-1), part(new List<word_part_t*>()) {
  }
  string_line(int dedent, List<word_part_t*>* part) : type_tag_(211),
              dedent(dedent), part(part) {
  }
  OBJ_HEADER();
  int dedent;
  List<word_part_t*>* part;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(string_line)
};

class triple_quoted {
 public:
  triple_quoted() : type_tag_(212), min_dedent(-1), lines(new
                List<string_line*>()) {
  }
  triple_quoted(int min_dedent, List<string_line*>* lines) : type_tag_(212),
                min_dedent(min_dedent), lines(lines) {
  }
  OBJ_HEADER();
  int min_dedent;
  List<string_line*>* lines;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(triple_quoted)
};

class redir {
 public:
  redir() : type_tag_(213), op(nullptr), loc(nullptr), arg(nullptr) {
  }
  redir(Token* op, redir_loc_t* loc, redir_param_t* arg) : type_tag_(213),
        op(op), loc(loc), arg(arg) {
  }
  OBJ_HEADER();
  Token* op;
  redir_loc_t* loc;
  redir_param_t* arg;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(redir)
};

class assign_pair {
 public:
  assign_pair() : type_tag_(214), lhs(nullptr), op(assign_op_e::Equal),
              rhs(nullptr), spids(new List<int>()) {
  }
  assign_pair(sh_lhs_expr_t* lhs, assign_op_t op, word_t* rhs, List<int>*
              spids) : type_tag_(214), lhs(lhs), op(op), rhs(rhs), spids(spids)
              {
  }
  OBJ_HEADER();
  sh_lhs_expr_t* lhs;
  assign_op_t op;
  word_t* rhs;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(assign_pair)
};

class env_pair {
 public:
  env_pair() : type_tag_(215), name(new Str("")), val(nullptr), spids(new
           List<int>()) {
  }
  env_pair(Str* name, word_t* val, List<int>* spids) : type_tag_(215),
           name(name), val(val), spids(spids) {
  }
  OBJ_HEADER();
  Str* name;
  word_t* val;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(env_pair)
};

class case_arm {
 public:
  case_arm() : type_tag_(216), pat_list(new List<word_t*>()), action(new
           List<command_t*>()), spids(new List<int>()) {
  }
  case_arm(List<word_t*>* pat_list, List<command_t*>* action, List<int>* spids)
           : type_tag_(216), pat_list(pat_list), action(action), spids(spids) {
  }
  OBJ_HEADER();
  List<word_t*>* pat_list;
  List<command_t*>* action;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(case_arm)
};

class if_arm {
 public:
  if_arm() : type_tag_(217), cond(nullptr), action(new List<command_t*>()),
         spids(new List<int>()) {
  }
  if_arm(condition_t* cond, List<command_t*>* action, List<int>* spids) :
         type_tag_(217), cond(cond), action(action), spids(spids) {
  }
  OBJ_HEADER();
  condition_t* cond;
  List<command_t*>* action;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(if_arm)
};

class BraceGroup : public command_t {
 public:
  BraceGroup() : type_tag_(218), doc_token(nullptr), children(new
             List<command_t*>()), redirects(new List<redir*>()), spids(new
             List<int>()) {
  }
  BraceGroup(Token* doc_token, List<command_t*>* children, List<redir*>*
             redirects) : type_tag_(218), doc_token(doc_token),
             children(children), redirects(redirects), spids(new List<int>()) {
  }
  OBJ_HEADER();
  Token* doc_token;
  List<command_t*>* children;
  List<redir*>* redirects;
  List<int>* spids;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(BraceGroup)
};

class variant {
 public:
  variant() : type_tag_(219), tag_name(nullptr), typ(nullptr) {
  }
  variant(Token* tag_name, variant_type_t* typ) : type_tag_(219),
          tag_name(tag_name), typ(typ) {
  }
  OBJ_HEADER();
  Token* tag_name;
  variant_type_t* typ;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(variant)
};

class import_name {
 public:
  import_name() : type_tag_(220), name(nullptr), alias(nullptr) {
  }
  import_name(Token* name, Token* alias) : type_tag_(220), name(name),
              alias(alias) {
  }
  OBJ_HEADER();
  Token* name;
  Token* alias;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(import_name)
};

class param {
 public:
  param() : type_tag_(221), prefix(nullptr), name(nullptr), type(nullptr),
        default_val(nullptr) {
  }
  param(Token* prefix, Token* name, type_expr_t* type, expr_t* default_val) :
        type_tag_(221), prefix(prefix), name(name), type(type),
        default_val(default_val) {
  }
  OBJ_HEADER();
  Token* prefix;
  Token* name;
  type_expr_t* type;
  expr_t* default_val;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(param)
};

class name_type {
 public:
  name_type() : type_tag_(222), name(nullptr), typ(nullptr) {
  }
  name_type(Token* name, type_expr_t* typ) : type_tag_(222), name(name),
            typ(typ) {
  }
  OBJ_HEADER();
  Token* name;
  type_expr_t* typ;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(name_type)
};

class comprehension {
 public:
  comprehension() : type_tag_(223), lhs(new List<name_type*>()), iter(nullptr),
                cond(nullptr) {
  }
  comprehension(List<name_type*>* lhs, expr_t* iter, expr_t* cond) :
                type_tag_(223), lhs(lhs), iter(iter), cond(cond) {
  }
  OBJ_HEADER();
  List<name_type*>* lhs;
  expr_t* iter;
  expr_t* cond;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(comprehension)
};

class named_arg {
 public:
  named_arg() : type_tag_(224), name(nullptr), value(nullptr) {
  }
  named_arg(Token* name, expr_t* value) : type_tag_(224), name(name),
            value(value) {
  }
  OBJ_HEADER();
  Token* name;
  expr_t* value;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(named_arg)
};

class subscript : public place_expr_t, public expr_t {
 public:
  subscript() : type_tag_(225), obj(nullptr), indices(new List<expr_t*>()) {
  }
  subscript(expr_t* obj, List<expr_t*>* indices) : type_tag_(225), obj(obj),
            indices(indices) {
  }
  OBJ_HEADER();
  expr_t* obj;
  List<expr_t*>* indices;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(subscript)
};

class attribute : public place_expr_t, public expr_t {
 public:
  attribute() : type_tag_(226), obj(nullptr), op(nullptr), attr(nullptr),
            ctx(expr_context_e::Load) {
  }
  attribute(expr_t* obj, Token* op, Token* attr, expr_context_t ctx) :
            type_tag_(226), obj(obj), op(op), attr(attr), ctx(ctx) {
  }
  OBJ_HEADER();
  expr_t* obj;
  Token* op;
  Token* attr;
  expr_context_t ctx;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(attribute)
};

class posix_class : public class_literal_term_t, public re_t {
 public:
  posix_class() : type_tag_(227), negated(nullptr), name(new Str("")) {
  }
  posix_class(speck* negated, Str* name) : type_tag_(227), negated(negated),
              name(name) {
  }
  OBJ_HEADER();
  speck* negated;
  Str* name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(posix_class)
};

class perl_class : public class_literal_term_t, public re_t {
 public:
  perl_class() : type_tag_(228), negated(nullptr), name(new Str("")) {
  }
  perl_class(speck* negated, Str* name) : type_tag_(228), negated(negated),
             name(name) {
  }
  OBJ_HEADER();
  speck* negated;
  Str* name;
  hnode_t* PrettyTree();
  hnode_t* _AbbreviatedTree();
  hnode_t* AbbreviatedTree();

  DISALLOW_COPY_AND_ASSIGN(perl_class)
};


}  // namespace syntax_asdl

#endif  // SYNTAX_ASDL
