#ifndef ID_KIND_ASDL_H
#define ID_KIND_ASDL_H

namespace id_kind_asdl {
namespace Id {
  const int Word_Compound = 1;
  const int Arith_Semi = 2;
  const int Arith_Comma = 3;
  const int Arith_Plus = 4;
  const int Arith_Minus = 5;
  const int Arith_Star = 6;
  const int Arith_Slash = 7;
  const int Arith_Percent = 8;
  const int Arith_DPlus = 9;
  const int Arith_DMinus = 10;
  const int Arith_DStar = 11;
  const int Arith_LParen = 12;
  const int Arith_RParen = 13;
  const int Arith_LBracket = 14;
  const int Arith_RBracket = 15;
  const int Arith_RBrace = 16;
  const int Arith_QMark = 17;
  const int Arith_Colon = 18;
  const int Arith_LessEqual = 19;
  const int Arith_Less = 20;
  const int Arith_GreatEqual = 21;
  const int Arith_Great = 22;
  const int Arith_DEqual = 23;
  const int Arith_NEqual = 24;
  const int Arith_DAmp = 25;
  const int Arith_DPipe = 26;
  const int Arith_Bang = 27;
  const int Arith_DGreat = 28;
  const int Arith_DLess = 29;
  const int Arith_Amp = 30;
  const int Arith_Pipe = 31;
  const int Arith_Caret = 32;
  const int Arith_Tilde = 33;
  const int Arith_Equal = 34;
  const int Arith_PlusEqual = 35;
  const int Arith_MinusEqual = 36;
  const int Arith_StarEqual = 37;
  const int Arith_SlashEqual = 38;
  const int Arith_PercentEqual = 39;
  const int Arith_DGreatEqual = 40;
  const int Arith_DLessEqual = 41;
  const int Arith_AmpEqual = 42;
  const int Arith_PipeEqual = 43;
  const int Arith_CaretEqual = 44;
  const int Eof_Real = 45;
  const int Eof_RParen = 46;
  const int Eof_Backtick = 47;
  const int Undefined_Tok = 48;
  const int Unknown_Tok = 49;
  const int Unknown_Backslash = 50;
  const int Unknown_DEqual = 51;
  const int Eol_Tok = 52;
  const int Ignored_LineCont = 53;
  const int Ignored_Space = 54;
  const int Ignored_Comment = 55;
  const int WS_Space = 56;
  const int Lit_Chars = 57;
  const int Lit_VarLike = 58;
  const int Lit_ArrayLhsOpen = 59;
  const int Lit_ArrayLhsClose = 60;
  const int Lit_Splice = 61;
  const int Lit_AtLBraceDot = 62;
  const int Lit_Other = 63;
  const int Lit_EscapedChar = 64;
  const int Lit_RegexMeta = 65;
  const int Lit_LBracket = 66;
  const int Lit_RBracket = 67;
  const int Lit_Star = 68;
  const int Lit_QMark = 69;
  const int Lit_LBrace = 70;
  const int Lit_RBrace = 71;
  const int Lit_Comma = 72;
  const int Lit_Equals = 73;
  const int Lit_Underscore = 74;
  const int Lit_Dollar = 75;
  const int Lit_DRightBracket = 76;
  const int Lit_TildeLike = 77;
  const int Lit_Pound = 78;
  const int Lit_TPound = 79;
  const int Lit_TDot = 80;
  const int Lit_Slash = 81;
  const int Lit_Percent = 82;
  const int Lit_Colon = 83;
  const int Lit_Digits = 84;
  const int Lit_At = 85;
  const int Lit_ArithVarLike = 86;
  const int Lit_BadBackslash = 87;
  const int Lit_CompDummy = 88;
  const int Backtick_Right = 89;
  const int Backtick_Quoted = 90;
  const int Backtick_Other = 91;
  const int History_Op = 92;
  const int History_Num = 93;
  const int History_Search = 94;
  const int History_Other = 95;
  const int Op_Newline = 96;
  const int Op_Amp = 97;
  const int Op_Pipe = 98;
  const int Op_PipeAmp = 99;
  const int Op_DAmp = 100;
  const int Op_DPipe = 101;
  const int Op_Semi = 102;
  const int Op_DSemi = 103;
  const int Op_LParen = 104;
  const int Op_RParen = 105;
  const int Op_DLeftParen = 106;
  const int Op_DRightParen = 107;
  const int Op_Less = 108;
  const int Op_Great = 109;
  const int Op_Bang = 110;
  const int Op_LBracket = 111;
  const int Op_RBracket = 112;
  const int Op_LBrace = 113;
  const int Op_RBrace = 114;
  const int Expr_Reserved = 115;
  const int Expr_Symbol = 116;
  const int Expr_Name = 117;
  const int Expr_DecInt = 118;
  const int Expr_BinInt = 119;
  const int Expr_OctInt = 120;
  const int Expr_HexInt = 121;
  const int Expr_Float = 122;
  const int Expr_Bang = 123;
  const int Expr_Dot = 124;
  const int Expr_DColon = 125;
  const int Expr_RArrow = 126;
  const int Expr_RDArrow = 127;
  const int Expr_DSlash = 128;
  const int Expr_TEqual = 129;
  const int Expr_NotDEqual = 130;
  const int Expr_TildeDEqual = 131;
  const int Expr_At = 132;
  const int Expr_DoubleAt = 133;
  const int Expr_Ellipsis = 134;
  const int Expr_Dollar = 135;
  const int Expr_NotTilde = 136;
  const int Expr_DTilde = 137;
  const int Expr_NotDTilde = 138;
  const int Expr_CastedDummy = 139;
  const int Expr_Null = 140;
  const int Expr_True = 141;
  const int Expr_False = 142;
  const int Expr_And = 143;
  const int Expr_Or = 144;
  const int Expr_Not = 145;
  const int Expr_For = 146;
  const int Expr_Is = 147;
  const int Expr_In = 148;
  const int Expr_If = 149;
  const int Expr_Else = 150;
  const int Expr_Func = 151;
  const int Expr_As = 152;
  const int Expr_Virtual = 153;
  const int Expr_Override = 154;
  const int Expr_Abstract = 155;
  const int Expr_While = 156;
  const int Expr_Break = 157;
  const int Expr_Continue = 158;
  const int Expr_Return = 159;
  const int Char_OneChar = 160;
  const int Char_Stop = 161;
  const int Char_Hex = 162;
  const int Char_Octal3 = 163;
  const int Char_Octal4 = 164;
  const int Char_Unicode4 = 165;
  const int Char_Unicode8 = 166;
  const int Char_UBraced = 167;
  const int Char_Pound = 168;
  const int Char_Literals = 169;
  const int Re_Start = 170;
  const int Re_End = 171;
  const int Re_Dot = 172;
  const int Redir_Less = 173;
  const int Redir_Great = 174;
  const int Redir_DLess = 175;
  const int Redir_TLess = 176;
  const int Redir_DGreat = 177;
  const int Redir_GreatAnd = 178;
  const int Redir_LessAnd = 179;
  const int Redir_DLessDash = 180;
  const int Redir_LessGreat = 181;
  const int Redir_Clobber = 182;
  const int Redir_AndGreat = 183;
  const int Redir_AndDGreat = 184;
  const int Redir_GreatPlus = 185;
  const int Redir_DGreatPlus = 186;
  const int Left_DoubleQuote = 187;
  const int Left_SingleQuote = 188;
  const int Left_RSingleQuote = 189;
  const int Left_DollarSingleQuote = 190;
  const int Left_TDoubleQuote = 191;
  const int Left_TSingleQuote = 192;
  const int Left_RTSingleQuote = 193;
  const int Left_DollarTSingleQuote = 194;
  const int Left_Backtick = 195;
  const int Left_DollarParen = 196;
  const int Left_DollarBrace = 197;
  const int Left_DollarDParen = 198;
  const int Left_DollarBracket = 199;
  const int Left_DollarDoubleQuote = 200;
  const int Left_ProcSubIn = 201;
  const int Left_ProcSubOut = 202;
  const int Left_AtParen = 203;
  const int Left_CaretParen = 204;
  const int Left_CaretBracket = 205;
  const int Left_CaretBrace = 206;
  const int Left_PercentParen = 207;
  const int Right_DoubleQuote = 208;
  const int Right_SingleQuote = 209;
  const int Right_Backtick = 210;
  const int Right_DollarBrace = 211;
  const int Right_DollarDParen = 212;
  const int Right_DollarDoubleQuote = 213;
  const int Right_DollarSingleQuote = 214;
  const int Right_Subshell = 215;
  const int Right_ShFunction = 216;
  const int Right_CasePat = 217;
  const int Right_ShArrayLiteral = 218;
  const int Right_ExtGlob = 219;
  const int Right_BlockLiteral = 220;
  const int ExtGlob_Comma = 221;
  const int ExtGlob_At = 222;
  const int ExtGlob_Star = 223;
  const int ExtGlob_Plus = 224;
  const int ExtGlob_QMark = 225;
  const int ExtGlob_Bang = 226;
  const int VSub_DollarName = 227;
  const int VSub_Name = 228;
  const int VSub_Number = 229;
  const int VSub_Bang = 230;
  const int VSub_At = 231;
  const int VSub_Pound = 232;
  const int VSub_Dollar = 233;
  const int VSub_Star = 234;
  const int VSub_Hyphen = 235;
  const int VSub_QMark = 236;
  const int VSub_Dot = 237;
  const int VTest_ColonHyphen = 238;
  const int VTest_Hyphen = 239;
  const int VTest_ColonEquals = 240;
  const int VTest_Equals = 241;
  const int VTest_ColonQMark = 242;
  const int VTest_QMark = 243;
  const int VTest_ColonPlus = 244;
  const int VTest_Plus = 245;
  const int VOp0_Q = 246;
  const int VOp0_E = 247;
  const int VOp0_P = 248;
  const int VOp0_A = 249;
  const int VOp0_a = 250;
  const int VOp1_Percent = 251;
  const int VOp1_DPercent = 252;
  const int VOp1_Pound = 253;
  const int VOp1_DPound = 254;
  const int VOp1_Caret = 255;
  const int VOp1_DCaret = 256;
  const int VOp1_Comma = 257;
  const int VOp1_DComma = 258;
  const int VOpOil_Pipe = 259;
  const int VOpOil_Space = 260;
  const int VOp2_Slash = 261;
  const int VOp2_Colon = 262;
  const int VOp2_LBracket = 263;
  const int VOp2_RBracket = 264;
  const int VOp3_At = 265;
  const int VOp3_Star = 266;
  const int Node_PostDPlus = 267;
  const int Node_PostDMinus = 268;
  const int Node_UnaryPlus = 269;
  const int Node_UnaryMinus = 270;
  const int Node_NotIn = 271;
  const int Node_IsNot = 272;
  const int KW_DLeftBracket = 273;
  const int KW_Bang = 274;
  const int KW_For = 275;
  const int KW_While = 276;
  const int KW_Until = 277;
  const int KW_Do = 278;
  const int KW_Done = 279;
  const int KW_In = 280;
  const int KW_Case = 281;
  const int KW_Esac = 282;
  const int KW_If = 283;
  const int KW_Fi = 284;
  const int KW_Then = 285;
  const int KW_Else = 286;
  const int KW_Elif = 287;
  const int KW_Function = 288;
  const int KW_Time = 289;
  const int KW_Const = 290;
  const int KW_Var = 291;
  const int KW_SetVar = 292;
  const int KW_SetRef = 293;
  const int KW_SetGlobal = 294;
  const int KW_Proc = 295;
  const int KW_Func = 296;
  const int KW_Data = 297;
  const int KW_Enum = 298;
  const int KW_Class = 299;
  const int KW_Import = 300;
  const int ControlFlow_Break = 301;
  const int ControlFlow_Continue = 302;
  const int ControlFlow_Return = 303;
  const int ControlFlow_Exit = 304;
  const int LookAhead_FuncParens = 305;
  const int Glob_LBracket = 306;
  const int Glob_RBracket = 307;
  const int Glob_Star = 308;
  const int Glob_QMark = 309;
  const int Glob_Bang = 310;
  const int Glob_Caret = 311;
  const int Glob_EscapedChar = 312;
  const int Glob_BadBackslash = 313;
  const int Glob_CleanLiterals = 314;
  const int Glob_OtherLiteral = 315;
  const int Format_EscapedPercent = 316;
  const int Format_Percent = 317;
  const int Format_Flag = 318;
  const int Format_Num = 319;
  const int Format_Dot = 320;
  const int Format_Type = 321;
  const int Format_Star = 322;
  const int Format_Time = 323;
  const int Format_Zero = 324;
  const int PS_Subst = 325;
  const int PS_Octal3 = 326;
  const int PS_LBrace = 327;
  const int PS_RBrace = 328;
  const int PS_Literals = 329;
  const int PS_BadBackslash = 330;
  const int Range_Int = 331;
  const int Range_Char = 332;
  const int Range_Dots = 333;
  const int Range_Other = 334;
  const int QSN_LiteralBytes = 335;
  const int QSN_SpecialByte = 336;
  const int QSN_Begin2 = 337;
  const int QSN_Begin3 = 338;
  const int QSN_Begin4 = 339;
  const int QSN_Cont = 340;
  const int BoolUnary_z = 341;
  const int BoolUnary_n = 342;
  const int BoolUnary_o = 343;
  const int BoolUnary_t = 344;
  const int BoolUnary_v = 345;
  const int BoolUnary_R = 346;
  const int BoolUnary_a = 347;
  const int BoolUnary_b = 348;
  const int BoolUnary_c = 349;
  const int BoolUnary_d = 350;
  const int BoolUnary_e = 351;
  const int BoolUnary_f = 352;
  const int BoolUnary_g = 353;
  const int BoolUnary_h = 354;
  const int BoolUnary_k = 355;
  const int BoolUnary_L = 356;
  const int BoolUnary_p = 357;
  const int BoolUnary_r = 358;
  const int BoolUnary_s = 359;
  const int BoolUnary_S = 360;
  const int BoolUnary_u = 361;
  const int BoolUnary_w = 362;
  const int BoolUnary_x = 363;
  const int BoolUnary_O = 364;
  const int BoolUnary_G = 365;
  const int BoolUnary_N = 366;
  const int BoolBinary_GlobEqual = 367;
  const int BoolBinary_GlobDEqual = 368;
  const int BoolBinary_GlobNEqual = 369;
  const int BoolBinary_EqualTilde = 370;
  const int BoolBinary_ef = 371;
  const int BoolBinary_nt = 372;
  const int BoolBinary_ot = 373;
  const int BoolBinary_eq = 374;
  const int BoolBinary_ne = 375;
  const int BoolBinary_gt = 376;
  const int BoolBinary_ge = 377;
  const int BoolBinary_lt = 378;
  const int BoolBinary_le = 379;
  const int BoolBinary_Equal = 380;
  const int BoolBinary_DEqual = 381;
  const int BoolBinary_NEqual = 382;
  const int ARRAY_SIZE = 383;
};

const char* Id_str(int tag);

typedef int Id_t;

enum class Kind {
  Word = 1,
  Arith = 2,
  Eof = 3,
  Undefined = 4,
  Unknown = 5,
  Eol = 6,
  Ignored = 7,
  WS = 8,
  Lit = 9,
  Backtick = 10,
  History = 11,
  Op = 12,
  Expr = 13,
  Char = 14,
  Re = 15,
  Redir = 16,
  Left = 17,
  Right = 18,
  ExtGlob = 19,
  VSub = 20,
  VTest = 21,
  VOp0 = 22,
  VOp1 = 23,
  VOpOil = 24,
  VOp2 = 25,
  VOp3 = 26,
  Node = 27,
  KW = 28,
  ControlFlow = 29,
  LookAhead = 30,
  Glob = 31,
  Format = 32,
  PS = 33,
  Range = 34,
  QSN = 35,
  BoolUnary = 36,
  BoolBinary = 37,
};
typedef Kind Kind_t;

const char* Kind_str(Kind tag);


}  // namespace id_kind_asdl

#endif  // ID_KIND_ASDL_H
