#ifndef OPTION_ASDL_H
#define OPTION_ASDL_H

namespace option_asdl {
namespace option_i {
  const int errexit = 1;
  const int nounset = 2;
  const int pipefail = 3;
  const int inherit_errexit = 4;
  const int nullglob = 5;
  const int verbose_errexit = 6;
  const int noexec = 7;
  const int xtrace = 8;
  const int verbose = 9;
  const int noglob = 10;
  const int noclobber = 11;
  const int posix = 12;
  const int vi = 13;
  const int emacs = 14;
  const int interactive = 15;
  const int hashall = 16;
  const int failglob = 17;
  const int extglob = 18;
  const int eval_unsafe_arith = 19;
  const int parse_dynamic_arith = 20;
  const int compat_array = 21;
  const int allow_command_sub = 22;
  const int dynamic_scope = 23;
  const int redefine_module = 24;
  const int _running_trap = 25;
  const int strict_argv = 26;
  const int strict_arith = 27;
  const int strict_array = 28;
  const int strict_control_flow = 29;
  const int strict_errexit = 30;
  const int strict_nameref = 31;
  const int strict_word_eval = 32;
  const int strict_tilde = 33;
  const int strict_glob = 34;
  const int parse_at = 35;
  const int parse_brace = 36;
  const int parse_paren = 37;
  const int parse_raw_string = 38;
  const int parse_triple_quote = 39;
  const int simple_word_eval = 40;
  const int dashglob = 41;
  const int expand_aliases = 42;
  const int command_sub_errexit = 43;
  const int process_sub_fail = 44;
  const int xtrace_rich = 45;
  const int xtrace_details = 46;
  const int sigpipe_status_ok = 47;
  const int redefine_proc = 48;
  const int parse_equals = 49;
  const int parse_at_all = 50;
  const int parse_backslash = 51;
  const int parse_backticks = 52;
  const int parse_dollar = 53;
  const int parse_ignored = 54;
  const int parse_amp = 55;
  const int simple_echo = 56;
  const int simple_eval_builtin = 57;
  const int simple_test_builtin = 58;
  const int parse_tea = 59;
  const int lastpipe = 60;
  const int progcomp = 61;
  const int histappend = 62;
  const int hostcomplete = 63;
  const int cmdhist = 64;
  const int assoc_expand_once = 65;
  const int autocd = 66;
  const int cdable_vars = 67;
  const int cdspell = 68;
  const int checkhash = 69;
  const int checkjobs = 70;
  const int checkwinsize = 71;
  const int complete_fullquote = 72;
  const int direxpand = 73;
  const int dirspell = 74;
  const int dotglob = 75;
  const int execfail = 76;
  const int extdebug = 77;
  const int extquote = 78;
  const int force_fignore = 79;
  const int globasciiranges = 80;
  const int globstar = 81;
  const int gnu_errfmt = 82;
  const int histreedit = 83;
  const int histverify = 84;
  const int huponexit = 85;
  const int interactive_comments = 86;
  const int lithist = 87;
  const int localvar_inherit = 88;
  const int localvar_unset = 89;
  const int login_shell = 90;
  const int mailwarn = 91;
  const int no_empty_cmd_completion = 92;
  const int nocaseglob = 93;
  const int nocasematch = 94;
  const int progcomp_alias = 95;
  const int promptvars = 96;
  const int restricted_shell = 97;
  const int shift_verbose = 98;
  const int sourcepath = 99;
  const int xpg_echo = 100;
  const int ARRAY_SIZE = 101;
};

const char* option_str(int tag);

typedef int option_t;

namespace builtin_i {
  const int colon = 1;
  const int dot = 2;
  const int exec_ = 3;
  const int eval = 4;
  const int set = 5;
  const int shift = 6;
  const int times = 7;
  const int trap = 8;
  const int unset = 9;
  const int builtin = 10;
  const int readonly = 11;
  const int local = 12;
  const int declare = 13;
  const int typeset = 14;
  const int export_ = 15;
  const int test = 16;
  const int bracket = 17;
  const int true_ = 18;
  const int false_ = 19;
  const int try_ = 20;
  const int read = 21;
  const int echo = 22;
  const int printf = 23;
  const int mapfile = 24;
  const int readarray = 25;
  const int cd = 26;
  const int pushd = 27;
  const int popd = 28;
  const int dirs = 29;
  const int pwd = 30;
  const int source = 31;
  const int umask = 32;
  const int wait = 33;
  const int jobs = 34;
  const int fg = 35;
  const int bg = 36;
  const int shopt = 37;
  const int complete = 38;
  const int compgen = 39;
  const int compopt = 40;
  const int compadjust = 41;
  const int getopts = 42;
  const int command = 43;
  const int type = 44;
  const int hash = 45;
  const int help = 46;
  const int history = 47;
  const int alias = 48;
  const int unalias = 49;
  const int bind = 50;
  const int append = 51;
  const int shvar = 52;
  const int write = 53;
  const int json = 54;
  const int pp = 55;
  const int module = 56;
  const int use = 57;
  const int argparse = 58;
  const int fopen = 59;
  const int fork = 60;
  const int forkwait = 61;
  const int runproc = 62;
  const int push_registers = 63;
  const int cat = 64;
  const int ARRAY_SIZE = 65;
};

const char* builtin_str(int tag);

typedef int builtin_t;


}  // namespace option_asdl

#endif  // OPTION_ASDL_H
